/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.hdfs.client;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.SecureClientLogin;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ranger.plugin.client.BaseClient;
import org.apache.ranger.plugin.client.HadoopException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsClient
extends BaseClient {
    private static final Logger LOG = LoggerFactory.getLogger(HdfsClient.class);
    private Configuration conf = new Configuration();

    public HdfsClient(String serviceName, Map<String, String> connectionProperties) {
        super(serviceName, connectionProperties, "hdfs-client");
        Set rangerInternalPropertyKeys = this.getConfigHolder().getRangerInternalPropertyKeys();
        for (Map.Entry<String, String> entry : connectionProperties.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (rangerInternalPropertyKeys.contains(key) || value == null) continue;
            this.conf.set(key, value);
        }
    }

    private List<String> listFilesInternal(String baseDir, String fileMatching, List<String> pathList) throws HadoopException {
        ArrayList<String> fileList = new ArrayList<String>();
        String errMsg = " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info.";
        try {
            String dirPrefix = baseDir.endsWith("/") ? baseDir : baseDir + "/";
            String filterRegEx = null;
            if (fileMatching != null && fileMatching.trim().length() > 0) {
                filterRegEx = fileMatching.trim();
            }
            UserGroupInformation.setConfiguration((Configuration)this.conf);
            FileSystem fs = null;
            try {
                fs = FileSystem.get((Configuration)this.conf);
                Path basePath = new Path(baseDir);
                Object[] fileStatus = fs.listStatus(basePath);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("<== HdfsClient fileStatus : " + fileStatus.length + " PathList :" + pathList);
                }
                if (fileStatus != null) {
                    if (fs.exists(basePath) && ArrayUtils.isEmpty((Object[])fileStatus)) {
                        fileList.add(basePath.toString());
                    } else {
                        for (Object stat : fileStatus) {
                            Path path = stat.getPath();
                            String pathComponent = path.getName();
                            String prefixedPath = dirPrefix + pathComponent;
                            if (pathList != null && pathList.contains(prefixedPath)) continue;
                            if (filterRegEx == null) {
                                fileList.add(prefixedPath);
                                continue;
                            }
                            if (!FilenameUtils.wildcardMatch((String)pathComponent, (String)fileMatching)) continue;
                            fileList.add(prefixedPath);
                        }
                    }
                }
            }
            catch (UnknownHostException uhe) {
                String msgDesc = "listFilesInternal: Unable to connect using given config parameters of Hadoop environment [" + this.getSerivceName() + "].";
                HadoopException hdpException = new HadoopException(msgDesc, (Throwable)uhe);
                hdpException.generateResponseDataMap(false, HdfsClient.getMessage((Throwable)uhe), msgDesc + errMsg, null, null);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("<== HdfsClient listFilesInternal Error : " + uhe);
                }
                throw hdpException;
            }
            catch (FileNotFoundException fne) {
                String msgDesc = "listFilesInternal: Unable to locate files using given config parameters of Hadoop environment [" + this.getSerivceName() + "].";
                HadoopException hdpException = new HadoopException(msgDesc, (Throwable)fne);
                hdpException.generateResponseDataMap(false, HdfsClient.getMessage((Throwable)fne), msgDesc + errMsg, null, null);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("<== HdfsClient listFilesInternal Error : " + fne);
                }
                throw hdpException;
            }
        }
        catch (IOException ioe) {
            String msgDesc = "listFilesInternal: Unable to get listing of files for directory " + baseDir + fileMatching + "] from Hadoop environment [" + this.getSerivceName() + "].";
            HadoopException hdpException = new HadoopException(msgDesc, (Throwable)ioe);
            hdpException.generateResponseDataMap(false, HdfsClient.getMessage((Throwable)ioe), msgDesc + errMsg, null, null);
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== HdfsClient listFilesInternal Error : " + ioe);
            }
            throw hdpException;
        }
        catch (IllegalArgumentException iae) {
            String msgDesc = "Unable to get listing of files for directory [" + baseDir + "] from Hadoop environment [" + this.getSerivceName() + "].";
            HadoopException hdpException = new HadoopException(msgDesc, (Throwable)iae);
            hdpException.generateResponseDataMap(false, HdfsClient.getMessage((Throwable)iae), msgDesc + errMsg, null, null);
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== HdfsClient listFilesInternal Error : " + iae);
            }
            throw hdpException;
        }
        return fileList;
    }

    public List<String> listFiles(final String baseDir, final String fileMatching, final List<String> pathList) throws Exception {
        PrivilegedExceptionAction<List<String>> action = new PrivilegedExceptionAction<List<String>>(){

            @Override
            public List<String> run() throws Exception {
                return HdfsClient.this.listFilesInternal(baseDir, fileMatching, pathList);
            }
        };
        return Subject.doAs(this.getLoginSubject(), action);
    }

    public static final void main(String[] args) {
        if (args.length < 2) {
            System.err.println("USAGE: java " + HdfsClient.class.getName() + " repositoryName  basedirectory  [filenameToMatch]");
            System.exit(1);
        }
        String repositoryName = args[0];
        String baseDir = args[1];
        String fileNameToMatch = args.length == 2 ? null : args[2];
        HdfsClient fs = new HdfsClient(repositoryName, new HashMap<String, String>());
        List<String> fsList = null;
        try {
            fsList = fs.listFiles(baseDir, fileNameToMatch, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (fsList != null && fsList.size() > 0) {
            for (String s : fsList) {
                System.out.println(s);
            }
        } else {
            System.err.println("Unable to get file listing for [" + baseDir + (baseDir.endsWith("/") ? "" : "/") + fileNameToMatch + "]  in repository [" + repositoryName + "]");
        }
    }

    public static Map<String, Object> connectionTest(String serviceName, Map<String, String> configs) throws Exception {
        HdfsClient connectionObj;
        LOG.info("===> HdfsClient.connectionTest()");
        HashMap<String, Object> responseData = new HashMap<String, Object>();
        boolean connectivityStatus = false;
        String validateConfigsMsg = null;
        try {
            HdfsClient.validateConnectionConfigs(configs);
        }
        catch (IllegalArgumentException e) {
            validateConfigsMsg = e.getMessage();
        }
        if (validateConfigsMsg == null && (connectionObj = new HdfsClient(serviceName, configs)) != null) {
            List<String> testResult = null;
            try {
                testResult = connectionObj.listFiles("/", null, null);
            }
            catch (HadoopException e) {
                LOG.error("<== HdfsClient.connectionTest() error " + e.getMessage(), (Throwable)e);
                throw e;
            }
            if (testResult != null && testResult.size() != 0) {
                connectivityStatus = true;
            }
        }
        String testconnMsg = null;
        if (connectivityStatus) {
            testconnMsg = "ConnectionTest Successful";
            HdfsClient.generateResponseDataMap((boolean)connectivityStatus, (String)testconnMsg, (String)testconnMsg, null, null, responseData);
        } else {
            testconnMsg = "Unable to retrieve any files using given parameters, You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info. ";
            String additionalMsg = validateConfigsMsg != null ? validateConfigsMsg : testconnMsg;
            HdfsClient.generateResponseDataMap((boolean)connectivityStatus, (String)testconnMsg, (String)additionalMsg, null, null, responseData);
        }
        LOG.info("<== HdfsClient.connectionTest(): Status " + testconnMsg);
        return responseData;
    }

    public static void validateConnectionConfigs(Map<String, String> configs) throws IllegalArgumentException {
        String dfsNameservices;
        String[] fsDefaultNameElements;
        String authentication;
        String lookupPrincipal = null;
        try {
            lookupPrincipal = SecureClientLogin.getPrincipal((String)configs.get("lookupprincipal"), (String)InetAddress.getLocalHost().getCanonicalHostName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        String lookupKeytab = configs.get("lookupkeytab");
        if (StringUtils.isEmpty((String)lookupPrincipal) || StringUtils.isEmpty((String)lookupKeytab)) {
            String username = configs.get("username");
            if (username == null || username.isEmpty()) {
                throw new IllegalArgumentException("Value for username not specified");
            }
            String password = configs.get("password");
            if (password == null || password.isEmpty()) {
                throw new IllegalArgumentException("Value for password not specified");
            }
        }
        if ((authentication = configs.get("hadoop.security.authentication")) == null || authentication.isEmpty()) {
            throw new IllegalArgumentException("Value for hadoop.security.authentication not specified");
        }
        String fsDefaultName = configs.get("fs.default.name");
        String string = fsDefaultName = fsDefaultName == null ? "" : fsDefaultName.trim();
        if (fsDefaultName.isEmpty()) {
            throw new IllegalArgumentException("Value for fs.default.name not specified");
        }
        for (String fsDefaultNameElement : fsDefaultNameElements = fsDefaultName.split(",")) {
            if (!fsDefaultNameElement.isEmpty()) continue;
            throw new IllegalArgumentException("Value for fs.default.name element" + fsDefaultNameElement + " not specified");
        }
        if (fsDefaultNameElements != null && fsDefaultNameElements.length >= 2) {
            String cluster = "";
            StringBuilder clusters = new StringBuilder();
            configs.put("dfs.nameservices", "hdfscluster");
            configs.put("fs.default.name", "hdfs://" + configs.get("dfs.nameservices"));
            configs.put("dfs.client.failover.proxy.provider." + configs.get("dfs.nameservices"), "org.apache.hadoop.hdfs.server.namenode.ha.ConfiguredFailoverProxyProvider");
            for (int i = 0; i < fsDefaultNameElements.length; ++i) {
                cluster = "namenode" + (i + 1);
                configs.put("dfs.namenode.rpc-address." + configs.get("dfs.nameservices") + "." + cluster, fsDefaultNameElements[i]);
                if (i == fsDefaultNameElements.length - 1) {
                    clusters.append(cluster);
                    continue;
                }
                clusters.append(cluster).append(",");
            }
            configs.put("dfs.ha.namenodes." + configs.get("dfs.nameservices"), clusters.toString());
        }
        String string2 = dfsNameservices = (dfsNameservices = configs.get("dfs.nameservices")) == null ? "" : dfsNameservices.trim();
        if (!dfsNameservices.isEmpty()) {
            String[] dfsNameserviceElements;
            for (String dfsNameserviceElement : dfsNameserviceElements = dfsNameservices.split(",")) {
                String[] dfsNameNodeElements;
                String proxyProvider = configs.get("dfs.client.failover.proxy.provider." + dfsNameserviceElement);
                String string3 = proxyProvider = proxyProvider == null ? "" : proxyProvider.trim();
                if (proxyProvider.isEmpty()) {
                    throw new IllegalArgumentException("Value for dfs.client.failover.proxy.provider." + dfsNameserviceElement + " not specified");
                }
                String dfsNameNodes = configs.get("dfs.ha.namenodes." + dfsNameserviceElement);
                String string4 = dfsNameNodes = dfsNameNodes == null ? "" : dfsNameNodes.trim();
                if (dfsNameNodes.isEmpty()) {
                    throw new IllegalArgumentException("Value for dfs.ha.namenodes." + dfsNameserviceElement + " not specified");
                }
                for (String dfsNameNodeElement : dfsNameNodeElements = dfsNameNodes.split(",")) {
                    String nameNodeUrlKey = "dfs.namenode.rpc-address." + dfsNameserviceElement + "." + dfsNameNodeElement.trim();
                    String nameNodeUrl = configs.get(nameNodeUrlKey);
                    String string5 = nameNodeUrl = nameNodeUrl == null ? "" : nameNodeUrl.trim();
                    if (!nameNodeUrl.isEmpty()) continue;
                    throw new IllegalArgumentException("Value for " + nameNodeUrlKey + " not specified");
                }
            }
        }
    }
}

