/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.test.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import org.apache.qpid.test.utils.UnitTestBase;
import org.junit.jupiter.api.TestInfo;

public class TestFileUtils {
    private static final String SYSTEM_TMP_DIR = System.getProperty("java.io.tmpdir");
    private static final String SUFFIX = "tmp";

    public static File createTestDirectory() {
        String dirNameStem = TestFileUtils.class.getSimpleName() + "-testDir";
        return TestFileUtils.createTestDirectory(dirNameStem, true);
    }

    public static File createTestDirectory(String dirNameStem, boolean deleteOnExit) {
        File testDir = new File(SYSTEM_TMP_DIR, dirNameStem + "-" + System.currentTimeMillis());
        if (testDir.exists()) {
            TestFileUtils.delete(testDir, true);
        }
        testDir.mkdirs();
        if (deleteOnExit) {
            testDir.deleteOnExit();
        }
        return testDir;
    }

    public static File createTempFile(TestInfo testInfo) {
        return TestFileUtils.createTempFile(testInfo, SUFFIX);
    }

    public static File createTempFile(UnitTestBase testcase) {
        return TestFileUtils.createTempFile(testcase, SUFFIX);
    }

    public static File createTempFile(TestInfo testInfo, String suffix) {
        File tmpFile;
        String className = ((Class)testInfo.getTestClass().orElseThrow(() -> new RuntimeException("Failed to resolve test class"))).getSimpleName();
        String methodName = ((Method)testInfo.getTestMethod().orElseThrow(() -> new RuntimeException("Failed to resolve test method"))).getName();
        String prefix = className + "-" + methodName;
        try {
            tmpFile = File.createTempFile(prefix, suffix);
            tmpFile.deleteOnExit();
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Cannot create temporary file with prefix '%s' and suffix '%s'. ${java.io.tmpdir}='%s'", prefix, suffix, System.getProperty("java.io.tmpdir")), e);
        }
        return tmpFile;
    }

    public static File createTempFile(UnitTestBase testcase, String suffix) {
        File tmpFile;
        String prefix = testcase.getTestClassName() + "-" + testcase.getTestName();
        try {
            tmpFile = File.createTempFile(prefix, suffix);
            tmpFile.deleteOnExit();
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Cannot create temporary file with prefix '%s' and suffix '%s'. ${java.io.tmpdir}='%s'", prefix, suffix, System.getProperty("java.io.tmpdir")), e);
        }
        return tmpFile;
    }

    public static File createTempFileFromResource(UnitTestBase testCase, String resourceName) {
        File dst = TestFileUtils.createTempFile(testCase, resourceName);
        try (InputStream in = testCase.getClass().getResourceAsStream(resourceName);){
            TestFileUtils.copy(in, dst);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot copy resource " + resourceName + " to temp file " + dst.getAbsolutePath(), e);
        }
        dst.deleteOnExit();
        return dst;
    }

    public static File createTempFile(UnitTestBase testcase, String suffix, String content) {
        File file = TestFileUtils.createTempFile(testcase, suffix);
        if (content != null) {
            TestFileUtils.saveTextContentInFile(content, file);
        }
        return file;
    }

    public static void saveTextContentInFile(String content, File file) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            fos.write(content.getBytes("UTF-8"));
            fos.flush();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot add the content into temp file " + file.getAbsolutePath(), e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Cannot close output stream into temp file " + file.getAbsolutePath(), e);
                }
            }
        }
    }

    public static boolean delete(File file, boolean recursive) {
        boolean success = true;
        if (file.isDirectory()) {
            if (recursive) {
                File[] files = file.listFiles();
                if (files == null) {
                    return false;
                }
                for (int i = 0; i < files.length; ++i) {
                    success = TestFileUtils.delete(files[i], true) && success;
                }
                return success && file.delete();
            }
            return false;
        }
        return file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream in, File dst) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("Provided InputStream must not be null");
        }
        try {
            if (!dst.exists()) {
                dst.createNewFile();
            }
            try (FileOutputStream out = new FileOutputStream(dst);){
                int len;
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
            }
        }
        finally {
            in.close();
        }
    }
}

