/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.tracing;

import java.io.IOException;
import java.net.URI;
import org.apache.qpid.jms.tracing.JmsTracer;
import org.apache.qpid.jms.util.FactoryFinder;

public abstract class JmsTracerFactory {
    private static final FactoryFinder<JmsTracerFactory> TRACER_FACTORY_FINDER = new FactoryFinder<JmsTracerFactory>(JmsTracerFactory.class, "META-INF/services/" + JmsTracerFactory.class.getPackage().getName().replace(".", "/") + "/");

    public abstract JmsTracer createTracer(URI var1, String var2) throws Exception;

    public static JmsTracer create(URI remoteURI, String name) throws Exception {
        JmsTracerFactory factory = JmsTracerFactory.findTracerFactory(name);
        return factory.createTracer(remoteURI, name);
    }

    public static JmsTracerFactory findTracerFactory(String name) throws IOException {
        if (name == null || name.isEmpty()) {
            throw new IOException("No Tracer name specified.");
        }
        JmsTracerFactory factory = null;
        try {
            factory = TRACER_FACTORY_FINDER.newInstance(name);
        }
        catch (Throwable e) {
            throw new IOException("Tracer name NOT recognized: [" + name + "]", e);
        }
        return factory;
    }
}

