/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.util;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import org.apache.qpid.jms.util.StringArrayConverter;
import org.apache.qpid.jms.util.TypeConversionSupport;

public class PropertyUtil {
    private static final String UTF8 = "UTF-8";

    public static URI replaceQuery(URI originalURI, Map<String, String> properties) throws URISyntaxException {
        String queryString = PropertyUtil.createQueryString(properties);
        if (queryString.length() == 0) {
            queryString = null;
        }
        return PropertyUtil.replaceQuery(originalURI, queryString);
    }

    public static URI replaceQuery(URI uri, String query) throws URISyntaxException {
        int questionMark;
        Object uriAsString = uri.toString();
        String fragment = null;
        int hashMark = ((String)uriAsString).lastIndexOf("#");
        if (hashMark < ((String)uriAsString).lastIndexOf(")")) {
            hashMark = -1;
        }
        if (hashMark > 0) {
            fragment = ((String)uriAsString).substring(hashMark);
            uriAsString = ((String)uriAsString).substring(0, hashMark);
        }
        if ((questionMark = ((String)uriAsString).lastIndexOf("?")) < ((String)uriAsString).lastIndexOf(")")) {
            questionMark = -1;
        }
        if (questionMark > 0) {
            uriAsString = ((String)uriAsString).substring(0, questionMark);
        }
        if (query != null && query.length() > 0) {
            uriAsString = (String)uriAsString + "?" + query;
        }
        if (fragment != null && fragment.length() > 0) {
            uriAsString = (String)uriAsString + fragment;
        }
        return new URI((String)uriAsString);
    }

    public static URI eraseQuery(URI uri) throws URISyntaxException {
        return PropertyUtil.replaceQuery(uri, (String)null);
    }

    public static String createQueryString(Map<String, ? extends Object> options) throws URISyntaxException {
        try {
            if (options.size() > 0) {
                StringBuffer rc = new StringBuffer();
                boolean first = true;
                for (Map.Entry<String, ? extends Object> entry : options.entrySet()) {
                    if (first) {
                        first = false;
                    } else {
                        rc.append("&");
                    }
                    rc.append(URLEncoder.encode(entry.getKey(), UTF8));
                    rc.append("=");
                    rc.append(URLEncoder.encode((String)entry.getValue(), UTF8));
                }
                return rc.toString();
            }
            return "";
        }
        catch (UnsupportedEncodingException e) {
            throw (URISyntaxException)new URISyntaxException(e.toString(), "Invalid encoding").initCause(e);
        }
    }

    public static Map<String, String> parseQuery(URI uri) throws Exception {
        if (uri == null) {
            return Collections.emptyMap();
        }
        return PropertyUtil.parseQuery(uri.getRawQuery());
    }

    public static Map<String, String> parseQuery(String queryString) throws Exception {
        if (queryString != null && !queryString.isEmpty()) {
            LinkedHashMap<String, String> rc = new LinkedHashMap<String, String>();
            String[] parameters = queryString.split("&");
            for (int i = 0; i < parameters.length; ++i) {
                int p = parameters[i].indexOf("=");
                if (p >= 0) {
                    String name = URLDecoder.decode(parameters[i].substring(0, p), UTF8);
                    String value = URLDecoder.decode(parameters[i].substring(p + 1), UTF8);
                    rc.put(name, value);
                    continue;
                }
                rc.put(parameters[i], null);
            }
            return rc;
        }
        return Collections.emptyMap();
    }

    public static Map<String, String> filterProperties(Map<String, String> properties, String optionPrefix) {
        if (properties == null) {
            throw new IllegalArgumentException("The given properties object was null.");
        }
        LinkedHashMap<String, String> rc = new LinkedHashMap<String, String>(properties.size());
        Iterator<Map.Entry<String, String>> iter = properties.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, String> entry = iter.next();
            if (!entry.getKey().startsWith(optionPrefix)) continue;
            String name = entry.getKey().substring(optionPrefix.length());
            rc.put(name, entry.getValue());
            iter.remove();
        }
        return rc;
    }

    public static Map<String, String> setProperties(Object target, Map<String, String> properties) {
        if (target == null) {
            throw new IllegalArgumentException("target object cannot be null");
        }
        if (properties == null) {
            throw new IllegalArgumentException("Given Properties object cannot be null");
        }
        LinkedHashMap<String, String> unmatched = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (PropertyUtil.setProperty(target, entry.getKey(), entry.getValue())) continue;
            unmatched.put(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(unmatched);
    }

    public static Map<String, Object> setProperties(Object target, Properties properties) {
        if (target == null) {
            throw new IllegalArgumentException("target object cannot be null");
        }
        if (properties == null) {
            throw new IllegalArgumentException("Given Properties object cannot be null");
        }
        LinkedHashMap<String, Object> unmatched = new LinkedHashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (PropertyUtil.setProperty(target, (String)entry.getKey(), entry.getValue())) continue;
            unmatched.put((String)entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(unmatched);
    }

    public static Map<String, String> getProperties(Object object) throws Exception {
        if (object == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
        Object[] NULL_ARG = new Object[]{};
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        if (propertyDescriptors != null) {
            for (int i = 0; i < propertyDescriptors.length; ++i) {
                Object value;
                PropertyDescriptor pd = propertyDescriptors[i];
                if (pd.getReadMethod() == null || pd.getName().equals("class") || pd.getName().equals("properties") || pd.getName().equals("reference") || (value = pd.getReadMethod().invoke(object, NULL_ARG)) == null) continue;
                if (value instanceof Boolean || value instanceof Number || value instanceof String || value instanceof URI || value instanceof URL) {
                    properties.put(pd.getName(), "" + value);
                    continue;
                }
                if (value instanceof SSLContext) continue;
                Map<String, String> inner = PropertyUtil.getProperties(value);
                for (Map.Entry<String, String> entry : inner.entrySet()) {
                    properties.put(pd.getName() + "." + entry.getKey(), entry.getValue());
                }
            }
        }
        return properties;
    }

    public static Object getProperty(Object object, String name) throws Exception {
        BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        if (propertyDescriptors != null) {
            for (int i = 0; i < propertyDescriptors.length; ++i) {
                PropertyDescriptor pd = propertyDescriptors[i];
                if (pd.getReadMethod() == null || !pd.getName().equals(name)) continue;
                return pd.getReadMethod().invoke(object, new Object[0]);
            }
        }
        return null;
    }

    public static boolean setProperty(Object target, String name, Object value) {
        try {
            int dotPos = name.indexOf(".");
            while (dotPos >= 0) {
                String getterName = name.substring(0, dotPos);
                target = PropertyUtil.getProperty(target, getterName);
                name = name.substring(dotPos + 1);
                dotPos = name.indexOf(".");
            }
            Class<?> clazz = target.getClass();
            List<Method> setters = PropertyUtil.findSetterMethod(clazz, name);
            if (setters == null || setters.isEmpty()) {
                return false;
            }
            Throwable failure = null;
            for (Method setter : setters) {
                if (value == null || value.getClass() == setter.getParameterTypes()[0]) {
                    try {
                        setter.invoke(target, value);
                        failure = null;
                        break;
                    }
                    catch (Throwable error) {
                        failure = error;
                        continue;
                    }
                }
                try {
                    setter.invoke(target, PropertyUtil.convert(value, setter.getParameterTypes()[0]));
                    failure = null;
                    break;
                }
                catch (Throwable error) {
                    failure = error;
                }
            }
            return failure == null;
        }
        catch (Throwable ignore) {
            return false;
        }
    }

    public static String stripPrefix(String value, String prefix) {
        if (value != null && prefix != null && value.startsWith(prefix)) {
            return value.substring(prefix.length());
        }
        return value;
    }

    public static String stripUpto(String value, char c) {
        int index;
        String result = null;
        if (value != null && (index = value.indexOf(c)) > 0) {
            result = value.substring(index + 1);
        }
        return result;
    }

    public static String stripBefore(String value, char c) {
        int index;
        String result = value;
        if (value != null && (index = value.indexOf(c)) > 0) {
            result = value.substring(0, index);
        }
        return result;
    }

    private static List<Method> findSetterMethod(Class<? extends Object> clazz, String name) {
        ArrayList<Method> matches = new ArrayList<Method>();
        name = "set" + ((String)name).substring(0, 1).toUpperCase() + ((String)name).substring(1);
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            Class<?>[] params = method.getParameterTypes();
            if (!method.getName().equals(name) || params.length != 1) continue;
            matches.add(method);
        }
        return matches;
    }

    private static Object convert(Object value, Class<?> type) throws Exception {
        if (value == null) {
            if (Boolean.TYPE.isAssignableFrom(type)) {
                return Boolean.FALSE;
            }
            return null;
        }
        if (type.isAssignableFrom(value.getClass())) {
            return type.cast(value);
        }
        if (type.isAssignableFrom(String[].class)) {
            return StringArrayConverter.convertToStringArray(value);
        }
        if (type == URI.class) {
            return new URI(value.toString());
        }
        return TypeConversionSupport.convert(value, type);
    }
}

