/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.message;

import org.apache.qpid.jms.message.JmsMessage;
import org.apache.qpid.jms.meta.JmsAbstractResourceId;
import org.apache.qpid.jms.meta.JmsConsumerId;
import org.apache.qpid.jms.meta.JmsConsumerInfo;

public class JmsInboundMessageDispatch
extends JmsAbstractResourceId {
    private JmsConsumerId consumerId;
    private Object messageId;
    private final long sequence;
    private JmsMessage message;
    private boolean enqueueFirst;
    private boolean delivered;
    private transient JmsConsumerInfo consumerInfo;
    private transient String stringView;

    public JmsInboundMessageDispatch(long sequence) {
        this.sequence = sequence;
    }

    public JmsMessage getMessage() {
        return this.message;
    }

    public void setMessage(JmsMessage message) {
        this.message = message;
    }

    public JmsConsumerId getConsumerId() {
        return this.consumerId;
    }

    public void setConsumerId(JmsConsumerId consumerId) {
        this.consumerId = consumerId;
    }

    public void setMessageId(Object object) {
        this.messageId = object;
    }

    public void setEnqueueFirst(boolean insertAtFront) {
        this.enqueueFirst = insertAtFront;
    }

    public boolean isEnqueueFirst() {
        return this.enqueueFirst;
    }

    public boolean isDelivered() {
        return this.delivered;
    }

    public void setDelivered(boolean delivered) {
        this.delivered = delivered;
    }

    public int getRedeliveryCount() {
        int redeliveryCount = 0;
        if (this.message != null) {
            redeliveryCount = this.message.getFacade().getRedeliveryCount();
        }
        return redeliveryCount;
    }

    public JmsConsumerInfo getConsumerInfo() {
        return this.consumerInfo;
    }

    public void setConsumerInfo(JmsConsumerInfo consumerInfo) {
        this.consumerInfo = consumerInfo;
    }

    public String toString() {
        if (this.stringView == null) {
            StringBuilder builder = new StringBuilder();
            builder.append("JmsInboundMessageDispatch { sequence = ");
            builder.append(this.sequence);
            builder.append(", messageId = ");
            builder.append(this.messageId);
            builder.append(", consumerId = ");
            builder.append(this.consumerId);
            builder.append(" }");
            this.stringView = builder.toString();
        }
        return this.stringView;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.consumerId == null ? 0 : this.consumerId.hashCode());
        result = 31 * result + (this.messageId == null ? 0 : this.messageId.hashCode());
        result = 31 * result + (int)(this.sequence ^ this.sequence >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JmsInboundMessageDispatch other = (JmsInboundMessageDispatch)obj;
        if (this.sequence != other.sequence) {
            return false;
        }
        if (this.messageId == null ? other.messageId != null : !this.messageId.equals(other.messageId)) {
            return false;
        }
        return !(this.consumerId == null ? other.consumerId != null : !this.consumerId.equals(other.consumerId));
    }
}

