/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.qpid.jms.util.PropertyUtil;

public class URISupport {
    public static CompositeData parseComposite(URI uri) throws URISyntaxException {
        CompositeData rc = new CompositeData();
        rc.scheme = uri.getScheme();
        String ssp = PropertyUtil.stripPrefix(uri.getRawSchemeSpecificPart().trim(), "//").trim();
        try {
            URISupport.parseComposite(uri, rc, ssp);
        }
        catch (Exception e) {
            throw new URISyntaxException(uri.toString(), e.getMessage());
        }
        rc.fragment = uri.getFragment();
        return rc;
    }

    private static void parseComposite(URI uri, CompositeData rc, String ssp) throws Exception {
        String params;
        String componentString;
        int p;
        if (!URISupport.checkParenthesis(ssp)) {
            throw new URISyntaxException(uri.toString(), "Not a matching number of '(' and ')' parenthesis");
        }
        int initialParen = ssp.indexOf("(");
        if (initialParen == 0) {
            rc.host = ssp.substring(0, initialParen);
            p = rc.host.indexOf("/");
            if (p >= 0) {
                rc.path = rc.host.substring(p);
                rc.host = rc.host.substring(0, p);
            }
            p = URISupport.indexOfParenthesisMatch(ssp, initialParen);
            componentString = ssp.substring(initialParen + 1, p);
            params = ssp.substring(p + 1).trim();
        } else {
            componentString = ssp;
            params = "";
        }
        String[] components = URISupport.splitComponents(componentString);
        rc.components = new ArrayList(components.length);
        for (int i = 0; i < components.length; ++i) {
            rc.components.add(new URI(components[i].trim()));
        }
        p = params.indexOf("?");
        if (p >= 0) {
            if (p > 0) {
                rc.path = PropertyUtil.stripPrefix(params.substring(0, p), "/");
            }
            rc.parameters = PropertyUtil.parseQuery(params.substring(p + 1));
        } else {
            if (params.length() > 0) {
                rc.path = PropertyUtil.stripPrefix(params, "/");
            }
            rc.parameters = Collections.emptyMap();
        }
    }

    public static boolean isCompositeURI(URI uri) {
        String ssp = PropertyUtil.stripPrefix(uri.getRawSchemeSpecificPart().trim(), "//").trim();
        return ssp.indexOf(40) == 0 && URISupport.checkParenthesis(ssp);
    }

    public static boolean checkParenthesis(String str) {
        boolean result = true;
        if (str != null) {
            int open = 0;
            int closed = 0;
            int i = 0;
            while ((i = str.indexOf(40, i)) >= 0) {
                ++i;
                ++open;
            }
            i = 0;
            while ((i = str.indexOf(41, i)) >= 0) {
                ++i;
                ++closed;
            }
            result = open == closed;
        }
        return result;
    }

    public static int indexOfParenthesisMatch(String str, int first) throws URISyntaxException {
        int index = -1;
        if (first < 0 || first > str.length()) {
            throw new IllegalArgumentException("Invalid position for first parenthesis: " + first);
        }
        if (str.charAt(first) != '(') {
            throw new IllegalArgumentException("character at indicated position is not a parenthesis");
        }
        int depth = 1;
        char[] array = str.toCharArray();
        for (index = first + 1; index < array.length; ++index) {
            char current = array[index];
            if (current == '(') {
                ++depth;
                continue;
            }
            if (current == ')' && --depth == 0) break;
        }
        if (depth != 0) {
            throw new URISyntaxException(str, "URI did not contain a matching parenthesis.");
        }
        return index;
    }

    public static String[] splitComponents(String str) {
        ArrayList<String> l = new ArrayList<String>();
        int last = 0;
        int depth = 0;
        char[] chars = str.toCharArray();
        block5: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '(': {
                    ++depth;
                    continue block5;
                }
                case ')': {
                    --depth;
                    continue block5;
                }
                case ',': {
                    if (depth != 0) continue block5;
                    String s = str.substring(last, i);
                    l.add(s);
                    last = i + 1;
                    continue block5;
                }
            }
        }
        String s = str.substring(last);
        if (s.length() != 0) {
            l.add(s);
        }
        String[] rc = new String[l.size()];
        l.toArray(rc);
        return rc;
    }

    public static URI removeQuery(URI uri) throws URISyntaxException {
        return PropertyUtil.replaceQuery(uri, (String)null);
    }

    public static Map<String, String> parseParameters(URI uri) throws URISyntaxException {
        if (!URISupport.isCompositeURI(uri)) {
            if (uri.getRawQuery() == null) {
                return Collections.emptyMap();
            }
            try {
                return PropertyUtil.parseQuery(PropertyUtil.stripPrefix(uri.getRawQuery(), "?"));
            }
            catch (Exception e) {
                throw new URISyntaxException(uri.toString(), e.getMessage());
            }
        }
        CompositeData data = URISupport.parseComposite(uri);
        Map<String, String> parameters = new HashMap<String, String>();
        parameters.putAll(data.getParameters());
        if (parameters.isEmpty()) {
            parameters = Collections.emptyMap();
        }
        return parameters;
    }

    public static URI applyParameters(URI uri, Map<String, String> queryParameters) throws URISyntaxException {
        return URISupport.applyParameters(uri, queryParameters, "");
    }

    public static URI applyParameters(URI uri, Map<String, String> queryParameters, String optionPrefix) throws URISyntaxException {
        if (queryParameters != null && !queryParameters.isEmpty()) {
            StringBuffer newQuery = uri.getRawQuery() != null ? new StringBuffer(uri.getRawQuery()) : new StringBuffer();
            for (Map.Entry<String, String> param : queryParameters.entrySet()) {
                if (!param.getKey().startsWith(optionPrefix)) continue;
                if (newQuery.length() != 0) {
                    newQuery.append('&');
                }
                String key = param.getKey().substring(optionPrefix.length());
                newQuery.append(key).append('=').append(param.getValue());
            }
            uri = PropertyUtil.replaceQuery(uri, newQuery.toString());
        }
        return uri;
    }

    public static class CompositeData {
        private String host;
        private String scheme;
        private String path;
        private List<URI> components = Collections.emptyList();
        private Map<String, String> parameters = Collections.emptyMap();
        private String fragment;

        public List<URI> getComponents() {
            return this.components;
        }

        public String getFragment() {
            return this.fragment;
        }

        public Map<String, String> getParameters() {
            return this.parameters;
        }

        public String getScheme() {
            return this.scheme;
        }

        public String getPath() {
            return this.path;
        }

        public String getHost() {
            return this.host;
        }

        public URI toURI() throws URISyntaxException {
            StringBuffer sb = new StringBuffer();
            if (this.scheme != null) {
                sb.append(this.scheme);
                sb.append(':');
            }
            if (this.host != null && this.host.length() != 0) {
                sb.append(this.host);
            } else {
                sb.append('(');
                for (int i = 0; i < this.components.size(); ++i) {
                    if (i != 0) {
                        sb.append(',');
                    }
                    sb.append(this.components.get(i).toString());
                }
                sb.append(')');
            }
            if (this.path != null) {
                sb.append('/');
                sb.append(this.path);
            }
            if (!this.parameters.isEmpty()) {
                sb.append("?");
                sb.append(PropertyUtil.createQueryString(this.parameters));
            }
            if (this.fragment != null) {
                sb.append("#");
                sb.append(this.fragment);
            }
            return new URI(sb.toString());
        }
    }
}

