/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp.builders;

import java.io.IOException;
import java.util.concurrent.ScheduledFuture;
import org.apache.qpid.jms.JmsOperationTimedOutException;
import org.apache.qpid.jms.meta.JmsResource;
import org.apache.qpid.jms.provider.AsyncResult;
import org.apache.qpid.jms.provider.amqp.AmqpEventSink;
import org.apache.qpid.jms.provider.amqp.AmqpExceptionBuilder;
import org.apache.qpid.jms.provider.amqp.AmqpProvider;
import org.apache.qpid.jms.provider.amqp.AmqpResource;
import org.apache.qpid.jms.provider.amqp.AmqpResourceParent;
import org.apache.qpid.jms.provider.amqp.AmqpSupport;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Endpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AmqpResourceBuilder<TARGET extends AmqpResource, PARENT extends AmqpResourceParent, INFO extends JmsResource, ENDPOINT extends Endpoint>
implements AmqpEventSink,
AmqpExceptionBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpResourceBuilder.class);
    protected AsyncResult request;
    protected ScheduledFuture<?> requestTimeoutTask;
    protected TARGET resource;
    protected ENDPOINT endpoint;
    protected final PARENT parent;
    protected final INFO resourceInfo;

    public AmqpResourceBuilder(PARENT parent, INFO resourceInfo) {
        this.parent = parent;
        this.resourceInfo = resourceInfo;
    }

    public void buildResource(final AsyncResult request) {
        this.request = request;
        this.endpoint = this.createEndpoint(this.resourceInfo);
        this.endpoint.setContext((Object)this);
        this.endpoint.open();
        this.resource = this.createResource(this.parent, this.resourceInfo, this.endpoint);
        if (this.getRequestTimeout() > -1L) {
            this.requestTimeoutTask = this.parent.getProvider().scheduleRequestTimeout(new AsyncResult(){

                @Override
                public void onSuccess() {
                }

                @Override
                public void onFailure(Throwable result) {
                    AmqpResourceBuilder.this.handleClosed(AmqpResourceBuilder.this.parent.getProvider(), result);
                }

                @Override
                public boolean isComplete() {
                    return request.isComplete();
                }
            }, this.getRequestTimeout(), this);
        }
    }

    @Override
    public void processRemoteOpen(AmqpProvider provider) throws IOException {
        this.handleOpened(provider);
    }

    @Override
    public void processRemoteClose(AmqpProvider provider) throws IOException {
        this.handleClosed(provider, null);
    }

    @Override
    public void processRemoteDetach(AmqpProvider provider) throws IOException {
    }

    @Override
    public void processDeliveryUpdates(AmqpProvider provider, Delivery delivery) throws IOException {
    }

    @Override
    public void processFlowUpdates(AmqpProvider provider) throws IOException {
    }

    protected final void handleOpened(AmqpProvider provider) {
        this.afterOpened();
        if (this.isClosePending()) {
            return;
        }
        if (this.requestTimeoutTask != null) {
            this.requestTimeoutTask.cancel(false);
        }
        if (this.isOpenedEndpointValid()) {
            this.resourceInfo.setState(JmsResource.ResourceState.OPEN);
            this.getEndpoint().setContext(this.resource);
            this.getParent().addChildResource((AmqpResource)this.resource);
            this.getRequest().onSuccess();
        } else {
            this.handleClosed(provider, new IOException("Failed to open requested endpoint"));
        }
    }

    protected final void handleClosed(AmqpProvider provider, Throwable cause) {
        this.resourceInfo.setState(JmsResource.ResourceState.CLOSED);
        this.afterClosed(this.getResource(), this.getResourceInfo());
        Throwable openError = this.hasRemoteError() ? AmqpSupport.convertToException(this.getEndpoint(), this.getEndpoint().getRemoteCondition()) : (cause != null ? cause : this.getOpenAbortException());
        if (this.requestTimeoutTask != null) {
            this.requestTimeoutTask.cancel(false);
        }
        LOG.warn("Open of resource:({}) failed: {}", this.resourceInfo, (Object)openError.getMessage());
        this.getEndpoint().close();
        this.getEndpoint().free();
        this.getEndpoint().setContext(null);
        this.getRequest().onFailure(openError);
    }

    @Override
    public Exception createException() {
        return new JmsOperationTimedOutException("Request to open resource " + this.getResource() + " timed out");
    }

    protected abstract ENDPOINT createEndpoint(INFO var1);

    protected abstract TARGET createResource(PARENT var1, INFO var2, ENDPOINT var3);

    protected abstract boolean isClosePending();

    protected boolean isOpenedEndpointValid() {
        return true;
    }

    protected void afterOpened() {
    }

    protected void afterClosed(TARGET resource, INFO resourceInfo) {
    }

    protected boolean hasRemoteError() {
        return this.getEndpoint().getRemoteCondition().getCondition() != null;
    }

    protected Exception getOpenAbortException() {
        return new IOException("Open failed unexpectedly.");
    }

    protected long getRequestTimeout() {
        return this.getParent().getProvider().getRequestTimeout();
    }

    public ENDPOINT getEndpoint() {
        return this.endpoint;
    }

    public AsyncResult getRequest() {
        return this.request;
    }

    public TARGET getResource() {
        return this.resource;
    }

    public PARENT getParent() {
        return this.parent;
    }

    public INFO getResourceInfo() {
        return this.resourceInfo;
    }
}

