/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.qpid.jms.provider.AsyncResult;
import org.apache.qpid.jms.provider.ProviderSynchronization;
import org.apache.qpid.jms.util.IOExceptionSupport;

public class ProviderFuture
implements AsyncResult {
    private final AtomicBoolean completer = new AtomicBoolean();
    private final CountDownLatch latch = new CountDownLatch(1);
    private final ProviderSynchronization synchronization;
    private volatile Throwable error;

    public ProviderFuture() {
        this(null);
    }

    public ProviderFuture(ProviderSynchronization synchronization) {
        this.synchronization = synchronization;
    }

    @Override
    public boolean isComplete() {
        return this.latch.getCount() == 0L;
    }

    @Override
    public void onFailure(Throwable result) {
        if (this.completer.compareAndSet(false, true)) {
            this.error = result;
            if (this.synchronization != null) {
                this.synchronization.onPendingFailure(this.error);
            }
            this.latch.countDown();
        }
    }

    @Override
    public void onSuccess() {
        if (this.completer.compareAndSet(false, true)) {
            if (this.synchronization != null) {
                this.synchronization.onPendingSuccess();
            }
            this.latch.countDown();
        }
    }

    public void sync(long amount, TimeUnit unit) throws IOException {
        try {
            this.latch.await(amount, unit);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw IOExceptionSupport.create(e);
        }
        this.failOnError();
    }

    public void sync() throws IOException {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw IOExceptionSupport.create(e);
        }
        this.failOnError();
    }

    private void failOnError() throws IOException {
        Throwable cause = this.error;
        if (cause != null) {
            throw IOExceptionSupport.create(cause);
        }
    }
}

