/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport.network.io;

import org.apache.qpid.transport.network.NetworkConnection;
import org.apache.qpid.transport.network.Ticker;
import org.apache.qpid.transport.network.TransportActivity;

class IdleTimeoutTicker
implements Ticker {
    private final TransportActivity _transport;
    private final int _defaultTimeout;
    private NetworkConnection _connection;

    public IdleTimeoutTicker(TransportActivity transport, int defaultTimeout) {
        this._transport = transport;
        this._defaultTimeout = defaultTimeout;
    }

    public int getTimeToNextTick(long currentTime) {
        long maxWriteIdle;
        long nextTime = -1L;
        long maxReadIdle = 1000L * (long)this._connection.getMaxReadIdle();
        if (maxReadIdle > 0L) {
            nextTime = this._transport.getLastReadTime() + maxReadIdle;
        }
        if ((maxWriteIdle = 1000L * (long)this._connection.getMaxWriteIdle()) > 0L) {
            long writeTime = this._transport.getLastWriteTime() + maxWriteIdle;
            if (nextTime == -1L || writeTime < nextTime) {
                nextTime = writeTime;
            }
        }
        return nextTime == -1L ? this._defaultTimeout : (int)(nextTime - currentTime);
    }

    public int tick(long currentTime) {
        long maxReadIdle;
        long maxWriteIdle = 1000L * (long)this._connection.getMaxWriteIdle();
        if (maxWriteIdle > 0L && maxWriteIdle + this._transport.getLastWriteTime() <= currentTime) {
            this._transport.writerIdle();
        }
        if ((maxReadIdle = 1000L * (long)this._connection.getMaxReadIdle()) > 0L && maxReadIdle + this._transport.getLastReadTime() <= currentTime) {
            this._transport.readerIdle();
        }
        return this.getTimeToNextTick(currentTime);
    }

    public void setConnection(NetworkConnection connection) {
        this._connection = connection;
    }
}

