/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport;

import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslServer;
import org.apache.qpid.framing.ProtocolVersion;
import org.apache.qpid.transport.Binary;
import org.apache.qpid.transport.ConnectionClose;
import org.apache.qpid.transport.ConnectionCloseCode;
import org.apache.qpid.transport.ConnectionDelegate;
import org.apache.qpid.transport.ConnectionException;
import org.apache.qpid.transport.ConnectionInvoker;
import org.apache.qpid.transport.ConnectionListener;
import org.apache.qpid.transport.ConnectionSettings;
import org.apache.qpid.transport.Method;
import org.apache.qpid.transport.Option;
import org.apache.qpid.transport.ProtocolEvent;
import org.apache.qpid.transport.ProtocolHeader;
import org.apache.qpid.transport.ProtocolVersionException;
import org.apache.qpid.transport.Receiver;
import org.apache.qpid.transport.Sender;
import org.apache.qpid.transport.Session;
import org.apache.qpid.transport.SessionDetachCode;
import org.apache.qpid.transport.SessionDetached;
import org.apache.qpid.transport.network.Assembler;
import org.apache.qpid.transport.network.Disassembler;
import org.apache.qpid.transport.network.InputHandler;
import org.apache.qpid.transport.network.NetworkConnection;
import org.apache.qpid.transport.network.OutgoingNetworkTransport;
import org.apache.qpid.transport.network.Transport;
import org.apache.qpid.transport.network.TransportActivity;
import org.apache.qpid.transport.network.security.SecurityLayer;
import org.apache.qpid.transport.network.security.SecurityLayerFactory;
import org.apache.qpid.transport.util.Logger;
import org.apache.qpid.transport.util.Waiter;
import org.apache.qpid.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Connection
extends ConnectionInvoker
implements Receiver<ProtocolEvent>,
Sender<ProtocolEvent> {
    protected static final Logger log = Logger.get(Connection.class);
    public static final int MAX_CHANNEL_MAX = 65535;
    public static final int MIN_USABLE_CHANNEL_NUM = 0;
    private long _lastSendTime;
    private long _lastReadTime;
    private static final SessionFactory DEFAULT_SESSION_FACTORY = new DefaultSessionFactory();
    private SessionFactory _sessionFactory = DEFAULT_SESSION_FACTORY;
    private ConnectionDelegate delegate;
    private Sender<ProtocolEvent> sender;
    private final Map<Binary, Session> sessions = new HashMap<Binary, Session>();
    private final Map<Integer, Session> channels = new HashMap<Integer, Session>();
    private State state = State.NEW;
    private final Object lock = new Object();
    private long timeout = 60000L;
    private List<ConnectionListener> listeners = new ArrayList<ConnectionListener>();
    private ConnectionException error = null;
    private int channelMax = 1;
    private String locale;
    private SaslServer saslServer;
    private SaslClient saslClient;
    private int idleTimeout = 0;
    private Map<String, Object> _serverProperties;
    private String userID;
    private ConnectionSettings conSettings;
    private SecurityLayer securityLayer;
    private final AtomicBoolean connectionLost = new AtomicBoolean(false);
    private SocketAddress _remoteAddress;
    private SocketAddress _localAddress;

    public void setConnectionDelegate(ConnectionDelegate delegate) {
        this.delegate = delegate;
    }

    public void addConnectionListener(ConnectionListener listener) {
        this.listeners.add(listener);
    }

    public Sender<ProtocolEvent> getSender() {
        return this.sender;
    }

    public void setSender(Sender<ProtocolEvent> sender) {
        this.sender = sender;
        sender.setIdleTimeout(this.idleTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(State state) {
        Object object = this.lock;
        synchronized (object) {
            this.state = state;
            this.lock.notifyAll();
        }
    }

    void setLocale(String locale) {
        this.locale = locale;
    }

    String getLocale() {
        return this.locale;
    }

    void setSaslServer(SaslServer saslServer) {
        this.saslServer = saslServer;
    }

    SaslServer getSaslServer() {
        return this.saslServer;
    }

    void setSaslClient(SaslClient saslClient) {
        this.saslClient = saslClient;
    }

    public SaslClient getSaslClient() {
        return this.saslClient;
    }

    public void connect(String host, int port, String vhost, String username, String password, boolean ssl, String saslMechs) {
        this.connect(host, port, vhost, username, password, ssl, saslMechs, null);
    }

    public void connect(String host, int port, String vhost, String username, String password, boolean ssl, String saslMechs, Map<String, Object> clientProps) {
        ConnectionSettings settings = new ConnectionSettings();
        settings.setHost(host);
        settings.setPort(port);
        settings.setVhost(vhost);
        settings.setUsername(username);
        settings.setPassword(password);
        settings.setUseSSL(ssl);
        settings.setSaslMechs(saslMechs);
        settings.setClientProperties(clientProps);
        this.connect(settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(ConnectionSettings settings) {
        Object object = this.lock;
        synchronized (object) {
            this.conSettings = settings;
            this.state = State.OPENING;
            this.userID = settings.getUsername();
            this.connectionLost.set(false);
            this.securityLayer = SecurityLayerFactory.newInstance(this.getConnectionSettings());
            OutgoingNetworkTransport transport = Transport.getOutgoingTransportInstance(ProtocolVersion.v0_10);
            Receiver<ByteBuffer> secureReceiver = this.securityLayer.receiver(new InputHandler(new Assembler(this)));
            if (secureReceiver instanceof ConnectionListener) {
                this.addConnectionListener((ConnectionListener)((Object)secureReceiver));
            }
            NetworkConnection network = transport.connect(settings, secureReceiver, new ConnectionActivity());
            this.setRemoteAddress(network.getRemoteAddress());
            this.setLocalAddress(network.getLocalAddress());
            Sender<ByteBuffer> secureSender = this.securityLayer.sender(network.getSender());
            if (secureSender instanceof ConnectionListener) {
                this.addConnectionListener((ConnectionListener)((Object)secureSender));
            }
            this.sender = new Disassembler(secureSender, settings.getMaxFrameSize());
            this.send(new ProtocolHeader(1, 0, 10));
            Waiter w = new Waiter(this.lock, this.timeout);
            while (w.hasTime() && this.state == State.OPENING && this.error == null) {
                w.await();
            }
            if (this.error != null) {
                ConnectionException t;
                block15: {
                    t = this.error;
                    this.error = null;
                    try {
                        this.close();
                    }
                    catch (ConnectionException ce) {
                        if (t instanceof ProtocolVersionException) break block15;
                        throw ce;
                    }
                }
                t.rethrow();
            }
            switch (this.state) {
                case OPENING: {
                    this.close();
                    throw new ConnectionException("connect() timed out");
                }
                case OPEN: 
                case RESUMING: {
                    this.connectionLost.set(false);
                    break;
                }
                case CLOSED: {
                    throw new ConnectionException("connect() aborted");
                }
                default: {
                    throw new IllegalStateException(String.valueOf((Object)this.state));
                }
            }
        }
        for (ConnectionListener listener : this.listeners) {
            listener.opened(this);
        }
    }

    public Session createSession() {
        return this.createSession(0L);
    }

    public Session createSession(long expiry) {
        return this.createSession(UUID.randomUUID().toString(), expiry);
    }

    public Session createSession(String name) {
        return this.createSession(name, 0L);
    }

    public Session createSession(String name, long expiry) {
        return this.createSession(Strings.toUTF8(name), expiry);
    }

    public Session createSession(byte[] name, long expiry) {
        return this.createSession(new Binary(name), expiry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session createSession(Binary name, long expiry) {
        Object object = this.lock;
        synchronized (object) {
            Waiter w = new Waiter(this.lock, this.timeout);
            while (w.hasTime() && this.state != State.OPEN && this.error == null) {
                w.await();
            }
            if (this.state != State.OPEN) {
                throw new ConnectionException("Timed out waiting for connection to be ready. Current state is :" + (Object)((Object)this.state));
            }
            Session ssn = this._sessionFactory.newSession(this, name, expiry);
            this.registerSession(ssn);
            this.map(ssn);
            ssn.attach();
            return ssn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSession(Session ssn) {
        Object object = this.lock;
        synchronized (object) {
            this.sessions.put(ssn.getName(), ssn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(Session ssn) {
        Object object = this.lock;
        synchronized (object) {
            this.sessions.remove(ssn.getName());
        }
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        assert (sessionFactory != null);
        this._sessionFactory = sessionFactory;
    }

    public ConnectionDelegate getConnectionDelegate() {
        return this.delegate;
    }

    @Override
    public void received(ProtocolEvent event) {
        this._lastReadTime = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug("RECV: [%s] %s", this, event);
        }
        event.delegate(this, this.delegate);
    }

    @Override
    public void send(ProtocolEvent event) {
        Sender<ProtocolEvent> s;
        this._lastSendTime = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug("SEND: [%s] %s", this, event);
        }
        if ((s = this.sender) == null) {
            throw new ConnectionException("connection closed");
        }
        s.send(event);
    }

    @Override
    public void flush() {
        Sender<ProtocolEvent> theSender;
        if (log.isDebugEnabled()) {
            log.debug("FLUSH: [%s]", this);
        }
        if ((theSender = this.sender) != null) {
            theSender.flush();
        }
    }

    @Override
    protected void invoke(Method method) {
        method.setChannel(0);
        this.send(method);
        if (!method.isBatch()) {
            this.flush();
        }
    }

    public void dispatch(Method method) {
        int channel = method.getChannel();
        Session ssn = this.getSession(channel);
        if (ssn != null) {
            ssn.received(method);
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Control received on unattached channel : %d", channel);
            }
            this.invokeSessionDetached(channel, SessionDetachCode.NOT_ATTACHED);
        }
    }

    public int getChannelMax() {
        return this.channelMax;
    }

    void setChannelMax(int max) {
        this.channelMax = max;
    }

    private int map(Session ssn) {
        Object object = this.lock;
        synchronized (object) {
            for (int i = 0; i < this.getChannelMax(); ++i) {
                if (this.channels.containsKey(i)) continue;
                this.map(ssn, i);
                return i;
            }
            throw new RuntimeException("no more channels available");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void map(Session ssn, int channel) {
        Object object = this.lock;
        synchronized (object) {
            this.channels.put(channel, ssn);
            ssn.setChannel(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unmap(Session ssn) {
        Object object = this.lock;
        synchronized (object) {
            this.channels.remove(ssn.getChannel());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getSession(int channel) {
        Object object = this.lock;
        synchronized (object) {
            return this.channels.get(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.lock;
        synchronized (object) {
            for (Session ssn : this.sessions.values()) {
                this.map(ssn);
                ssn.resume();
            }
            this.setState(State.OPEN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exception(ConnectionException e) {
        this.connectionLost.set(true);
        Object object = this.lock;
        synchronized (object) {
            switch (this.state) {
                case OPENING: 
                case CLOSING: {
                    this.error = e;
                    this.lock.notifyAll();
                    return;
                }
            }
        }
        for (ConnectionListener listener : this.listeners) {
            listener.exception(this, e);
        }
    }

    @Override
    public void exception(Throwable t) {
        this.exception(new ConnectionException(t));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeCode(ConnectionClose close) {
        Object object = this.lock;
        synchronized (object) {
            ConnectionCloseCode code = close.getReplyCode();
            if (code != ConnectionCloseCode.NORMAL) {
                this.exception(new ConnectionException(close));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closed() {
        if (this.state == State.OPEN) {
            this.exception(new ConnectionException("connection aborted"));
        }
        log.debug("connection closed: %s", this);
        Object object = this.lock;
        synchronized (object) {
            ArrayList<Session> values = new ArrayList<Session>(this.channels.values());
            for (Session ssn : values) {
                ssn.closed();
            }
            try {
                this.sender.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sender = null;
            this.setState(State.CLOSED);
        }
        for (ConnectionListener listener : this.listeners) {
            listener.closed(this);
        }
    }

    @Override
    public void close() {
        this.close(ConnectionCloseCode.NORMAL, null, new Option[0]);
    }

    public void mgmtClose() {
        this.close(ConnectionCloseCode.CONNECTION_FORCED, "The connection was closed using the broker's management interface.", new Option[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(ConnectionCloseCode replyCode, String replyText, Option ... _options) {
        Object object = this.lock;
        synchronized (object) {
            block2 : switch (this.state) {
                case OPEN: {
                    this.state = State.CLOSING;
                    this.connectionClose(replyCode, replyText, _options);
                    Waiter w = new Waiter(this.lock, this.timeout);
                    while (w.hasTime() && this.state == State.CLOSING && this.error == null) {
                        w.await();
                    }
                    if (this.error != null) {
                        this.close(replyCode, replyText, _options);
                        throw new ConnectionException(this.error);
                    }
                    switch (this.state) {
                        case CLOSING: {
                            this.close(replyCode, replyText, _options);
                            throw new ConnectionException("close() timed out");
                        }
                        case CLOSED: {
                            break block2;
                        }
                    }
                    throw new IllegalStateException(String.valueOf((Object)this.state));
                }
                case CLOSED: {
                    break;
                }
                default: {
                    if (this.sender == null) break;
                    this.sender.close();
                    Waiter w = new Waiter(this.lock, this.timeout);
                    while (w.hasTime() && this.sender != null && this.error == null) {
                        w.await();
                    }
                    if (this.error != null) {
                        throw new ConnectionException(this.error);
                    }
                    if (this.sender == null) break;
                    throw new ConnectionException("close() timed out");
                }
            }
        }
    }

    @Override
    public void setIdleTimeout(int i) {
        this.idleTimeout = i;
        if (this.sender != null) {
            this.sender.setIdleTimeout(i);
        }
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public String getUserID() {
        return this.userID;
    }

    public void setUserID(String id) {
        this.userID = id;
    }

    public void setServerProperties(Map<String, Object> serverProperties) {
        this._serverProperties = serverProperties == null ? Collections.emptyMap() : serverProperties;
    }

    public Map<String, Object> getServerProperties() {
        return this._serverProperties;
    }

    public String toString() {
        return String.format("conn:%x", System.identityHashCode(this));
    }

    public ConnectionSettings getConnectionSettings() {
        return this.conSettings;
    }

    public SecurityLayer getSecurityLayer() {
        return this.securityLayer;
    }

    public boolean isConnectionResuming() {
        return this.connectionLost.get();
    }

    protected Collection<Session> getChannels() {
        return this.channels.values();
    }

    public boolean hasSessionWithName(byte[] name) {
        return this.sessions.containsKey(new Binary(name));
    }

    public void notifyFailoverRequired() {
        ArrayList<Session> values = new ArrayList<Session>(this.channels.values());
        for (Session ssn : values) {
            ssn.notifyFailoverRequired();
        }
    }

    public SocketAddress getRemoteAddress() {
        return this._remoteAddress;
    }

    public SocketAddress getLocalAddress() {
        return this._localAddress;
    }

    protected void setRemoteAddress(SocketAddress remoteAddress) {
        this._remoteAddress = remoteAddress;
    }

    protected void setLocalAddress(SocketAddress localAddress) {
        this._localAddress = localAddress;
    }

    private void invokeSessionDetached(int channel, SessionDetachCode sessionDetachCode) {
        SessionDetached sessionDetached = new SessionDetached();
        sessionDetached.setChannel(channel);
        sessionDetached.setCode(sessionDetachCode);
        this.invoke(sessionDetached);
    }

    protected void doHeartBeat() {
        this.connectionHeartbeat(new Option[0]);
    }

    private class ConnectionActivity
    implements TransportActivity {
        private ConnectionActivity() {
        }

        public long getLastReadTime() {
            return Connection.this._lastReadTime;
        }

        public long getLastWriteTime() {
            return Connection.this._lastSendTime;
        }

        public void writerIdle() {
            Connection.this.connectionHeartbeat(new Option[0]);
        }

        public void readerIdle() {
        }
    }

    private static final class DefaultSessionFactory
    implements SessionFactory {
        private DefaultSessionFactory() {
        }

        public Session newSession(Connection conn, Binary name, long expiry) {
            return new Session(conn, name, expiry);
        }
    }

    public static interface SessionFactory {
        public Session newSession(Connection var1, Binary var2, long var3);
    }

    static class DefaultConnectionListener
    implements ConnectionListener {
        DefaultConnectionListener() {
        }

        public void opened(Connection conn) {
        }

        public void exception(Connection conn, ConnectionException exception) {
            log.error(exception, "connection exception", new Object[0]);
        }

        public void closed(Connection conn) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        NEW,
        CLOSED,
        OPENING,
        OPEN,
        CLOSING,
        CLOSE_RCVD,
        RESUMING;

    }
}

