/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing.amqp_8_0;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.qpid.AMQException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyInstanceFactory;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.TestIntegerBody;
import org.apache.qpid.framing.amqp_8_0.AMQMethodBody_8_0;
import org.apache.qpid.framing.amqp_8_0.MethodDispatcher_8_0;

public class TestIntegerBodyImpl
extends AMQMethodBody_8_0
implements TestIntegerBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        public AMQMethodBody newInstance(MarkableDataInput in, long size) throws AMQFrameDecodingException, IOException {
            return new TestIntegerBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 120;
    public static final int METHOD_ID = 10;
    private final short _integer1;
    private final int _integer2;
    private final long _integer3;
    private final long _integer4;
    private final short _operation;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public TestIntegerBodyImpl(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException {
        this._integer1 = this.readUnsignedByte(buffer);
        this._integer2 = this.readUnsignedShort(buffer);
        this._integer3 = this.readUnsignedInteger(buffer);
        this._integer4 = this.readLong(buffer);
        this._operation = this.readUnsignedByte(buffer);
    }

    public TestIntegerBodyImpl(short integer1, int integer2, long integer3, long integer4, short operation) {
        this._integer1 = integer1;
        this._integer2 = integer2;
        this._integer3 = integer3;
        this._integer4 = integer4;
        this._operation = operation;
    }

    public int getClazz() {
        return 120;
    }

    public int getMethod() {
        return 10;
    }

    public final short getInteger1() {
        return this._integer1;
    }

    public final int getInteger2() {
        return this._integer2;
    }

    public final long getInteger3() {
        return this._integer3;
    }

    public final long getInteger4() {
        return this._integer4;
    }

    public final short getOperation() {
        return this._operation;
    }

    protected int getBodySize() {
        int size = 16;
        return size;
    }

    public void writeMethodPayload(DataOutput buffer) throws IOException {
        this.writeUnsignedByte(buffer, this._integer1);
        this.writeUnsignedShort(buffer, this._integer2);
        this.writeUnsignedInteger(buffer, this._integer3);
        this.writeLong(buffer, this._integer4);
        this.writeUnsignedByte(buffer, this._operation);
    }

    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_8_0)dispatcher).dispatchTestInteger(this, channelId);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[TestIntegerBodyImpl: ");
        buf.append("integer1=");
        buf.append(this.getInteger1());
        buf.append(", ");
        buf.append("integer2=");
        buf.append(this.getInteger2());
        buf.append(", ");
        buf.append("integer3=");
        buf.append(this.getInteger3());
        buf.append(", ");
        buf.append("integer4=");
        buf.append(this.getInteger4());
        buf.append(", ");
        buf.append("operation=");
        buf.append(this.getOperation());
        buf.append("]");
        return buf.toString();
    }
}

