/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQBody;
import org.apache.qpid.framing.AMQFrame;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.protocol.AMQVersionAwareProtocolSession;

public class ContentBody
implements AMQBody {
    public static final byte TYPE = 3;
    private byte[] _payload;

    public ContentBody() {
    }

    public ContentBody(DataInput buffer, long size) throws AMQFrameDecodingException, IOException {
        this._payload = new byte[(int)size];
        buffer.readFully(this.getPayload());
    }

    public ContentBody(byte[] payload) {
        this._payload = payload;
    }

    public byte getFrameType() {
        return 3;
    }

    public int getSize() {
        return this.getPayload() == null ? 0 : this.getPayload().length;
    }

    public void writePayload(DataOutput buffer) throws IOException {
        buffer.write(this.getPayload());
    }

    public void handle(int channelId, AMQVersionAwareProtocolSession session) throws AMQException {
        session.contentBodyReceived(channelId, this);
    }

    protected void populateFromBuffer(DataInputStream buffer, long size) throws AMQFrameDecodingException, IOException {
        if (size > 0L) {
            this._payload = new byte[(int)size];
            buffer.read(this.getPayload());
        }
    }

    public void reduceBufferToFit() {
    }

    public byte[] getPayload() {
        return this._payload;
    }

    public static AMQFrame createAMQFrame(int channelId, ByteBuffer buf, int offset, int length) {
        return new AMQFrame(channelId, new BufferContentBody(buf, offset, length));
    }

    public static AMQFrame createAMQFrame(int channelId, ContentBody body) {
        return new AMQFrame(channelId, body);
    }

    private static class BufferContentBody
    implements AMQBody {
        private final int _length;
        private final int _offset;
        private final ByteBuffer _buf;

        private BufferContentBody(ByteBuffer buf, int offset, int length) {
            this._length = length;
            this._offset = offset;
            this._buf = buf;
        }

        public byte getFrameType() {
            return 3;
        }

        public int getSize() {
            return this._length;
        }

        public void writePayload(DataOutput buffer) throws IOException {
            if (this._buf.hasArray()) {
                buffer.write(this._buf.array(), this._buf.arrayOffset() + this._offset, this._length);
            } else {
                byte[] data = new byte[this._length];
                ByteBuffer buf = this._buf.duplicate();
                buf.position(this._offset);
                buf.limit(this._offset + this._length);
                buf.get(data);
                buffer.write(data);
            }
        }

        public void handle(int channelId, AMQVersionAwareProtocolSession amqProtocolSession) throws AMQException {
            throw new RuntimeException("Buffered Body only to be used for outgoing data");
        }
    }
}

