/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommandLineParser {
    private Map<String, CommandLineOption> optionMap = new HashMap<String, CommandLineOption>();
    private List<String> parsingErrors = new ArrayList<String>();
    private Matcher optionMatcher = null;
    private Properties parsedProperties = null;
    private boolean errorsOnUnknowns = false;

    public CommandLineParser(String[][] config) {
        for (int i = 0; i < config.length; ++i) {
            String[] nextOptionSpec = config[i];
            this.addOption(nextOptionSpec[0], nextOptionSpec[1], nextOptionSpec.length > 2 ? nextOptionSpec[2] : null, nextOptionSpec.length > 3 ? "true".equals(nextOptionSpec[3]) : false, nextOptionSpec.length > 4 ? nextOptionSpec[4] : null);
        }
    }

    public String getErrors() {
        if (this.parsingErrors.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (String s : this.parsingErrors) {
            result.append(s);
        }
        return result.toString();
    }

    public String getOptionsInForce() {
        if (this.parsedProperties == null) {
            return "";
        }
        StringBuilder result = new StringBuilder("Options in force:\n");
        for (Map.Entry<Object, Object> property : this.parsedProperties.entrySet()) {
            result.append(property.getKey()).append(" = ").append(property.getValue()).append('\n');
        }
        return result.toString();
    }

    public String getUsage() {
        String result = "Options:\n";
        for (CommandLineOption optionInfo : this.optionMap.values()) {
            result = result + "-" + optionInfo.option + " " + (optionInfo.argument != null ? optionInfo.argument + " " : "") + optionInfo.comment + "\n";
        }
        return result;
    }

    public void setErrorsOnUnknowns(boolean errors) {
        this.errorsOnUnknowns = errors;
    }

    public Properties parseCommandLine(String[] args) throws IllegalArgumentException {
        Properties options = new Properties();
        int free = 1;
        boolean expectingArgs = false;
        String optionExpectingArgs = null;
        boolean ignore = false;
        StringBuilder regexp = new StringBuilder("^(");
        int optionsAdded = 0;
        Iterator<String> i = this.optionMap.keySet().iterator();
        while (i.hasNext()) {
            String nextOption = i.next();
            boolean notFree = false;
            try {
                Integer.parseInt(nextOption);
            }
            catch (NumberFormatException e) {
                notFree = true;
            }
            if (!notFree) continue;
            regexp.append(nextOption).append(i.hasNext() ? "|" : "");
            ++optionsAdded;
        }
        regexp.append(')').append(optionsAdded > 0 ? "?" : "").append("(.*)");
        Pattern pattern = Pattern.compile(regexp.toString());
        block3: for (int i2 = 0; i2 < args.length; ++i2) {
            CommandLineOption optionInfo;
            if (args[i2].startsWith("-")) {
                String arg = args[i2].substring(1);
                this.optionMatcher = pattern.matcher(arg);
                this.optionMatcher.matches();
                String matchedOption = this.optionMatcher.group(1);
                String matchedArg = this.optionMatcher.group(2);
                if (matchedOption != null && !"".equals(matchedOption)) {
                    CommandLineOption optionInfo2 = this.optionMap.get(matchedOption);
                    if (optionInfo2.expectsArgs) {
                        expectingArgs = true;
                        optionExpectingArgs = matchedOption;
                    }
                    if ("".equals(matchedArg) && !optionInfo2.expectsArgs) {
                        options.put(matchedOption, "true");
                        continue;
                    }
                    if ("".equals(matchedArg)) continue;
                    if (!optionInfo2.expectsArgs) {
                        options.put(matchedOption, "true");
                        do {
                            this.optionMatcher = pattern.matcher(matchedArg);
                            this.optionMatcher.matches();
                            matchedOption = this.optionMatcher.group(1);
                            matchedArg = this.optionMatcher.group(2);
                            if (matchedOption != null) {
                                optionInfo2 = this.optionMap.get(matchedOption);
                                if (optionInfo2.expectsArgs) {
                                    this.parsingErrors.add("Option " + matchedOption + " cannot be combined with flags.\n");
                                }
                            } else {
                                this.parsingErrors.add("Illegal argument to a flag in the option " + arg + "\n");
                                continue block3;
                            }
                            options.put(matchedOption, "true");
                        } while (!"".equals(matchedArg));
                        continue;
                    }
                    this.checkArgumentFormat(optionInfo2, matchedArg);
                    options.put(matchedOption, matchedArg);
                    expectingArgs = false;
                    continue;
                }
                if (!this.errorsOnUnknowns) continue;
                this.parsingErrors.add("Option " + matchedOption + " is not a recognized option.\n");
                continue;
            }
            if (expectingArgs) {
                optionInfo = this.optionMap.get(optionExpectingArgs);
                this.checkArgumentFormat(optionInfo, args[i2]);
                options.put(optionExpectingArgs, args[i2]);
                expectingArgs = false;
                optionExpectingArgs = null;
                continue;
            }
            optionInfo = this.optionMap.get(Integer.toString(free));
            if (optionInfo != null) {
                this.checkArgumentFormat(optionInfo, args[i2]);
            }
            options.put(Integer.toString(free), args[i2]);
            ++free;
        }
        for (CommandLineOption optionInfo : this.optionMap.values()) {
            if (!optionInfo.expectsArgs) {
                if (options.containsKey(optionInfo.option)) continue;
                options.put(optionInfo.option, "false");
                continue;
            }
            if (!optionInfo.mandatory || options.containsKey(optionInfo.option)) continue;
            this.parsingErrors.add("Option -" + optionInfo.option + " is mandatory but not was not specified.\n");
        }
        if (!this.parsingErrors.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.parsedProperties = options = this.takeFreeArgsAsProperties(options, 1);
        return options;
    }

    public void addCommandLineToProperties(Properties properties) {
        if (this.parsedProperties != null) {
            for (Object propKey : this.parsedProperties.keySet()) {
                String name = (String)propKey;
                String value = this.parsedProperties.getProperty(name);
                properties.setProperty(name, value);
            }
        }
    }

    public void reset() {
        this.parsingErrors = new ArrayList<String>();
        this.parsedProperties = null;
    }

    protected void addOption(String option, String comment, String argument, boolean mandatory, String formatRegexp) {
        boolean expectsArgs = argument != null && !argument.equals("");
        CommandLineOption opt = new CommandLineOption(option, expectsArgs, comment, argument, mandatory, formatRegexp);
        this.optionMap.put(option, opt);
    }

    private Properties takeFreeArgsAsProperties(Properties properties, int from) {
        String nextFreeArg;
        int i = from;
        while ((nextFreeArg = properties.getProperty(Integer.toString(i))) != null) {
            String[] nameValuePair = nextFreeArg.split("=");
            if (nameValuePair.length == 2) {
                properties.setProperty(nameValuePair[0], nameValuePair[1]);
            }
            ++i;
        }
        return properties;
    }

    private void checkArgumentFormat(CommandLineOption optionInfo, String matchedArg) {
        Pattern pattern;
        Matcher argumentMatcher;
        if (optionInfo.argumentFormatRegexp != null && !(argumentMatcher = (pattern = Pattern.compile(optionInfo.argumentFormatRegexp)).matcher(matchedArg)).matches()) {
            this.parsingErrors.add("The argument to option -" + optionInfo.option + " does not meet its required format.\n");
        }
    }

    public static Properties processCommandLine(String[] args, CommandLineParser commandLine, Properties properties) {
        Properties options = null;
        try {
            options = commandLine.parseCommandLine(args);
            commandLine.addCommandLineToProperties(properties);
        }
        catch (IllegalArgumentException e) {
            System.out.println(commandLine.getErrors());
            System.out.println(commandLine.getUsage());
            System.exit(1);
        }
        return options;
    }

    protected static class CommandLineOption {
        public String option = null;
        public String argument = null;
        public boolean expectsArgs = false;
        public String comment = null;
        public boolean mandatory = false;
        public String argumentFormatRegexp = null;

        public CommandLineOption(String option, boolean expectsArgs, String comment, String argument, boolean mandatory, String formatRegexp) {
            this.option = option;
            this.expectsArgs = expectsArgs;
            this.comment = comment;
            this.argument = argument;
            this.mandatory = mandatory;
            this.argumentFormatRegexp = formatRegexp;
        }
    }
}

