/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport.network.io;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ByteBufferAllocator;
import org.apache.mina.common.SimpleByteBufferAllocator;
import org.apache.qpid.transport.ConnectionSettings;
import org.apache.qpid.transport.Receiver;
import org.apache.qpid.transport.Sender;
import org.apache.qpid.transport.TransportException;
import org.apache.qpid.transport.network.NetworkTransport;
import org.apache.qpid.transport.network.io.IoContext;
import org.apache.qpid.transport.network.io.IoReceiver;
import org.apache.qpid.transport.network.io.IoSender;
import org.apache.qpid.transport.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IoNetworkTransport
implements NetworkTransport,
IoContext {
    private static final Logger log;
    private Socket socket;
    private Sender<java.nio.ByteBuffer> sender;
    private IoReceiver receiver;
    private long timeout = 60000L;
    private ConnectionSettings settings;

    @Override
    public void init(ConnectionSettings settings) {
        try {
            this.settings = settings;
            InetAddress address = InetAddress.getByName(settings.getHost());
            this.socket = new Socket();
            this.socket.setReuseAddress(true);
            this.socket.setTcpNoDelay(settings.isTcpNodelay());
            log.debug("default-SO_RCVBUF : %s", this.socket.getReceiveBufferSize());
            log.debug("default-SO_SNDBUF : %s", this.socket.getSendBufferSize());
            this.socket.setSendBufferSize(settings.getWriteBufferSize());
            this.socket.setReceiveBufferSize(settings.getReadBufferSize());
            log.debug("new-SO_RCVBUF : %s", this.socket.getReceiveBufferSize());
            log.debug("new-SO_SNDBUF : %s", this.socket.getSendBufferSize());
            this.socket.connect(new InetSocketAddress(address, settings.getPort()));
        }
        catch (SocketException e) {
            throw new TransportException("Error connecting to broker", e);
        }
        catch (IOException e) {
            throw new TransportException("Error connecting to broker", e);
        }
    }

    @Override
    public void receiver(Receiver<java.nio.ByteBuffer> delegate) {
        this.receiver = new IoReceiver(this, delegate, 2 * this.settings.getReadBufferSize(), this.timeout);
    }

    @Override
    public Sender<java.nio.ByteBuffer> sender() {
        return new IoSender(this, 2 * this.settings.getWriteBufferSize(), this.timeout);
    }

    @Override
    public void close() {
    }

    @Override
    public Sender<java.nio.ByteBuffer> getSender() {
        return this.sender;
    }

    @Override
    public IoReceiver getReceiver() {
        return this.receiver;
    }

    @Override
    public Socket getSocket() {
        return this.socket;
    }

    static {
        ByteBuffer.setAllocator((ByteBufferAllocator)new SimpleByteBufferAllocator());
        ByteBuffer.setUseDirectBuffers((boolean)Boolean.getBoolean("amqj.enableDirectBuffers"));
        log = Logger.get(IoNetworkTransport.class);
    }
}

