/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport.network.io;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.apache.qpid.transport.Binding;
import org.apache.qpid.transport.TransportException;
import org.apache.qpid.transport.network.io.IoTransport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IoAcceptor<E>
extends Thread {
    private ServerSocket socket = new ServerSocket();
    private Binding<E, ByteBuffer> binding;

    public IoAcceptor(SocketAddress address, Binding<E, ByteBuffer> binding) throws IOException {
        this.socket.setReuseAddress(true);
        this.socket.bind(address);
        this.binding = binding;
        this.setName(String.format("IoAcceptor - %s", this.socket.getInetAddress()));
    }

    public void close() throws IOException {
        if (!this.socket.isClosed()) {
            this.socket.close();
        }
    }

    public IoAcceptor(String host, int port, Binding<E, ByteBuffer> binding) throws IOException {
        this(new InetSocketAddress(host, port), binding);
    }

    @Override
    public void run() {
        try {
            while (true) {
                Socket sock = this.socket.accept();
                IoTransport<E> ioTransport = new IoTransport<E>(sock, this.binding, false);
            }
        }
        catch (IOException e) {
            throw new TransportException(e);
        }
    }
}

