/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing.amqp_8_0;

import org.apache.mina.common.ByteBuffer;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyInstanceFactory;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.BasicCancelBody;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.amqp_8_0.AMQMethodBody_8_0;
import org.apache.qpid.framing.amqp_8_0.MethodDispatcher_8_0;

public class BasicCancelBodyImpl
extends AMQMethodBody_8_0
implements BasicCancelBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        public AMQMethodBody newInstance(ByteBuffer in, long size) throws AMQFrameDecodingException {
            return new BasicCancelBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 60;
    public static final int METHOD_ID = 30;
    private final AMQShortString _consumerTag;
    private final byte _bitfield0;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public BasicCancelBodyImpl(ByteBuffer buffer) throws AMQFrameDecodingException {
        this._consumerTag = this.readAMQShortString(buffer);
        this._bitfield0 = this.readBitfield(buffer);
    }

    public BasicCancelBodyImpl(AMQShortString consumerTag, boolean nowait) {
        this._consumerTag = consumerTag;
        byte bitfield0 = 0;
        if (nowait) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        this._bitfield0 = bitfield0;
    }

    public int getClazz() {
        return 60;
    }

    public int getMethod() {
        return 30;
    }

    public final AMQShortString getConsumerTag() {
        return this._consumerTag;
    }

    public final boolean getNowait() {
        return (this._bitfield0 & 1) != 0;
    }

    protected int getBodySize() {
        int size = 1;
        return size += this.getSizeOf(this._consumerTag);
    }

    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeAMQShortString(buffer, this._consumerTag);
        this.writeBitfield(buffer, this._bitfield0);
    }

    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_8_0)dispatcher).dispatchBasicCancel(this, channelId);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[BasicCancelBodyImpl: ");
        buf.append("consumerTag=");
        buf.append(this.getConsumerTag());
        buf.append(", ");
        buf.append("nowait=");
        buf.append(this.getNowait());
        buf.append("]");
        return buf.toString();
    }
}

