/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing.amqp_0_9;

import org.apache.mina.common.ByteBuffer;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyInstanceFactory;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.BasicGetOkBody;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.amqp_0_9.AMQMethodBody_0_9;
import org.apache.qpid.framing.amqp_0_9.MethodDispatcher_0_9;

public class BasicGetOkBodyImpl
extends AMQMethodBody_0_9
implements BasicGetOkBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        public AMQMethodBody newInstance(ByteBuffer in, long size) throws AMQFrameDecodingException {
            return new BasicGetOkBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 60;
    public static final int METHOD_ID = 71;
    private final long _deliveryTag;
    private final byte _bitfield0;
    private final AMQShortString _exchange;
    private final AMQShortString _routingKey;
    private final long _messageCount;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public BasicGetOkBodyImpl(ByteBuffer buffer) throws AMQFrameDecodingException {
        this._deliveryTag = this.readLong(buffer);
        this._bitfield0 = this.readBitfield(buffer);
        this._exchange = this.readAMQShortString(buffer);
        this._routingKey = this.readAMQShortString(buffer);
        this._messageCount = this.readUnsignedInteger(buffer);
    }

    public BasicGetOkBodyImpl(long deliveryTag, boolean redelivered, AMQShortString exchange, AMQShortString routingKey, long messageCount) {
        this._deliveryTag = deliveryTag;
        byte bitfield0 = 0;
        if (redelivered) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        this._bitfield0 = bitfield0;
        this._exchange = exchange;
        this._routingKey = routingKey;
        this._messageCount = messageCount;
    }

    public int getClazz() {
        return 60;
    }

    public int getMethod() {
        return 71;
    }

    public final long getDeliveryTag() {
        return this._deliveryTag;
    }

    public final boolean getRedelivered() {
        return (this._bitfield0 & 1) != 0;
    }

    public final AMQShortString getExchange() {
        return this._exchange;
    }

    public final AMQShortString getRoutingKey() {
        return this._routingKey;
    }

    public final long getMessageCount() {
        return this._messageCount;
    }

    protected int getBodySize() {
        int size = 13;
        size += this.getSizeOf(this._exchange);
        return size += this.getSizeOf(this._routingKey);
    }

    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeLong(buffer, this._deliveryTag);
        this.writeBitfield(buffer, this._bitfield0);
        this.writeAMQShortString(buffer, this._exchange);
        this.writeAMQShortString(buffer, this._routingKey);
        this.writeUnsignedInteger(buffer, this._messageCount);
    }

    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_0_9)dispatcher).dispatchBasicGetOk(this, channelId);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[BasicGetOkBodyImpl: ");
        buf.append("deliveryTag=");
        buf.append(this.getDeliveryTag());
        buf.append(", ");
        buf.append("redelivered=");
        buf.append(this.getRedelivered());
        buf.append(", ");
        buf.append("exchange=");
        buf.append(this.getExchange());
        buf.append(", ");
        buf.append("routingKey=");
        buf.append(this.getRoutingKey());
        buf.append(", ");
        buf.append("messageCount=");
        buf.append(this.getMessageCount());
        buf.append("]");
        return buf.toString();
    }
}

