/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import java.util.HashMap;

public class ClassLoadingAwareObjectInputStream
extends ObjectInputStream {
    private static final ClassLoader _ON_FAULT_CLASS_LOADER = ClassLoadingAwareObjectInputStream.class.getClassLoader();
    private static final HashMap<String, Class> _primitives = new HashMap(8, 1.0f);
    private final TrustedClassFilter _securityFilter;

    public ClassLoadingAwareObjectInputStream(InputStream in, TrustedClassFilter filter) throws IOException {
        super(in);
        this._securityFilter = filter;
    }

    protected Class resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Class clazz = this.load(classDesc.getName(), cl);
        return this.checkSecurity(clazz);
    }

    protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Class[] cinterfaces = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            cinterfaces[i] = this.load(interfaces[i], cl);
        }
        Class<?> clazz = null;
        IllegalArgumentException failureCause = null;
        try {
            clazz = Proxy.getProxyClass(cl, cinterfaces);
        }
        catch (IllegalArgumentException e) {
            failureCause = e;
            try {
                clazz = Proxy.getProxyClass(_ON_FAULT_CLASS_LOADER, cinterfaces);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (clazz != null) {
            return this.checkSecurity(clazz);
        }
        throw new ClassNotFoundException("Failed find class.", failureCause);
    }

    private Class<?> checkSecurity(Class<?> clazz) throws ClassNotFoundException {
        if (!clazz.isPrimitive() && this._securityFilter != null && !this._securityFilter.isTrusted(clazz)) {
            throw new ClassNotFoundException("Forbidden " + clazz + "! " + "This class is not trusted to be deserialized from ObjectMessage payloads.");
        }
        return clazz;
    }

    private Class load(String className, ClassLoader cl) throws ClassNotFoundException {
        try {
            return Class.forName(className, false, cl);
        }
        catch (ClassNotFoundException e) {
            Class clazz = _primitives.get(className);
            if (clazz != null) {
                return clazz;
            }
            return Class.forName(className, false, _ON_FAULT_CLASS_LOADER);
        }
    }

    static {
        _primitives.put("boolean", Boolean.TYPE);
        _primitives.put("byte", Byte.TYPE);
        _primitives.put("char", Character.TYPE);
        _primitives.put("short", Short.TYPE);
        _primitives.put("int", Integer.TYPE);
        _primitives.put("long", Long.TYPE);
        _primitives.put("float", Float.TYPE);
        _primitives.put("double", Double.TYPE);
        _primitives.put("void", Void.TYPE);
    }

    public static interface TrustedClassFilter {
        public boolean isTrusted(Class<?> var1);
    }
}

