/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.message;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import org.apache.qpid.QpidException;
import org.apache.qpid.client.message.AMQMessageDelegate;
import org.apache.qpid.client.message.AMQMessageDelegateFactory;
import org.apache.qpid.client.message.JMSMapMessage;
import org.apache.qpid.transport.codec.BBDecoder;
import org.apache.qpid.transport.codec.BBEncoder;

public class AMQPEncodedMapMessage
extends JMSMapMessage {
    public static final String MIME_TYPE = "amqp/map";

    public AMQPEncodedMapMessage(AMQMessageDelegateFactory delegateFactory) throws JMSException {
        this(delegateFactory, null);
    }

    AMQPEncodedMapMessage(AMQMessageDelegateFactory delegateFactory, ByteBuffer data) throws JMSException {
        super(delegateFactory, data);
    }

    AMQPEncodedMapMessage(AMQMessageDelegate delegate, ByteBuffer data) throws QpidException {
        super(delegate, data);
    }

    @Override
    protected String getMimeType() {
        return MIME_TYPE;
    }

    @Override
    public void setObject(String propName, Object value) throws JMSException {
        this.checkWritable();
        this.checkPropertyName(propName);
        if (!(value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Character || value instanceof Float || value instanceof Double || value instanceof String || value instanceof byte[] || value instanceof List || value instanceof Map || value instanceof UUID || value == null)) {
            throw new MessageFormatException("Cannot set property " + propName + " to value " + value + "of type " + value.getClass().getName() + ".");
        }
        this.getMap().put(propName, value);
    }

    @Override
    public ByteBuffer getData() {
        BBEncoder encoder = new BBEncoder(1024);
        encoder.writeMap(this.getMap());
        return encoder.segment();
    }

    @Override
    protected void populateMapFromData(ByteBuffer data) throws JMSException {
        if (data != null) {
            data.rewind();
            BBDecoder decoder = new BBDecoder();
            decoder.init(data);
            this.setMap(decoder.readMap());
        } else {
            this.getMap().clear();
        }
    }

    @Override
    public Map<String, Object> getMap() {
        return super.getMap();
    }
}

