/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.message;

import java.util.List;
import javax.jms.JMSException;
import org.apache.mina.common.ByteBuffer;
import org.apache.qpid.AMQException;
import org.apache.qpid.client.message.AMQMessageDelegate;
import org.apache.qpid.client.message.AMQMessageDelegate_0_10;
import org.apache.qpid.client.message.AMQMessageDelegate_0_8;
import org.apache.qpid.client.message.AbstractJMSMessage;
import org.apache.qpid.client.message.MessageFactory;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.BasicContentHeaderProperties;
import org.apache.qpid.framing.ContentBody;
import org.apache.qpid.framing.ContentHeaderBody;
import org.apache.qpid.transport.DeliveryProperties;
import org.apache.qpid.transport.MessageProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJMSMessageFactory
implements MessageFactory {
    private static final Logger _logger = LoggerFactory.getLogger(AbstractJMSMessageFactory.class);

    protected AbstractJMSMessage create08MessageWithBody(long messageNbr, ContentHeaderBody contentHeader, AMQShortString exchange, AMQShortString routingKey, List bodies) throws AMQException {
        ByteBuffer data;
        boolean debug = _logger.isDebugEnabled();
        if (bodies != null && bodies.size() == 1) {
            if (debug) {
                _logger.debug("Non-fragmented message body (bodySize=" + contentHeader.bodySize + ")");
            }
            data = ((ContentBody)bodies.get((int)0)).payload;
        } else if (bodies != null) {
            if (debug) {
                _logger.debug("Fragmented message body (" + bodies.size() + " frames, bodySize=" + contentHeader.bodySize + ")");
            }
            data = ByteBuffer.allocate((int)((int)contentHeader.bodySize));
            for (ContentBody cb : bodies) {
                ByteBuffer payload = cb.payload;
                if (payload.isDirect() || payload.isReadOnly()) {
                    data.put(payload);
                } else {
                    data.put(payload.array(), payload.arrayOffset(), payload.limit());
                }
                payload.release();
            }
            data.flip();
        } else {
            data = ByteBuffer.allocate((int)0);
        }
        if (debug) {
            _logger.debug("Creating message from buffer with position=" + data.position() + " and remaining=" + data.remaining());
        }
        AMQMessageDelegate_0_8 delegate = new AMQMessageDelegate_0_8(messageNbr, (BasicContentHeaderProperties)contentHeader.getProperties(), exchange, routingKey);
        return this.createMessage(delegate, data);
    }

    protected abstract AbstractJMSMessage createMessage(AMQMessageDelegate var1, ByteBuffer var2) throws AMQException;

    protected AbstractJMSMessage create010MessageWithBody(long messageNbr, MessageProperties msgProps, DeliveryProperties deliveryProps, java.nio.ByteBuffer body) throws AMQException {
        boolean debug = _logger.isDebugEnabled();
        ByteBuffer data = body != null ? ByteBuffer.wrap((java.nio.ByteBuffer)body) : ByteBuffer.allocate((int)0);
        if (debug) {
            _logger.debug("Creating message from buffer with position=" + data.position() + " and remaining=" + data.remaining());
        }
        AMQMessageDelegate_0_10 delegate = new AMQMessageDelegate_0_10(msgProps, deliveryProps, messageNbr);
        AbstractJMSMessage message = this.createMessage(delegate, data);
        return message;
    }

    private static final String asString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return new String(bytes);
    }

    public AbstractJMSMessage createMessage(long messageNbr, boolean redelivered, ContentHeaderBody contentHeader, AMQShortString exchange, AMQShortString routingKey, List bodies) throws JMSException, AMQException {
        AbstractJMSMessage msg = this.create08MessageWithBody(messageNbr, contentHeader, exchange, routingKey, bodies);
        msg.setJMSRedelivered(redelivered);
        msg.receivedFromServer();
        return msg;
    }

    public AbstractJMSMessage createMessage(long messageNbr, boolean redelivered, MessageProperties msgProps, DeliveryProperties deliveryProps, java.nio.ByteBuffer body) throws JMSException, AMQException {
        AbstractJMSMessage msg = this.create010MessageWithBody(messageNbr, msgProps, deliveryProps, body);
        msg.setJMSRedelivered(redelivered);
        msg.receivedFromServer();
        return msg;
    }
}

