/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.rolling.RollingFileAppender;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.qpid.server.logging.LogFileDetails;
import org.apache.qpid.server.logging.logback.AbstractVirtualHostLogger;
import org.apache.qpid.server.logging.logback.AppenderUtils;
import org.apache.qpid.server.logging.logback.FileLoggerSettings;
import org.apache.qpid.server.logging.logback.RollingPolicyDecorator;
import org.apache.qpid.server.logging.logback.RolloverWatcher;
import org.apache.qpid.server.logging.logback.VirtualHostFileLogger;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Content;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.Param;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.util.DaemonThreadFactory;

public class VirtualHostFileLoggerImpl
extends AbstractVirtualHostLogger<VirtualHostFileLoggerImpl>
implements VirtualHostFileLogger<VirtualHostFileLoggerImpl>,
FileLoggerSettings {
    private volatile RolloverWatcher _rolloverWatcher;
    private ScheduledExecutorService _rolledPolicyExecutor;
    @ManagedAttributeField
    private String _layout;
    @ManagedAttributeField
    private String _fileName;
    @ManagedAttributeField
    private boolean _rollDaily;
    @ManagedAttributeField
    private boolean _rollOnRestart;
    @ManagedAttributeField
    private boolean _compressOldFiles;
    @ManagedAttributeField
    private int _maxHistory;
    @ManagedAttributeField
    private int _maxFileSize;
    @ManagedAttributeField
    private boolean _safeMode;

    @ManagedObjectFactoryConstructor
    protected VirtualHostFileLoggerImpl(Map<String, Object> attributes, VirtualHost<?> virtualHost) {
        super(attributes, virtualHost);
    }

    @Override
    protected void postResolveChildren() {
        this._rolloverWatcher = new RolloverWatcher(this.getFileName());
        this._rolledPolicyExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DaemonThreadFactory("RolledFileScanner-" + this.getName()));
        super.postResolveChildren();
    }

    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        super.validateChange(proxyForValidation, changedAttributes);
        VirtualHostFileLogger virtualHostFileLogger = (VirtualHostFileLogger)proxyForValidation;
        if (changedAttributes.contains("fileName") && virtualHostFileLogger.getFileName() != null) {
            AppenderUtils.validateLogFilePermissions(new File(virtualHostFileLogger.getFileName()));
        }
        if (changedAttributes.contains("maxFileSize")) {
            AppenderUtils.validateMaxFileSize(virtualHostFileLogger.getMaxFileSize());
        }
    }

    @Override
    public String getFileName() {
        return this._fileName;
    }

    @Override
    public boolean isRollDaily() {
        return this._rollDaily;
    }

    @Override
    public boolean isRollOnRestart() {
        return this._rollOnRestart;
    }

    @Override
    public boolean isCompressOldFiles() {
        return this._compressOldFiles;
    }

    @Override
    public int getMaxHistory() {
        return this._maxHistory;
    }

    @Override
    public int getMaxFileSize() {
        return this._maxFileSize;
    }

    @Override
    public String getLayout() {
        return this._layout;
    }

    @Override
    public List<LogFileDetails> getLogFiles() {
        return this._rolloverWatcher == null ? Collections.emptyList() : this._rolloverWatcher.getLogFileDetails();
    }

    @Override
    public Content getFile(String fileName) {
        return this._rolloverWatcher == null ? null : this._rolloverWatcher.getFileContent(fileName);
    }

    @Override
    public Content getFiles(@Param(name="fileName") Set<String> fileName) {
        return this._rolloverWatcher == null ? null : this._rolloverWatcher.getFilesAsZippedContent(fileName);
    }

    @Override
    public Content getAllFiles() {
        return this._rolloverWatcher == null ? null : this._rolloverWatcher.getAllFilesAsZippedContent();
    }

    @Override
    public void stopLogging() {
        super.stopLogging();
        if (this._rolledPolicyExecutor != null) {
            this._rolledPolicyExecutor.shutdown();
        }
    }

    @Override
    public RollingPolicyDecorator.RolloverListener getRolloverListener() {
        return this._rolloverWatcher;
    }

    @Override
    public ScheduledExecutorService getExecutorService() {
        return this._rolledPolicyExecutor;
    }

    @Override
    protected Appender<ILoggingEvent> createAppenderInstance(Context loggerContext) {
        RollingFileAppender appender = new RollingFileAppender();
        AppenderUtils.configureRollingFileAppender(this, loggerContext, (RollingFileAppender<ILoggingEvent>)appender);
        return appender;
    }
}

