/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhost.derby;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.VirtualHostNode;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.derby.DerbyMessageStore;
import org.apache.qpid.server.store.derby.DerbyUtils;
import org.apache.qpid.server.store.jdbc.JDBCContainer;
import org.apache.qpid.server.store.jdbc.JDBCDetails;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.apache.qpid.server.util.FileHelper;
import org.apache.qpid.server.virtualhost.AbstractVirtualHost;
import org.apache.qpid.server.virtualhost.derby.DerbyVirtualHost;

public class DerbyVirtualHostImpl
extends AbstractVirtualHost<DerbyVirtualHostImpl>
implements DerbyVirtualHost<DerbyVirtualHostImpl>,
JDBCContainer {
    public static final String VIRTUAL_HOST_TYPE = "DERBY";
    @ManagedAttributeField
    private String _storePath;
    @ManagedAttributeField
    private Long _storeUnderfullSize;
    @ManagedAttributeField
    private Long _storeOverfullSize;

    @ManagedObjectFactoryConstructor(conditionallyAvailable=true, condition="org.apache.qpid.server.store.derby.DerbyUtils#isAvailable()")
    public DerbyVirtualHostImpl(Map<String, Object> attributes, VirtualHostNode<?> virtualHostNode) {
        super(attributes, virtualHostNode);
    }

    protected MessageStore createMessageStore() {
        return new DerbyMessageStore();
    }

    @Override
    public String getStorePath() {
        return this._storePath;
    }

    @Override
    public Long getStoreUnderfullSize() {
        return this._storeUnderfullSize;
    }

    @Override
    public Long getStoreOverfullSize() {
        return this._storeOverfullSize;
    }

    protected void validateMessageStoreCreation() {
        if (!new FileHelper().isWritableDirectory(this.getStorePath())) {
            throw new IllegalConfigurationException("The store path is not writable directory");
        }
    }

    public JDBCDetails getJDBCDetails() {
        return JDBCDetails.getJdbcDetails((String)"derby", (ConfiguredObject)this);
    }

    public Connection getConnection() {
        try {
            return ((DerbyMessageStore)this.getMessageStore()).getConnection();
        }
        catch (SQLException e) {
            throw new ConnectionScopedRuntimeException(String.format("Error opening connection to database for VirtualHost '%s'", this.getName()));
        }
    }

    public String getTableNamePrefix() {
        return "";
    }

    static {
        DerbyUtils.configureDerbyLogging();
    }
}

