/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8;

import java.nio.BufferUnderflowException;
import java.util.List;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.plugin.MessageFormat;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.protocol.v0_8.AMQFrameDecodingException;
import org.apache.qpid.server.protocol.v0_8.AMQMessage;
import org.apache.qpid.server.protocol.v0_8.AMQShortString;
import org.apache.qpid.server.protocol.v0_8.MessageMetaData;
import org.apache.qpid.server.protocol.v0_8.transport.ContentHeaderBody;
import org.apache.qpid.server.protocol.v0_8.transport.MessagePublishInfo;
import org.apache.qpid.server.store.MessageHandle;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;

@PluggableService
public class MessageFormat_0_9_1
implements MessageFormat<AMQMessage> {
    public static final int AMQP_MESSAGE_FORMAT_0_9_1 = 91;
    private static final byte MANDATORY_MASK = 1;
    private static final byte IMMEDIATE_MASK = 2;

    public String getType() {
        return "AMQP_0_9_1";
    }

    public int getSupportedFormat() {
        return 91;
    }

    public Class<AMQMessage> getMessageClass() {
        return AMQMessage.class;
    }

    /*
     * Exception decompiling
     */
    public QpidByteBuffer convertToMessageFormat(AMQMessage message) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public AMQMessage createMessage(QpidByteBuffer payload, MessageStore store, Object connectionReference) {
        try {
            AMQShortString exchange = this.readShortString(payload);
            AMQShortString routingKey = this.readShortString(payload);
            byte flags = payload.get();
            MessagePublishInfo publishBody = new MessagePublishInfo(exchange, (flags & 2) != 0, (flags & 1) != 0, routingKey);
            ContentHeaderBody contentHeaderBody = this.readContentBody(payload);
            MessageMetaData mmd = new MessageMetaData(publishBody, contentHeaderBody);
            MessageHandle handle = store.addMessage((StorableMessageMetaData)mmd);
            handle.addContent(payload);
            StoredMessage storedMessage = handle.allContentAdded();
            return new AMQMessage((StoredMessage<MessageMetaData>)storedMessage, connectionReference);
        }
        catch (BufferUnderflowException | AMQFrameDecodingException e) {
            throw new ConnectionScopedRuntimeException("Error parsing AMQP 0-9-1 message format", (Throwable)e);
        }
    }

    private ContentHeaderBody readContentBody(QpidByteBuffer buf) throws AMQFrameDecodingException {
        long size = buf.getUnsignedInt();
        try (QpidByteBuffer buffer = this.readByteBuffer(buf, size);){
            long newPosition = (long)buf.position() + size;
            if (newPosition > Integer.MAX_VALUE) {
                throw new IllegalStateException(String.format("trying to advance QBB to %d which is larger than MAX_INT", newPosition));
            }
            buf.position((int)newPosition);
            ContentHeaderBody contentHeaderBody = new ContentHeaderBody(buffer, size);
            return contentHeaderBody;
        }
    }

    private QpidByteBuffer readByteBuffer(QpidByteBuffer data, long size) {
        return data.view(0, (int)size);
    }

    private int readInt(List<QpidByteBuffer> data) {
        int required = 4;
        int result = 0;
        for (QpidByteBuffer buf : data) {
            if (required == 4 && buf.remaining() >= 4) {
                return buf.getInt();
            }
            while (buf.remaining() > 0) {
                result <<= 8;
                result |= buf.get() & 0xFF;
                if (--required != 0) continue;
                return result;
            }
        }
        throw new BufferUnderflowException();
    }

    private AMQShortString readShortString(QpidByteBuffer data) {
        return AMQShortString.readAMQShortString(data);
    }
}

