/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.validation;

import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"org.apache.qpid.server.model.ManagedAttributeField"})
public class AttributeFieldValidation
extends AbstractProcessor {
    public static final String MANAGED_ATTRIBUTE_FIELD_CLASS_NAME = "org.apache.qpid.server.model.ManagedAttributeField";

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Elements elementUtils = this.processingEnv.getElementUtils();
        Types typeUtils = this.processingEnv.getTypeUtils();
        TypeElement annotationElement = elementUtils.getTypeElement(MANAGED_ATTRIBUTE_FIELD_CLASS_NAME);
        for (Element element : roundEnv.getElementsAnnotatedWith(annotationElement)) {
            for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                if (!typeUtils.isSameType(annotationMirror.getAnnotationType(), annotationElement.asType())) continue;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                    TypeElement parent;
                    String methodName;
                    String elementName = entry.getKey().getSimpleName().toString();
                    if (!elementName.equals("beforeSet") && !elementName.equals("afterSet") || "".equals(methodName = entry.getValue().getValue().toString()) || this.containsMethod(parent = (TypeElement)element.getEnclosingElement(), methodName)) continue;
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Could not find method '" + methodName + "' which is defined as the " + elementName + " action", element);
                }
            }
        }
        return false;
    }

    private boolean containsMethod(TypeElement parent, String methodName) {
        for (Element element : parent.getEnclosedElements()) {
            if (!element.getKind().equals((Object)ElementKind.METHOD) || !element.getSimpleName().toString().equals(methodName) || !((ExecutableElement)element).getParameters().isEmpty()) continue;
            return true;
        }
        return false;
    }
}

