/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.apache.qpid.server.License;
import org.apache.qpid.server.model.SystemConfigFactoryConstructor;

public class SystemConfigFactoryGenerator
extends AbstractProcessor {
    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton(SystemConfigFactoryConstructor.class.getName());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return true;
        }
        Filer filer = this.processingEnv.getFiler();
        try {
            for (Element element : roundEnv.getElementsAnnotatedWith(SystemConfigFactoryConstructor.class)) {
                if (element.getKind() != ElementKind.CONSTRUCTOR) continue;
                ExecutableElement constructorElement = (ExecutableElement)element;
                String string = this.generateObjectFactory(filer, constructorElement);
            }
        }
        catch (Exception e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error: " + e.getLocalizedMessage());
        }
        return true;
    }

    private String generateObjectFactory(Filer filer, ExecutableElement constructorElement) {
        TypeElement classElement = (TypeElement)constructorElement.getEnclosingElement();
        String factoryName = classElement.getQualifiedName().toString() + "Factory";
        String factorySimpleName = classElement.getSimpleName().toString() + "Factory";
        String objectSimpleName = classElement.getSimpleName().toString();
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Generating factory file for " + classElement.getQualifiedName().toString());
        PackageElement packageElement = (PackageElement)classElement.getEnclosingElement();
        try {
            JavaFileObject factoryFile = filer.createSourceFile(factoryName, new Element[0]);
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(factoryFile.openOutputStream(), "UTF-8"));
            pw.println("/*");
            for (String headerLine : License.LICENSE) {
                pw.println(" *" + headerLine);
            }
            pw.println(" */");
            pw.println();
            pw.print("package ");
            pw.print(packageElement.getQualifiedName());
            pw.println(";");
            pw.println();
            pw.println("import java.security.Principal;");
            pw.println("import java.util.Map;");
            pw.println();
            pw.println("import org.apache.qpid.server.configuration.updater.TaskExecutor;");
            pw.println("import org.apache.qpid.server.logging.EventLogger;");
            pw.println("import org.apache.qpid.server.model.ConfiguredObjectTypeRegistry;");
            pw.println("import org.apache.qpid.server.model.SystemConfig;");
            pw.println("import org.apache.qpid.server.plugin.PluggableService;");
            pw.println("import org.apache.qpid.server.plugin.SystemConfigFactory;");
            pw.println();
            pw.println("@PluggableService");
            pw.println("public final class " + factorySimpleName + " implements SystemConfigFactory<" + objectSimpleName + ">");
            pw.println("{");
            pw.println("    public " + factorySimpleName + "()");
            pw.println("    {");
            pw.println("    }");
            pw.println();
            pw.println("    @Override");
            pw.println("    public final String getType()");
            pw.println("    {");
            pw.println("        return ConfiguredObjectTypeRegistry.getType(" + objectSimpleName + ".class);");
            pw.println("    }");
            pw.println();
            pw.println("    @Override");
            pw.println("    public " + objectSimpleName + " newInstance(final TaskExecutor taskExecutor,");
            pw.println("                       final EventLogger eventLogger,");
            pw.println("                       final Principal systemPrincipal,");
            pw.println("                       final Map<String,Object> attributes)");
            pw.println("    {");
            pw.println("        return new " + objectSimpleName + "(taskExecutor, eventLogger, systemPrincipal, attributes);");
            pw.println("    }");
            pw.println("}");
            pw.close();
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to write factory file: " + factoryName + " - " + e.getLocalizedMessage());
        }
        return factoryName;
    }
}

