/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.apache.qpid.server.License;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;

public class ConfiguredObjectFactoryGenerator
extends AbstractProcessor {
    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton(ManagedObjectFactoryConstructor.class.getName());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return true;
        }
        Filer filer = this.processingEnv.getFiler();
        try {
            for (Element element : roundEnv.getElementsAnnotatedWith(ManagedObjectFactoryConstructor.class)) {
                if (element.getKind() != ElementKind.CONSTRUCTOR) continue;
                ExecutableElement constructorElement = (ExecutableElement)element;
                this.generateAccessControlEnforcingSubclass(filer, constructorElement);
                this.generateObjectFactory(filer, constructorElement);
            }
        }
        catch (Exception e) {
            try (StringWriter stringWriter = new StringWriter();
                 PrintWriter pw = new PrintWriter(stringWriter);){
                e.printStackTrace(pw);
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Unexpected Error: " + stringWriter.toString());
            }
            catch (IOException iOException) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error: " + iOException.getLocalizedMessage());
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void generateAccessControlEnforcingSubclass(Filer filer, ExecutableElement constructorElement) {
        TypeElement classElement = (TypeElement)constructorElement.getEnclosingElement();
        String childClassName = classElement.getQualifiedName().toString() + "WithAccessChecking";
        String childClassSimpleName = classElement.getSimpleName().toString() + "WithAccessChecking";
        String objectSimpleName = classElement.getSimpleName().toString();
        PackageElement packageElement = (PackageElement)classElement.getEnclosingElement();
        try {
            void var12_16;
            JavaFileObject factoryFile = filer.createSourceFile(childClassName, new Element[0]);
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(factoryFile.openOutputStream(), "UTF-8"));
            pw.println("/*");
            String[] stringArray = License.LICENSE;
            int n = stringArray.length;
            boolean bl = false;
            while (var12_16 < n) {
                String headerLine = stringArray[var12_16];
                pw.println(" *" + headerLine);
                ++var12_16;
            }
            pw.println(" */");
            pw.println();
            pw.print("package ");
            pw.print(packageElement.getQualifiedName());
            pw.println(";");
            pw.println();
            pw.println("import static org.apache.qpid.server.security.access.Operation.INVOKE_METHOD;");
            pw.println();
            pw.println("import java.util.Map;");
            pw.println("import java.util.concurrent.CompletableFuture;");
            pw.println("import java.util.concurrent.ExecutionException;");
            pw.println();
            pw.println("import org.apache.qpid.server.configuration.updater.Task;");
            pw.println("import org.apache.qpid.server.util.FixedKeyMapCreator;");
            pw.println();
            pw.println("final class " + childClassSimpleName + " extends " + objectSimpleName);
            pw.println("{");
            pw.print("    " + childClassSimpleName + "(final Map<String, Object> attributes");
            boolean first = true;
            for (VariableElement variableElement : constructorElement.getParameters()) {
                if (first) {
                    first = false;
                    continue;
                }
                pw.print(", final " + String.valueOf(variableElement.asType()) + " " + this.createParamNameFromType(variableElement));
            }
            pw.println(")");
            pw.println("    {");
            pw.print("        super(attributes");
            first = true;
            for (VariableElement variableElement : constructorElement.getParameters()) {
                if (first) {
                    first = false;
                    continue;
                }
                pw.print(", " + this.createParamNameFromType(variableElement));
            }
            pw.println(");");
            pw.println("    }");
            pw.println();
            this.generateAccessCheckedMethods(childClassSimpleName, classElement, pw, new HashSet<TypeElement>(), new HashSet<String>());
            pw.println("}");
            pw.close();
        }
        catch (IOException | ClassNotFoundException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to write file: " + childClassName + " - " + e.getLocalizedMessage());
        }
    }

    private void generateAccessCheckedMethods(String className, TypeElement typeElement, PrintWriter pw, HashSet<TypeElement> processedClasses, HashSet<String> processedMethods) throws ClassNotFoundException {
        if (processedClasses.add(typeElement)) {
            Element superClassElement = this.processingEnv.getTypeUtils().asElement(typeElement.getSuperclass());
            if (superClassElement instanceof TypeElement) {
                this.generateAccessCheckedMethods(className, (TypeElement)superClassElement, pw, processedClasses, processedMethods);
            }
            for (TypeMirror typeMirror : typeElement.getInterfaces()) {
                Element ifElement = this.processingEnv.getTypeUtils().asElement(typeMirror);
                if (!(ifElement instanceof TypeElement)) continue;
                this.generateAccessCheckedMethods(className, (TypeElement)ifElement, pw, processedClasses, processedMethods);
            }
            block1: for (Element element : typeElement.getEnclosedElements()) {
                if (!(element instanceof ExecutableElement) || element.getKind() != ElementKind.METHOD || processedMethods.contains(element.getSimpleName().toString())) continue;
                for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                    if (annotationMirror.getAnnotationType().toString().equals("org.apache.qpid.server.model.ManagedOperation")) {
                        processedMethods.add(element.getSimpleName().toString());
                        this.processManagedOperation(pw, className, (ExecutableElement)element, annotationMirror);
                        continue block1;
                    }
                    if (!annotationMirror.getAnnotationType().toString().equals("org.apache.qpid.server.model.DoOnConfigThread")) continue;
                    processedMethods.add(element.getSimpleName().toString());
                    this.processDoOnConfigMethod(pw, className, (ExecutableElement)element, annotationMirror);
                    continue block1;
                }
            }
        }
    }

    private void processDoOnConfigMethod(PrintWriter pw, String className, ExecutableElement methodElement, AnnotationMirror annotationMirror) {
        pw.println("    @Override");
        pw.print("    public " + String.valueOf(methodElement.getReturnType()) + " " + methodElement.getSimpleName().toString() + "(");
        boolean first = true;
        for (VariableElement variableElement : methodElement.getParameters()) {
            if (first) {
                first = false;
            } else {
                pw.print(", ");
            }
            pw.print("final ");
            pw.print(variableElement.asType());
            pw.print(" ");
            pw.print(this.getParamName(variableElement));
        }
        pw.println(")");
        List<? extends TypeMirror> thrownTypes = methodElement.getThrownTypes();
        if (!thrownTypes.isEmpty()) {
            pw.println(thrownTypes.stream().map(TypeMirror::toString).collect(Collectors.joining(" , ", "    throws ", "")));
        }
        pw.println("    {");
        String string = this.getParameterList(methodElement);
        String callToSuper = "super." + methodElement.getSimpleName().toString() + string;
        pw.print("        ");
        if (methodElement.getReturnType().getKind() != TypeKind.VOID) {
            pw.print("return ");
        }
        pw.println(this.wrapByDoOnConfigThread(callToSuper, className, methodElement));
        pw.println("    }");
        pw.println();
    }

    private void processManagedOperation(PrintWriter pw, String className, ExecutableElement methodElement, AnnotationMirror annotationMirror) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = this.processingEnv.getElementUtils().getElementValuesWithDefaults(annotationMirror);
        boolean wrapCallToSuper = false;
        boolean log = false;
        boolean skipAclCheck = false;
        for (ExecutableElement executableElement : elementValues.keySet()) {
            if ("changesConfiguredObjectState".contentEquals(executableElement.getSimpleName())) {
                wrapCallToSuper = (Boolean)elementValues.get(executableElement).getValue();
                continue;
            }
            if ("log".contentEquals(executableElement.getSimpleName())) {
                log = (Boolean)elementValues.get(executableElement).getValue();
                continue;
            }
            if (!"skipAclCheck".contentEquals(executableElement.getSimpleName())) continue;
            skipAclCheck = (Boolean)elementValues.get(executableElement).getValue();
        }
        if (!methodElement.getParameters().isEmpty() && !skipAclCheck) {
            pw.print("    private static final FixedKeyMapCreator ");
            pw.print(methodElement.getSimpleName().toString().replaceAll("([A-Z])", "_$1").toUpperCase() + "_MAP_CREATOR");
            pw.print(" = new FixedKeyMapCreator(\"");
            boolean first = true;
            for (VariableElement variableElement : methodElement.getParameters()) {
                if (first) {
                    first = false;
                } else {
                    pw.print("\", \"");
                }
                pw.print(this.getParamName(variableElement));
            }
            pw.println("\");");
            pw.println();
        }
        pw.print("    public " + String.valueOf(methodElement.getReturnType()) + " " + methodElement.getSimpleName().toString() + "(");
        boolean first = true;
        for (VariableElement variableElement : methodElement.getParameters()) {
            if (first) {
                first = false;
            } else {
                pw.print(", ");
            }
            pw.print("final ");
            pw.print(variableElement.asType());
            pw.print(" ");
            pw.print(this.getParamName(variableElement));
        }
        pw.println(")");
        pw.println("    {");
        String string = this.getParameterList(methodElement);
        if (!skipAclCheck) {
            pw.print("        authorise(INVOKE_METHOD(\"");
            pw.print(methodElement.getSimpleName().toString());
            pw.print("\")");
            if (!methodElement.getParameters().isEmpty()) {
                pw.print(", ");
                pw.print(methodElement.getSimpleName().toString().replaceAll("([A-Z])", "_$1").toUpperCase() + "_MAP_CREATOR");
                pw.print(".createMap" + string);
            }
            pw.println(");");
            pw.println();
        }
        if (log) {
            pw.print("        logOperation(\"");
            pw.print(methodElement.getSimpleName().toString());
            pw.println("\");");
        }
        String string2 = "super." + methodElement.getSimpleName().toString() + string;
        pw.print("        ");
        if (methodElement.getReturnType().getKind() != TypeKind.VOID) {
            pw.print("return ");
        }
        if (wrapCallToSuper) {
            pw.println(this.wrapByDoOnConfigThread(string2, className, methodElement));
        } else {
            pw.println(string2 + ";");
        }
        pw.println("    }");
        pw.println();
    }

    private String wrapByDoOnConfigThread(String callToWrap, String className, ExecutableElement methodElement) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter pw = new PrintWriter(stringWriter);
        String boxedReturnTypeName = this.getBoxedReturnTypeAsString(methodElement);
        pw.println("doSync(doOnConfigThread(new Task<CompletableFuture<" + boxedReturnTypeName + ">, RuntimeException>()");
        pw.println("            {");
        pw.println("                private String _args;");
        pw.println("                @Override");
        pw.println("                public CompletableFuture<" + boxedReturnTypeName + "> execute()");
        pw.println("                {");
        List<? extends TypeMirror> thrownTypes = methodElement.getThrownTypes();
        if (!thrownTypes.isEmpty()) {
            pw.println("                    try");
            pw.println("                    {");
        }
        if (methodElement.getReturnType().getKind() != TypeKind.VOID) {
            pw.println("                    return CompletableFuture.<" + boxedReturnTypeName + ">completedFuture(" + className + "." + callToWrap + ");");
        } else {
            pw.println("                    " + className + "." + callToWrap + ";");
            pw.println("                    return CompletableFuture.<" + boxedReturnTypeName + ">completedFuture(null);");
        }
        if (!thrownTypes.isEmpty()) {
            pw.println("                    }");
            pw.println(thrownTypes.stream().map(TypeMirror::toString).collect(Collectors.joining(" | ", "                    catch (", " e)")));
            pw.println("                    {");
            pw.println("                        return CompletableFuture.failedFuture(e);");
            pw.println("                    }");
        }
        pw.println("                }");
        pw.println("                @Override");
        pw.println("                public String getObject()");
        pw.println("                {");
        pw.println("                    return " + className + ".this.toString();");
        pw.println("                }");
        pw.println("                @Override");
        pw.println("                public String getAction()");
        pw.println("                {");
        pw.println("                    return \"" + String.valueOf(methodElement.getSimpleName()) + "\";");
        pw.println("                }");
        pw.println("                @Override");
        pw.println("                public String getArguments()");
        pw.println("                {");
        if (!methodElement.getParameters().isEmpty()) {
            pw.println("                    if (_args == null)");
            pw.println("                    {");
            boolean first = true;
            Object args = "_args = ";
            for (VariableElement variableElement : methodElement.getParameters()) {
                if (!first) {
                    args = (String)args + " + \",\" + ";
                } else {
                    first = false;
                }
                args = (String)args + "\"" + this.getParamName(variableElement) + "=\" + " + this.getParamName(variableElement);
            }
            pw.println("                        " + (String)args + ";");
            pw.println("                    }");
        }
        pw.println("                    return _args;");
        pw.println("                }");
        pw.println("            }));");
        return stringWriter.toString();
    }

    private String getBoxedReturnTypeAsString(ExecutableElement methodElement) {
        String returnTypeName;
        TypeMirror returnType = methodElement.getReturnType();
        if (returnType.getKind().isPrimitive()) {
            TypeElement returnTypeElement = this.processingEnv.getTypeUtils().boxedClass((PrimitiveType)returnType);
            returnTypeName = returnTypeElement.asType().toString();
        } else {
            returnTypeName = returnType.getKind() == TypeKind.VOID ? "Void" : methodElement.getReturnType().toString();
        }
        return returnTypeName;
    }

    private String getParameterList(ExecutableElement methodElement) {
        StringBuilder parametersStringBuilder = new StringBuilder("(");
        boolean first = true;
        for (VariableElement variableElement : methodElement.getParameters()) {
            if (first) {
                first = false;
            } else {
                parametersStringBuilder.append(", ");
            }
            parametersStringBuilder.append(this.getParamName(variableElement));
        }
        parametersStringBuilder.append(")");
        return parametersStringBuilder.toString();
    }

    private String getParamName(VariableElement param) {
        return this.getParamName(this.getAnnotation(param, "org.apache.qpid.server.model.Param"));
    }

    private String getParamName(AnnotationMirror paramAnnotation) {
        String paramName = null;
        for (ExecutableElement executableElement : paramAnnotation.getElementValues().keySet()) {
            if (!executableElement.getSimpleName().toString().equals("name")) continue;
            AnnotationValue value = paramAnnotation.getElementValues().get(executableElement);
            paramName = value.getValue().toString();
            break;
        }
        return paramName;
    }

    private AnnotationMirror getAnnotation(Element param, String name) {
        for (AnnotationMirror annotationMirror : param.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals(name)) continue;
            return annotationMirror;
        }
        return null;
    }

    private String createParamNameFromType(VariableElement param) {
        TypeMirror erasureType = this.processingEnv.getTypeUtils().erasure(param.asType());
        String nameWithPackage = erasureType.toString().toLowerCase();
        return nameWithPackage.substring(nameWithPackage.lastIndexOf(46) + 1);
    }

    /*
     * WARNING - void declaration
     */
    private String generateObjectFactory(Filer filer, ExecutableElement constructorElement) {
        TypeElement classElement = (TypeElement)constructorElement.getEnclosingElement();
        String objectQualifiedClassName = classElement.getQualifiedName().toString();
        String factoryName = objectQualifiedClassName + "Factory";
        String factorySimpleName = classElement.getSimpleName().toString() + "Factory";
        String objectSimpleName = classElement.getSimpleName().toString();
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Generating factory file for " + objectQualifiedClassName);
        ManagedObjectFactoryConstructor annotation = constructorElement.getAnnotation(ManagedObjectFactoryConstructor.class);
        PackageElement packageElement = (PackageElement)classElement.getEnclosingElement();
        try {
            void var14_18;
            JavaFileObject factoryFile = filer.createSourceFile(factoryName, new Element[0]);
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(factoryFile.openOutputStream(), "UTF-8"));
            pw.println("/*");
            String[] stringArray = License.LICENSE;
            int n = stringArray.length;
            boolean bl = false;
            while (var14_18 < n) {
                String headerLine = stringArray[var14_18];
                pw.println(" *" + headerLine);
                ++var14_18;
            }
            pw.println(" */");
            pw.println();
            pw.print("package ");
            pw.print(packageElement.getQualifiedName());
            pw.println(";");
            pw.println();
            pw.println("import java.util.Map;");
            pw.println();
            pw.println("import org.apache.qpid.server.model.AbstractConfiguredObjectTypeFactory;");
            pw.println("import org.apache.qpid.server.model.ConfiguredObject;");
            pw.println("import org.apache.qpid.server.plugin.PluggableService;");
            if (annotation.conditionallyAvailable()) {
                pw.println("import org.apache.qpid.server.plugin.ConditionallyAvailable;");
            }
            pw.println();
            pw.println("@PluggableService");
            pw.println("public final class " + factorySimpleName + " extends AbstractConfiguredObjectTypeFactory<" + objectSimpleName + ">");
            if (annotation.conditionallyAvailable()) {
                pw.println("    implements ConditionallyAvailable");
            }
            pw.println("{");
            pw.println("    public " + factorySimpleName + "()");
            pw.println("    {");
            pw.println("        super(" + objectSimpleName + ".class);");
            pw.println("    }");
            pw.println();
            pw.println("    @Override");
            pw.println("    protected " + objectSimpleName + " createInstance(final Map<String, Object> attributes, final ConfiguredObject<?> parent)");
            pw.println("    {");
            pw.print("        return new " + objectSimpleName + "WithAccessChecking(attributes");
            boolean first = true;
            for (VariableElement variableElement : constructorElement.getParameters()) {
                if (first) {
                    first = false;
                    continue;
                }
                TypeMirror erasureType = this.processingEnv.getTypeUtils().erasure(variableElement.asType());
                pw.print(String.format(", (%s)parent", erasureType.toString()));
            }
            pw.println(");");
            pw.println("    }");
            if (annotation.conditionallyAvailable()) {
                String condition = annotation.condition();
                pw.println();
                pw.println("    @Override");
                pw.println("    public boolean isAvailable()");
                pw.println("    {");
                if ("".equals(condition)) {
                    pw.println("        return " + objectSimpleName + ".isAvailable();");
                } else if (condition.matches("([\\w][\\w\\d_]+\\.)+[\\w][\\w\\d_\\$]*#[\\w\\d_]+\\s*\\(\\s*\\)")) {
                    pw.println("        return " + condition.replace('#', '.') + ";");
                } else {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("Invalid condition expression for '%s' : %s", objectQualifiedClassName, condition));
                }
                pw.println("    }");
            }
            pw.println("}");
            pw.close();
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to write factory file: " + factoryName + " - " + e.getLocalizedMessage());
        }
        return factoryName;
    }
}

