/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.InvalidMarkException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.codec.WritableBuffer;

public class CompositeReadableBuffer
implements ReadableBuffer {
    private static final List<byte[]> EMPTY_LIST = Collections.unmodifiableList(new ArrayList());
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.wrap(new byte[0]);
    private static final CompositeReadableBuffer EMPTY_SLICE = new CompositeReadableBuffer(false);
    private static int UNSET_MARK = -1;
    private static final int SHORT_BYTES = 2;
    private static final int INT_BYTES = 4;
    private static final int LONG_BYTES = 8;
    private ArrayList<byte[]> contents;
    private int currentArrayIndex = -1;
    private byte[] currentArray;
    private int currentOffset;
    private int position;
    private int limit;
    private int capacity;
    private int mark = -1;
    private boolean compactable = true;

    public CompositeReadableBuffer() {
    }

    private CompositeReadableBuffer(byte[] array, int offset) {
        this.currentArray = array;
        this.currentOffset = offset;
        if (array != null) {
            this.capacity = array.length;
        }
        this.limit = this.capacity;
    }

    private CompositeReadableBuffer(boolean compactable) {
        this.compactable = compactable;
    }

    public List<byte[]> getArrays() {
        return this.contents == null ? EMPTY_LIST : Collections.unmodifiableList(this.contents);
    }

    public int getCurrentIndex() {
        return this.currentArrayIndex;
    }

    public int getCurrentArrayPosition() {
        return this.currentOffset;
    }

    @Override
    public boolean hasArray() {
        return this.currentArray != null && (this.contents == null || this.contents.size() == 1);
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public byte[] array() {
        if (this.hasArray()) {
            return this.currentArray;
        }
        throw new UnsupportedOperationException("Buffer not backed by a single array");
    }

    @Override
    public int arrayOffset() {
        if (this.hasArray()) {
            return this.currentOffset - this.position;
        }
        throw new UnsupportedOperationException("Buffer not backed by a single array");
    }

    @Override
    public byte get() {
        if (this.position == this.limit) {
            throw new BufferUnderflowException();
        }
        byte result = this.currentArray[this.currentOffset++];
        ++this.position;
        this.maybeMoveToNextArray();
        return result;
    }

    @Override
    public byte get(int index) {
        if (index < 0 || index >= this.limit) {
            throw new IndexOutOfBoundsException("The given index is not valid: " + index);
        }
        byte result = 0;
        result = index == this.position ? this.currentArray[this.currentOffset] : (index < this.position ? this.getBackwards(index) : this.getForward(index));
        return result;
    }

    private byte getForward(int index) {
        byte result = 0;
        int currentArrayIndex = this.currentArrayIndex;
        int currentOffset = this.currentOffset;
        byte[] currentArray = this.currentArray;
        for (int amount = index - this.position; amount >= 0; amount -= currentArray.length - currentOffset) {
            if (amount < currentArray.length - currentOffset) {
                result = currentArray[currentOffset + amount];
                break;
            }
            currentArray = this.contents.get(++currentArrayIndex);
            currentOffset = 0;
        }
        return result;
    }

    private byte getBackwards(int index) {
        byte result = 0;
        int currentArrayIndex = this.currentArrayIndex;
        int currentOffset = this.currentOffset;
        byte[] currentArray = this.currentArray;
        for (int amount = this.position - index; amount >= 0; amount -= currentOffset) {
            if (currentOffset - amount >= 0) {
                result = currentArray[currentOffset - amount];
                break;
            }
            currentArray = this.contents.get(--currentArrayIndex);
            currentOffset = currentArray.length;
        }
        return result;
    }

    @Override
    public int getInt() {
        if (this.remaining() < 4) {
            throw new BufferUnderflowException();
        }
        int result = 0;
        if (this.currentArray.length - this.currentOffset >= 4) {
            result = (this.currentArray[this.currentOffset++] & 0xFF) << 24 | (this.currentArray[this.currentOffset++] & 0xFF) << 16 | (this.currentArray[this.currentOffset++] & 0xFF) << 8 | (this.currentArray[this.currentOffset++] & 0xFF) << 0;
        } else {
            for (int i = 3; i >= 0; --i) {
                result |= (this.currentArray[this.currentOffset++] & 0xFF) << i * 8;
                this.maybeMoveToNextArray();
            }
        }
        this.position += 4;
        return result;
    }

    @Override
    public long getLong() {
        if (this.remaining() < 8) {
            throw new BufferUnderflowException();
        }
        long result = 0L;
        if (this.currentArray.length - this.currentOffset >= 8) {
            result = (long)(this.currentArray[this.currentOffset++] & 0xFF) << 56 | (long)(this.currentArray[this.currentOffset++] & 0xFF) << 48 | (long)(this.currentArray[this.currentOffset++] & 0xFF) << 40 | (long)(this.currentArray[this.currentOffset++] & 0xFF) << 32 | (long)(this.currentArray[this.currentOffset++] & 0xFF) << 24 | (long)(this.currentArray[this.currentOffset++] & 0xFF) << 16 | (long)(this.currentArray[this.currentOffset++] & 0xFF) << 8 | (long)(this.currentArray[this.currentOffset++] & 0xFF) << 0;
        } else {
            for (int i = 7; i >= 0; --i) {
                result |= (long)(this.currentArray[this.currentOffset++] & 0xFF) << i * 8;
                this.maybeMoveToNextArray();
            }
        }
        this.position += 8;
        return result;
    }

    @Override
    public short getShort() {
        if (this.remaining() < 2) {
            throw new BufferUnderflowException();
        }
        short result = 0;
        for (int i = 1; i >= 0; --i) {
            result = (short)(result | (this.currentArray[this.currentOffset++] & 0xFF) << i * 8);
            this.maybeMoveToNextArray();
        }
        this.position += 2;
        return result;
    }

    @Override
    public float getFloat() {
        return Float.intBitsToFloat(this.getInt());
    }

    @Override
    public double getDouble() {
        return Double.longBitsToDouble(this.getLong());
    }

    @Override
    public CompositeReadableBuffer get(byte[] data) {
        return this.get(data, 0, data.length);
    }

    @Override
    public CompositeReadableBuffer get(byte[] data, int offset, int length) {
        CompositeReadableBuffer.validateReadTarget(data.length, offset, length);
        if (length > this.remaining()) {
            throw new BufferUnderflowException();
        }
        int copied = 0;
        while (length > 0) {
            int chunk = Math.min(this.currentArray.length - this.currentOffset, length);
            System.arraycopy(this.currentArray, this.currentOffset, data, offset + copied, chunk);
            this.currentOffset += chunk;
            length -= chunk;
            copied += chunk;
            this.maybeMoveToNextArray();
        }
        this.position += copied;
        return this;
    }

    @Override
    public CompositeReadableBuffer get(WritableBuffer target) {
        int chunk;
        int length = Math.min(target.remaining(), this.remaining());
        while ((chunk = Math.min(this.currentArray.length - this.currentOffset, length)) != 0) {
            target.put(this.currentArray, this.currentOffset, chunk);
            this.currentOffset += chunk;
            this.position += chunk;
            this.maybeMoveToNextArray();
            if ((length -= chunk) > 0) continue;
        }
        return this;
    }

    @Override
    public CompositeReadableBuffer position(int position) {
        if (position < 0 || position > this.limit) {
            throw new IllegalArgumentException("position must be non-negative and no greater than the limit");
        }
        int moveBy = position - this.position;
        if (moveBy >= 0) {
            this.moveForward(moveBy);
        } else {
            this.moveBackwards(Math.abs(moveBy));
        }
        this.position = position;
        if (this.mark > position) {
            this.mark = UNSET_MARK;
        }
        return this;
    }

    private void moveForward(int moveBy) {
        while (moveBy > 0) {
            if (moveBy < this.currentArray.length - this.currentOffset) {
                this.currentOffset += moveBy;
                break;
            }
            moveBy -= this.currentArray.length - this.currentOffset;
            if (this.currentArrayIndex != -1 && this.currentArrayIndex < this.contents.size() - 1) {
                this.currentArray = this.contents.get(++this.currentArrayIndex);
                this.currentOffset = 0;
                continue;
            }
            this.currentOffset = this.currentArray.length;
        }
    }

    private void moveBackwards(int moveBy) {
        while (moveBy > 0) {
            if (this.currentOffset - moveBy >= 0) {
                this.currentOffset -= moveBy;
                break;
            }
            moveBy -= this.currentOffset;
            this.currentArray = this.contents.get(--this.currentArrayIndex);
            this.currentOffset = this.currentArray.length;
        }
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public CompositeReadableBuffer slice() {
        CompositeReadableBuffer result;
        int newCapacity = this.limit() - this.position();
        if (newCapacity == 0) {
            result = EMPTY_SLICE;
        } else {
            result = new CompositeReadableBuffer(this.currentArray, this.currentOffset);
            result.contents = this.contents;
            result.currentArrayIndex = this.currentArrayIndex;
            result.capacity = newCapacity;
            result.limit = newCapacity;
            result.position = 0;
            result.compactable = false;
        }
        return result;
    }

    @Override
    public CompositeReadableBuffer flip() {
        this.limit = this.position;
        this.position(0);
        this.mark = UNSET_MARK;
        return this;
    }

    @Override
    public CompositeReadableBuffer limit(int limit) {
        if (limit < 0 || limit > this.capacity) {
            throw new IllegalArgumentException("limit must be non-negative and no greater than the capacity");
        }
        if (this.mark > limit) {
            this.mark = UNSET_MARK;
        }
        if (this.position > limit) {
            this.position(limit);
        }
        this.limit = limit;
        return this;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    @Override
    public CompositeReadableBuffer mark() {
        this.mark = this.position;
        return this;
    }

    @Override
    public CompositeReadableBuffer reset() {
        if (this.mark < 0) {
            throw new InvalidMarkException();
        }
        this.position(this.mark);
        return this;
    }

    @Override
    public CompositeReadableBuffer rewind() {
        return this.position(0);
    }

    @Override
    public CompositeReadableBuffer clear() {
        this.mark = UNSET_MARK;
        this.limit = this.capacity;
        return this.position(0);
    }

    @Override
    public int remaining() {
        return this.limit - this.position;
    }

    @Override
    public boolean hasRemaining() {
        return this.remaining() > 0;
    }

    @Override
    public CompositeReadableBuffer duplicate() {
        CompositeReadableBuffer duplicated = new CompositeReadableBuffer(this.currentArray, this.currentOffset);
        if (this.contents != null) {
            duplicated.contents = new ArrayList<byte[]>(this.contents);
        }
        duplicated.capacity = this.capacity;
        duplicated.currentArrayIndex = this.currentArrayIndex;
        duplicated.limit = this.limit;
        duplicated.position = this.position;
        duplicated.mark = this.mark;
        duplicated.compactable = this.compactable;
        return duplicated;
    }

    @Override
    public ByteBuffer byteBuffer() {
        int viewSpan = this.limit() - this.position();
        ByteBuffer result = viewSpan == 0 ? EMPTY_BUFFER : (viewSpan <= this.currentArray.length - this.currentOffset ? ByteBuffer.wrap(this.currentArray, this.currentOffset, viewSpan) : this.buildByteBuffer(viewSpan));
        return result.asReadOnlyBuffer();
    }

    private ByteBuffer buildByteBuffer(int span) {
        int length;
        byte[] compactedView = new byte[span];
        int arrayIndex = this.currentArrayIndex;
        System.arraycopy(this.currentArray, this.currentOffset, compactedView, 0, this.currentArray.length - this.currentOffset);
        for (int copied = this.currentArray.length - this.currentOffset; copied < span; copied += length) {
            byte[] next = this.contents.get(++arrayIndex);
            length = Math.min(span - copied, next.length);
            System.arraycopy(next, 0, compactedView, copied, length);
        }
        return ByteBuffer.wrap(compactedView);
    }

    @Override
    public String readUTF8() throws CharacterCodingException {
        return this.readString(StandardCharsets.UTF_8.newDecoder());
    }

    @Override
    public String readString(CharsetDecoder decoder) throws CharacterCodingException {
        if (!this.hasRemaining()) {
            return "";
        }
        CharBuffer decoded = null;
        decoded = this.hasArray() ? decoder.decode(ByteBuffer.wrap(this.currentArray, this.currentOffset, this.remaining())) : this.readStringFromComponents(decoder);
        return decoded.toString();
    }

    private CharBuffer readStringFromComponents(CharsetDecoder decoder) throws CharacterCodingException {
        int size = (int)((float)this.remaining() * decoder.averageCharsPerByte());
        CharBuffer decoded = CharBuffer.allocate(size);
        int arrayIndex = this.currentArrayIndex;
        int viewSpan = this.limit() - this.position();
        int processed = Math.min(this.currentArray.length - this.currentOffset, viewSpan);
        ByteBuffer wrapper = ByteBuffer.wrap(this.currentArray, this.currentOffset, processed);
        CoderResult step = CoderResult.OVERFLOW;
        do {
            boolean endOfInput;
            if ((step = decoder.decode(wrapper, decoded, endOfInput = processed == viewSpan)).isUnderflow() && endOfInput) {
                step = decoder.flush(decoded);
                break;
            }
            if (step.isOverflow()) {
                size = 2 * size + 1;
                CharBuffer upsized = CharBuffer.allocate(size);
                decoded.flip();
                upsized.put(decoded);
                decoded = upsized;
                continue;
            }
            byte[] next = this.contents.get(++arrayIndex);
            int wrapSize = Math.min(next.length, viewSpan - processed);
            wrapper = ByteBuffer.wrap(next, 0, wrapSize);
            processed += wrapSize;
        } while (!step.isError());
        if (step.isError()) {
            step.throwException();
        }
        return (CharBuffer)decoded.flip();
    }

    @Override
    public CompositeReadableBuffer reclaimRead() {
        int totalRemovals;
        if (!this.compactable || this.currentArray == null && this.contents == null) {
            return this;
        }
        int totalCompaction = 0;
        for (totalRemovals = 0; totalRemovals < this.currentArrayIndex; ++totalRemovals) {
            byte[] element = this.contents.remove(0);
            totalCompaction += element.length;
        }
        this.currentArrayIndex -= totalRemovals;
        if (this.currentArray.length == this.currentOffset) {
            totalCompaction += this.currentArray.length;
            if (this.currentArrayIndex == 0) {
                this.contents.clear();
                this.contents = null;
            }
            this.currentArray = null;
            this.currentArrayIndex = -1;
            this.currentOffset = 0;
        }
        this.position -= totalCompaction;
        this.limit = this.capacity -= totalCompaction;
        if (this.mark != UNSET_MARK) {
            this.mark -= totalCompaction;
        }
        return this;
    }

    public CompositeReadableBuffer append(byte[] array) {
        this.validateAppendable();
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException("Array must not be empty or null");
        }
        if (this.currentArray == null) {
            this.currentArray = array;
            this.currentOffset = 0;
        } else if (this.contents == null) {
            this.contents = new ArrayList();
            this.contents.add(this.currentArray);
            this.contents.add(array);
            this.currentArrayIndex = 0;
            this.maybeMoveToNextArray();
        } else {
            this.contents.add(array);
            this.maybeMoveToNextArray();
        }
        this.capacity += array.length;
        this.limit = this.capacity;
        return this;
    }

    private void validateAppendable() {
        if (!this.compactable) {
            throw new IllegalStateException();
        }
    }

    private void validateBuffer(ReadableBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("A non-null buffer must be provided");
        }
        if (!buffer.hasRemaining()) {
            throw new IllegalArgumentException("Buffer has no remaining content to append");
        }
    }

    public CompositeReadableBuffer append(CompositeReadableBuffer buffer) {
        this.validateAppendable();
        this.validateBuffer(buffer);
        do {
            byte[] chunk;
            int bufferRemaining = buffer.remaining();
            int arrayRemaining = buffer.currentArray.length - buffer.currentOffset;
            if (buffer.currentOffset > 0 || bufferRemaining < arrayRemaining) {
                int length = Math.min(arrayRemaining, bufferRemaining);
                chunk = new byte[length];
                System.arraycopy(buffer.currentArray, buffer.currentOffset, chunk, 0, length);
            } else {
                chunk = buffer.currentArray;
            }
            this.append(chunk);
            buffer.position(buffer.position() + chunk.length);
        } while (buffer.hasRemaining());
        return this;
    }

    public CompositeReadableBuffer append(ReadableBuffer buffer) {
        if (buffer instanceof CompositeReadableBuffer) {
            this.append((CompositeReadableBuffer)buffer);
        } else {
            this.validateAppendable();
            this.validateBuffer(buffer);
            if (buffer.hasArray()) {
                byte[] chunk = buffer.array();
                int bufferRemaining = buffer.remaining();
                if (buffer.arrayOffset() > 0 || bufferRemaining < chunk.length) {
                    chunk = new byte[bufferRemaining];
                    System.arraycopy(buffer.array(), buffer.arrayOffset(), chunk, 0, bufferRemaining);
                }
                this.append(chunk);
                buffer.position(buffer.position() + chunk.length);
            } else {
                byte[] chunk = new byte[buffer.remaining()];
                buffer.get(chunk);
                this.append(chunk);
            }
        }
        return this;
    }

    public int hashCode() {
        int hash = 1;
        if (this.currentArrayIndex < 0) {
            int span = this.limit() - this.position();
            while (span > 0) {
                hash = 31 * hash + this.currentArray[this.currentOffset + --span];
            }
        } else {
            int currentPos = this.position();
            for (int i = this.limit() - 1; i >= currentPos; --i) {
                hash = 31 * hash + this.get(i);
            }
        }
        return hash;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ReadableBuffer)) {
            return false;
        }
        ReadableBuffer buffer = (ReadableBuffer)other;
        if (this.remaining() != buffer.remaining()) {
            return false;
        }
        int currentPos = this.position();
        int i = buffer.position();
        while (this.hasRemaining()) {
            if (!CompositeReadableBuffer.equals(this.get(), buffer.get(i))) {
                return false;
            }
            ++i;
        }
        this.position(currentPos);
        return true;
    }

    public String toString() {
        StringBuffer builder = new StringBuffer();
        builder.append("CompositeReadableBuffer");
        builder.append("{ pos=");
        builder.append(this.position());
        builder.append(" limit=");
        builder.append(this.limit());
        builder.append(" capacity=");
        builder.append(this.capacity());
        builder.append(" }");
        return builder.toString();
    }

    private static boolean equals(byte x, byte y) {
        return x == y;
    }

    private void maybeMoveToNextArray() {
        if (this.currentArray.length == this.currentOffset && this.currentArrayIndex >= 0 && this.currentArrayIndex < this.contents.size() - 1) {
            this.currentArray = this.contents.get(++this.currentArrayIndex);
            this.currentOffset = 0;
        }
    }

    private static void validateReadTarget(int destSize, int offset, int length) {
        if ((offset | length) < 0) {
            throw new IndexOutOfBoundsException("offset and legnth must be non-negative");
        }
        if ((long)offset + (long)length > (long)destSize) {
            throw new IndexOutOfBoundsException("target is to small for specified read size");
        }
    }
}

