/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.security.oauth2;

import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.apache.qpid.client.security.oauth2.OAuth2SaslClient;

public class OAuth2SaslClientFactory
implements SaslClientFactory {
    @Override
    public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler callbackHandler) throws SaslException {
        for (String mech : mechanisms) {
            if (!"XOAUTH2".equals(mech)) continue;
            if (callbackHandler == null) {
                throw new SaslException("CallbackHandler must not be null");
            }
            return new OAuth2SaslClient(callbackHandler);
        }
        return null;
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        return new String[]{"XOAUTH2"};
    }
}

