/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport.network.security.ssl;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.apache.qpid.transport.ByteBufferSender;
import org.apache.qpid.transport.SenderException;
import org.apache.qpid.transport.network.security.SSLStatus;
import org.apache.qpid.transport.network.security.ssl.SSLUtil;
import org.apache.qpid.util.ByteBufferUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLSender
implements ByteBufferSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(SSLSender.class);
    private final ByteBufferSender delegate;
    private final SSLEngine engine;
    private final int sslBufSize;
    private final ByteBuffer netData;
    private final long timeout;
    private final SSLStatus _sslStatus;
    private String _hostname;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final ConcurrentLinkedQueue<ByteBuffer> _pending = new ConcurrentLinkedQueue();

    public SSLSender(SSLEngine engine, ByteBufferSender delegate, SSLStatus sslStatus) {
        this.engine = engine;
        this.delegate = delegate;
        this.sslBufSize = engine.getSession().getPacketBufferSize();
        this.netData = ByteBuffer.allocate(this.sslBufSize);
        this.timeout = Long.getLong("qpid.ssl_timeout", 60000L);
        this._sslStatus = sslStatus;
    }

    public void setHostname(String hostname) {
        this._hostname = hostname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            if (this.engine.isOutboundDone()) {
                return;
            }
            LOGGER.debug("Closing SSL connection");
            this.engine.closeOutbound();
            try {
                this.tearDownSSLConnection();
            }
            catch (Exception e) {
                throw new SenderException("Error closing SSL connection", e);
            }
            Object object = this._sslStatus.getSslLock();
            synchronized (object) {
                while (!this.engine.isOutboundDone()) {
                    try {
                        this._sslStatus.getSslLock().wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.delegate.close();
        }
    }

    private void tearDownSSLConnection() throws Exception {
        SSLEngineResult result = ByteBufferUtils.encryptSSL(this.engine, Collections.singletonList(ByteBuffer.allocate(0)), this.netData);
        SSLEngineResult.Status status = result.getStatus();
        int read = result.bytesProduced();
        while (status != SSLEngineResult.Status.CLOSED) {
            if (status == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                this.netData.clear();
            }
            if (read > 0) {
                int limit = this.netData.limit();
                this.netData.limit(this.netData.position());
                this.netData.position(this.netData.position() - read);
                ByteBuffer data = this.netData.slice();
                this.netData.limit(limit);
                this.netData.position(this.netData.position() + read);
                this.delegate.send(data);
                this.flush();
            }
            result = ByteBufferUtils.encryptSSL(this.engine, Collections.singletonList(ByteBuffer.allocate(0)), this.netData);
            status = result.getStatus();
            read = result.bytesProduced();
        }
    }

    @Override
    public void flush() {
        this.doSend();
        this.delegate.flush();
    }

    @Override
    public void send(ByteBuffer appData) {
        this._pending.add(appData.duplicate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSend() {
        if (this.closed.get() && !this._sslStatus.getSslErrorFlag()) {
            throw new SenderException("SSL Sender is closed");
        }
        block22: while (!this._pending.isEmpty() && !this._sslStatus.getSslErrorFlag()) {
            SSLEngineResult.HandshakeStatus handshakeStatus;
            SSLEngineResult.Status status;
            int read = 0;
            try {
                ByteBuffer buf;
                SSLEngineResult result = ByteBufferUtils.encryptSSL(this.engine, this._pending, this.netData);
                while (!this._pending.isEmpty() && !(buf = this._pending.peek()).hasRemaining()) {
                    this._pending.poll();
                }
                read = result.bytesProduced();
                status = result.getStatus();
                handshakeStatus = result.getHandshakeStatus();
            }
            catch (SSLException e) {
                throw new SenderException("SSL, Error occurred while encrypting data", e);
            }
            if (read > 0) {
                int limit = this.netData.limit();
                this.netData.limit(this.netData.position());
                this.netData.position(this.netData.position() - read);
                ByteBuffer data = this.netData.slice();
                this.netData.limit(limit);
                this.netData.position(this.netData.position() + read);
                this.delegate.send(data);
            }
            switch (status) {
                case CLOSED: {
                    throw new SenderException("SSLEngine is closed");
                }
                case BUFFER_OVERFLOW: {
                    this.netData.clear();
                    continue block22;
                }
                case OK: {
                    break;
                }
                default: {
                    throw new IllegalStateException("SSLReceiver: Invalid State " + (Object)((Object)status));
                }
            }
            switch (handshakeStatus) {
                case NEED_WRAP: {
                    if (!this.netData.hasRemaining()) continue block22;
                    continue block22;
                }
                case NEED_TASK: {
                    this.doTasks();
                    break;
                }
                case NEED_UNWRAP: {
                    this.delegate.flush();
                    Object object = this._sslStatus.getSslLock();
                    synchronized (object) {
                        if (this._sslStatus.getSslErrorFlag()) {
                            break;
                        }
                        switch (this.engine.getHandshakeStatus()) {
                            case NEED_UNWRAP: {
                                long start = System.currentTimeMillis();
                                try {
                                    this._sslStatus.getSslLock().wait(this.timeout);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                if (this._sslStatus.getSslErrorFlag() || System.currentTimeMillis() - start < this.timeout) break;
                                throw new SenderException("SSL Engine timed out after waiting " + this.timeout + "ms. for a response." + "To get more info,run with -Djavax.net.debug=ssl");
                            }
                        }
                        break;
                    }
                }
                case FINISHED: {
                    if (this._hostname == null) continue block22;
                    SSLUtil.verifyHostname(this.engine, this._hostname);
                    break;
                }
                case NOT_HANDSHAKING: {
                    break;
                }
                default: {
                    throw new IllegalStateException("SSLSender: Invalid State " + (Object)((Object)status));
                }
            }
        }
    }

    private void doTasks() {
        Runnable runnable;
        while ((runnable = this.engine.getDelegatedTask()) != null) {
            runnable.run();
        }
    }
}

