/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.util.ByteBufferUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncodingUtils {
    private static final Logger _logger = LoggerFactory.getLogger(EncodingUtils.class);

    private EncodingUtils() {
    }

    public static int encodedShortStringLength(String s) {
        if (s == null) {
            return 1;
        }
        int size = 1 + EncodingUtils.getUTF8Length(s);
        if (size > 256) {
            throw new IllegalArgumentException("String '" + s + "' is too long - over 255 octets to encode");
        }
        return (short)size;
    }

    public static int encodedShortStringLength(long l) {
        if (l == 0L) {
            return 2;
        }
        if (l >= 1000000000000L && l < 10000000000000L) {
            return 14;
        }
        return Long.toString(l).length() + 1;
    }

    public static int encodedShortStringLength(AMQShortString s) {
        if (s == null) {
            return 1;
        }
        return 1 + s.length();
    }

    public static int encodedLongStringLength(String s) {
        if (s == null) {
            return 4;
        }
        return 4 + EncodingUtils.getUTF8Length(s);
    }

    public static int encodedLongstrLength(byte[] bytes) {
        if (bytes == null) {
            return 4;
        }
        return 4 + bytes.length;
    }

    public static int encodedFieldTableLength(FieldTable table) {
        if (table == null) {
            return 4;
        }
        return (int)table.getEncodedSize() + 4;
    }

    public static void writeLongAsShortString(ByteBuffer buffer, long l) {
        String s = Long.toString(l);
        byte[] encodedString = new byte[1 + s.length()];
        char[] cha = s.toCharArray();
        encodedString[0] = (byte)s.length();
        for (int i = 0; i < cha.length; ++i) {
            encodedString[i + 1] = (byte)cha[i];
        }
        buffer.put(encodedString);
    }

    public static void writeShortStringBytes(ByteBuffer buffer, AMQShortString s) {
        if (s != null) {
            s.writeToBuffer(buffer);
        } else {
            buffer.put((byte)0);
        }
    }

    public static void writeLongStringBytes(ByteBuffer buffer, String s) {
        if (s != null) {
            int len = EncodingUtils.getUTF8Length(s);
            ByteBufferUtils.putUnsignedInt(buffer, len);
            buffer.put(EncodingUtils.asUTF8Bytes(s));
        } else {
            ByteBufferUtils.putUnsignedInt(buffer, 0L);
        }
    }

    public static int unsignedIntegerLength() {
        return 4;
    }

    public static void writeFieldTableBytes(ByteBuffer buffer, FieldTable table) {
        if (table != null) {
            table.writeToBuffer(buffer);
        } else {
            ByteBufferUtils.putUnsignedInt(buffer, 0L);
        }
    }

    public static void writeLongstr(ByteBuffer buffer, byte[] data) {
        if (data != null) {
            ByteBufferUtils.putUnsignedInt(buffer, data.length);
            buffer.put(data);
        } else {
            ByteBufferUtils.putUnsignedInt(buffer, 0L);
        }
    }

    public static FieldTable readFieldTable(ByteBuffer input) throws AMQFrameDecodingException {
        long length = ByteBufferUtils.getUnsignedInt(input);
        if (length == 0L) {
            return null;
        }
        return new FieldTable(input, (int)length);
    }

    public static String readLongString(ByteBuffer buffer) {
        long length = (long)buffer.getInt() & 0xFFFFFFFFL;
        if (length == 0L) {
            return "";
        }
        byte[] stringBytes = new byte[(int)length];
        buffer.get(stringBytes, 0, (int)length);
        return new String(stringBytes, StandardCharsets.UTF_8);
    }

    public static byte[] readLongstr(ByteBuffer buffer) {
        long length = (long)buffer.getInt() & 0xFFFFFFFFL;
        if (length == 0L) {
            return null;
        }
        byte[] result = new byte[(int)length];
        buffer.get(result);
        return result;
    }

    public static void writeBoolean(ByteBuffer buffer, boolean aBoolean) {
        buffer.put(aBoolean ? (byte)1 : 0);
    }

    public static int encodedBooleanLength() {
        return 1;
    }

    public static int encodedByteLength() {
        return 1;
    }

    public static int encodedShortLength() {
        return 2;
    }

    public static int encodedIntegerLength() {
        return 4;
    }

    public static int encodedLongLength() {
        return 8;
    }

    public static int encodedFloatLength() {
        return 4;
    }

    public static int encodedDoubleLength() {
        return 8;
    }

    public static byte[] readBytes(ByteBuffer buffer) {
        long length = ByteBufferUtils.getUnsignedInt(buffer);
        if (length == 0L) {
            return null;
        }
        byte[] dataBytes = new byte[(int)length];
        buffer.get(dataBytes);
        return dataBytes;
    }

    public static void writeBytes(ByteBuffer buffer, byte[] data) {
        if (data != null) {
            ByteBufferUtils.putUnsignedInt(buffer, data.length);
            buffer.put(data);
        } else {
            ByteBufferUtils.putUnsignedInt(buffer, 0L);
        }
    }

    public static int encodedCharLength() {
        return EncodingUtils.encodedByteLength();
    }

    public static long readLongAsShortString(ByteBuffer buffer) throws AMQFrameDecodingException {
        boolean isNegative;
        short length = ByteBufferUtils.getUnsignedByte(buffer);
        short pos = 0;
        if (length == 0) {
            return 0L;
        }
        byte digit = buffer.get();
        long result = 0L;
        if (digit == 45) {
            isNegative = true;
            pos = (short)(pos + 1);
            digit = buffer.get();
        } else {
            isNegative = false;
        }
        result = EncodingUtils.toNumber(digit);
        pos = (short)(pos + 1);
        while (pos < length) {
            pos = (short)(pos + 1);
            digit = buffer.get();
            result = (result << 3) + (result << 1);
            result += (long)EncodingUtils.toNumber(digit);
        }
        return isNegative ? -result : result;
    }

    private static int toNumber(byte digit) throws AMQFrameDecodingException {
        if (digit >= 48 && digit <= 57) {
            return digit - 48;
        }
        throw new AMQFrameDecodingException(String.format("Unexpected character '%c' in string representing long value", digit));
    }

    public static byte[] asUTF8Bytes(CharSequence string) {
        byte[] bytes = new byte[EncodingUtils.getUTF8Length(string)];
        int j = 0;
        if (string != null) {
            int length = string.length();
            for (int i = 0; i < length; ++i) {
                char low;
                int c = string.charAt(i);
                if ((c & 0xFF80) == 0) {
                    bytes[j++] = (byte)c;
                    continue;
                }
                if ((c & 0xF800) == 0) {
                    bytes[j++] = (byte)(0xC0 | c >> 6 & 0x1F);
                    bytes[j++] = (byte)(0x80 | c & 0x3F);
                    continue;
                }
                if ((c & 0xD800) != 55296 || c > 56319) {
                    bytes[j++] = (byte)(0xE0 | c >> 12 & 0xF);
                    bytes[j++] = (byte)(0x80 | c >> 6 & 0x3F);
                    bytes[j++] = (byte)(0x80 | c & 0x3F);
                    continue;
                }
                if (++i == length || ((low = string.charAt(i)) & 0xDC00) != 56320) {
                    throw new IllegalArgumentException("String contains invalid Unicode code points");
                }
                c = 65536 + ((c & 0x3FF) << 10) + (low & 0x3FF);
                bytes[j++] = (byte)(0xF0 | c >> 18 & 7);
                bytes[j++] = (byte)(0x80 | c >> 12 & 0x3F);
                bytes[j++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytes[j++] = (byte)(0x80 | c & 0x3F);
            }
        }
        return bytes;
    }

    public static int getUTF8Length(CharSequence string) {
        int size = 0;
        if (string != null) {
            int inputLength = string.length();
            for (int i = 0; i < inputLength; ++i) {
                char c = string.charAt(i);
                if ((c & 0xFF80) == 0) {
                    ++size;
                    continue;
                }
                if ((c & 0xF800) == 0) {
                    size += 2;
                    continue;
                }
                if ((c & 0xD800) != 55296 || c > '\udbff') {
                    size += 3;
                    continue;
                }
                if (++i == size || (string.charAt(i) & 0xDC00) != 56320) {
                    throw new IllegalArgumentException("String contains invalid Unicode code points");
                }
                size += 4;
            }
        }
        return size;
    }
}

