/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.apache.qpid.AMQException;
import org.apache.qpid.AMQUndeliveredException;
import org.apache.qpid.QpidException;
import org.apache.qpid.client.AMQConnection;
import org.apache.qpid.client.AMQConnectionDelegate_8_0;
import org.apache.qpid.client.AMQDestination;
import org.apache.qpid.client.AMQNoConsumersException;
import org.apache.qpid.client.AMQNoRouteException;
import org.apache.qpid.client.AMQProtocolHandler;
import org.apache.qpid.client.AMQQueue;
import org.apache.qpid.client.AMQSession;
import org.apache.qpid.client.AMQTemporaryQueue;
import org.apache.qpid.client.AMQTopic;
import org.apache.qpid.client.BasicMessageConsumer_0_8;
import org.apache.qpid.client.BasicMessageProducer_0_8;
import org.apache.qpid.client.RejectBehaviour;
import org.apache.qpid.client.TemporaryDestination;
import org.apache.qpid.client.UnsupportedAddressSyntaxException;
import org.apache.qpid.client.failover.FailoverException;
import org.apache.qpid.client.failover.FailoverNoopSupport;
import org.apache.qpid.client.failover.FailoverProtectedOperation;
import org.apache.qpid.client.failover.FailoverRetrySupport;
import org.apache.qpid.client.message.AMQMessageDelegateFactory;
import org.apache.qpid.client.message.AbstractJMSMessage;
import org.apache.qpid.client.message.ReturnMessage;
import org.apache.qpid.client.message.UnprocessedMessage;
import org.apache.qpid.client.messaging.address.Link;
import org.apache.qpid.client.messaging.address.Node;
import org.apache.qpid.client.state.AMQState;
import org.apache.qpid.client.state.AMQStateManager;
import org.apache.qpid.client.state.listener.SpecificMethodFrameListener;
import org.apache.qpid.client.util.JMSExceptionHelper;
import org.apache.qpid.common.AMQPFilterTypes;
import org.apache.qpid.framing.AMQFrame;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.BasicAckBody;
import org.apache.qpid.framing.BasicConsumeBody;
import org.apache.qpid.framing.BasicConsumeOkBody;
import org.apache.qpid.framing.BasicQosBody;
import org.apache.qpid.framing.BasicQosOkBody;
import org.apache.qpid.framing.BasicRecoverBody;
import org.apache.qpid.framing.BasicRecoverSyncBody;
import org.apache.qpid.framing.BasicRecoverSyncOkBody;
import org.apache.qpid.framing.BasicRejectBody;
import org.apache.qpid.framing.ChannelCloseOkBody;
import org.apache.qpid.framing.ChannelFlowBody;
import org.apache.qpid.framing.ChannelFlowOkBody;
import org.apache.qpid.framing.ExchangeBoundOkBody;
import org.apache.qpid.framing.ExchangeDeclareBody;
import org.apache.qpid.framing.ExchangeDeclareOkBody;
import org.apache.qpid.framing.ExchangeDeleteBody;
import org.apache.qpid.framing.ExchangeDeleteOkBody;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.framing.ProtocolVersion;
import org.apache.qpid.framing.QueueBindBody;
import org.apache.qpid.framing.QueueBindOkBody;
import org.apache.qpid.framing.QueueDeclareBody;
import org.apache.qpid.framing.QueueDeclareOkBody;
import org.apache.qpid.framing.QueueDeleteBody;
import org.apache.qpid.framing.QueueDeleteOkBody;
import org.apache.qpid.framing.QueueUnbindBody;
import org.apache.qpid.framing.QueueUnbindOkBody;
import org.apache.qpid.framing.TxCommitOkBody;
import org.apache.qpid.framing.TxRollbackBody;
import org.apache.qpid.framing.TxRollbackOkBody;
import org.apache.qpid.protocol.AMQMethodEvent;
import org.apache.qpid.transport.TransportException;
import org.apache.qpid.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQSession_0_8
extends AMQSession<BasicMessageConsumer_0_8, BasicMessageProducer_0_8> {
    private static final Logger _logger = LoggerFactory.getLogger(AMQSession.class);
    private final boolean _useLegacyQueueDepthBehaviour = Boolean.parseBoolean(System.getProperty("qpid.use_legacy_getqueuedepth_behavior", "false"));
    private final long _flowControlWaitPeriod = Long.getLong("qpid.flow_control_wait_notify_period", 5000L);
    private final long _flowControlWaitFailure = Long.getLong("qpid.flow_control_wait_failure", 60000L);
    private AtomicInteger _unacknowledgedMessages = new AtomicInteger();
    private FlowControlIndicator _flowControl = new FlowControlIndicator();
    private final AtomicBoolean _creditChanged = new AtomicBoolean();
    private final TopicDestinationCache _topicDestinationCache = new TopicDestinationCache();
    private final QueueDestinationCache _queueDestinationCache = new QueueDestinationCache();

    protected AMQSession_0_8(AMQConnection con, int channelId, boolean transacted, int acknowledgeMode, int defaultPrefetchHighMark, int defaultPrefetchLowMark) {
        super(con, channelId, transacted, acknowledgeMode, defaultPrefetchHighMark, defaultPrefetchLowMark);
        this._unacknowledgedMessages.set(0);
    }

    ProtocolVersion getProtocolVersion() {
        return this.getProtocolHandler().getProtocolVersion();
    }

    @Override
    protected void acknowledgeImpl() throws JMSException {
        Long tag;
        boolean syncRequired = false;
        try {
            this.reduceCreditToOriginalSize();
        }
        catch (QpidException e) {
            throw JMSExceptionHelper.chainJMSException(new JMSException("Session.reduceCreditToOriginalSize failed"), e);
        }
        while ((tag = this.getUnacknowledgedMessageTags().poll()) != null) {
            this.acknowledgeMessage(tag, false);
            syncRequired = true;
        }
        this._unacknowledgedMessages.set(0);
        try {
            if (syncRequired && this.getAMQConnection().getSyncClientAck()) {
                this.sync();
            }
        }
        catch (QpidException a) {
            throw JMSExceptionHelper.chainJMSException(new JMSException("Failed to sync after acknowledge"), a);
        }
    }

    @Override
    public void acknowledgeMessage(long deliveryTag, boolean multiple) {
        BasicAckBody body = this.getMethodRegistry().createBasicAckBody(deliveryTag, multiple);
        AMQFrame ackFrame = body.generateFrame(this.getChannelId());
        if (_logger.isDebugEnabled()) {
            _logger.debug("Sending ack for delivery tag " + deliveryTag + " on channel " + this.getChannelId());
        }
        this.getProtocolHandler().writeFrame(ackFrame, !this.isTransacted());
        this.getUnacknowledgedMessageTags().remove(deliveryTag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void resubscribe() throws QpidException {
        try {
            this.setUsingDispatcherForCleanup(true);
            this.resetRollbackMarkers();
            this.syncDispatchQueue(true);
        }
        finally {
            this.setUsingDispatcherForCleanup(false);
        }
        this.getDeliveredMessageTags().clear();
        super.resubscribe();
    }

    @Override
    public void sendQueueBind(String queueName, String routingKey, Map<String, Object> arguments, String exchangeName, AMQDestination destination, boolean nowait) throws QpidException, FailoverException {
        if (destination == null || destination.getDestSyntax() == AMQDestination.DestSyntax.BURL) {
            this.getProtocolHandler().syncWrite(this.getProtocolHandler().getMethodRegistry().createQueueBindBody(this.getTicket(), queueName, exchangeName, routingKey, false, arguments).generateFrame(this.getChannelId()), QueueBindOkBody.class);
        } else {
            ArrayList<AMQDestination.Binding> bindings = new ArrayList<AMQDestination.Binding>();
            bindings.addAll(destination.getNode().getBindings());
            String defaultExchange = destination.getAddressType() == 2 ? destination.getAddressName() : "amq.topic";
            for (AMQDestination.Binding binding : bindings) {
                if (binding.getQueue() == null && queueName == null) continue;
                String queue = binding.getQueue() == null ? queueName : binding.getQueue();
                String exchange = binding.getExchange() == null ? defaultExchange : binding.getExchange();
                _logger.debug("Binding queue : " + queue + " exchange: " + exchange + " using binding key " + binding.getBindingKey() + " with args " + Strings.printMap(binding.getArgs()));
                this.doBind(destination, binding, queue, exchange);
            }
        }
    }

    @Override
    public void sendClose(long timeout) throws QpidException, FailoverException {
        if (!this.getProtocolHandler().getStateManager().getCurrentState().equals((Object)AMQState.CONNECTION_CLOSED) && !this.getProtocolHandler().getStateManager().getCurrentState().equals((Object)AMQState.CONNECTION_CLOSING)) {
            this.getProtocolHandler().closeSession(this);
            this.getProtocolHandler().syncWrite(this.getProtocolHandler().getMethodRegistry().createChannelCloseBody(200, new AMQShortString("JMS client closing channel"), 0, 0).generateFrame(this.getChannelId()), ChannelCloseOkBody.class, timeout);
        }
    }

    @Override
    public void commitImpl() throws QpidException, FailoverException, TransportException {
        Long tag;
        while ((tag = this.getDeliveredMessageTags().poll()) != null) {
            this.acknowledgeMessage(tag, false);
        }
        AMQProtocolHandler handler = this.getProtocolHandler();
        this.reduceCreditToOriginalSize();
        handler.syncWrite(this.getProtocolHandler().getMethodRegistry().createTxCommitBody().generateFrame(this.getChannelId()), TxCommitOkBody.class);
        this._unacknowledgedMessages.set(0);
    }

    @Override
    public void sendCreateQueue(String name, boolean autoDelete, boolean durable, boolean exclusive, Map<String, Object> arguments) throws QpidException, FailoverException {
        this.sendQueueDeclare(name, durable, exclusive, autoDelete, arguments, false);
    }

    @Override
    public void sendRecover() throws QpidException, FailoverException {
        this.enforceRejectBehaviourDuringRecover();
        this.getPrefetchedMessageTags().clear();
        this.getUnacknowledgedMessageTags().clear();
        if (this.isStrictAMQP()) {
            BasicRecoverBody body = this.getMethodRegistry().createBasicRecoverBody(false);
            this.getAMQConnection().getProtocolHandler().writeFrame(body.generateFrame(this.getChannelId()));
            _logger.warn("Session Recover cannot be guaranteed with STRICT_AMQP. Messages may arrive out of order.");
        } else if (this.getProtocolHandler().getProtocolVersion().equals(ProtocolVersion.v0_8)) {
            BasicRecoverBody body = this.getMethodRegistry().createBasicRecoverBody(false);
            this.getAMQConnection().getProtocolHandler().syncWrite(body.generateFrame(this.getChannelId()), BasicRecoverSyncOkBody.class);
        } else {
            BasicRecoverSyncBody body = this.getMethodRegistry().createBasicRecoverSyncBody(false);
            this.getAMQConnection().getProtocolHandler().syncWrite(body.generateFrame(this.getChannelId()), BasicRecoverSyncOkBody.class);
        }
        this._unacknowledgedMessages.set(0);
    }

    private void enforceRejectBehaviourDuringRecover() {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Prefetched message: _unacknowledgedMessageTags :" + this.getUnacknowledgedMessageTags());
        }
        boolean messageListenerFound = false;
        boolean serverRejectBehaviourFound = false;
        for (BasicMessageConsumer_0_8 consumer : this.getConsumers()) {
            if (consumer.isMessageListenerSet()) {
                messageListenerFound = true;
            }
            if (!RejectBehaviour.SERVER.equals((Object)consumer.getRejectBehaviour())) continue;
            serverRejectBehaviourFound = true;
        }
        if (serverRejectBehaviourFound) {
            switch (this.getAcknowledgeMode()) {
                case 1: 
                case 3: {
                    if (!messageListenerFound) break;
                }
                case 2: {
                    for (Long tag : this.getUnacknowledgedMessageTags()) {
                        this.rejectMessage(tag, false);
                    }
                    break;
                }
            }
        }
    }

    @Override
    public void releaseForRollback() {
        Long tag;
        boolean normalRejectBehaviour = true;
        for (BasicMessageConsumer_0_8 consumer : this.getConsumers()) {
            if (!RejectBehaviour.SERVER.equals((Object)consumer.getRejectBehaviour())) continue;
            normalRejectBehaviour = false;
            break;
        }
        while ((tag = this.getDeliveredMessageTags().poll()) != null) {
            this.rejectMessage(tag, normalRejectBehaviour);
        }
    }

    @Override
    public void rejectMessage(long deliveryTag, boolean requeue) {
        if (this.getAcknowledgeMode() == 2 || this.getAcknowledgeMode() == 0 || (this.getAcknowledgeMode() == 1 || this.getAcknowledgeMode() == 3) && this.hasMessageListeners()) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Rejecting delivery tag:" + deliveryTag + ":SessionHC:" + this.hashCode());
            }
            BasicRejectBody body = this.getMethodRegistry().createBasicRejectBody(deliveryTag, requeue);
            AMQFrame frame = body.generateFrame(this.getChannelId());
            this.getAMQConnection().getProtocolHandler().writeFrame(frame);
        }
    }

    @Override
    public boolean isQueueBound(AMQDestination destination) throws JMSException {
        return this.isQueueBound(destination.getExchangeName(), destination.getAMQQueueName(), destination.getAMQQueueName());
    }

    @Override
    public boolean isQueueBound(final String exchangeName, final String queueName, final String routingKey) throws JMSException {
        try {
            AMQMethodEvent response = new FailoverRetrySupport<AMQMethodEvent, QpidException>(new FailoverProtectedOperation<AMQMethodEvent, QpidException>(){

                @Override
                public AMQMethodEvent execute() throws QpidException, FailoverException {
                    return AMQSession_0_8.this.sendExchangeBound(exchangeName, routingKey, queueName);
                }
            }, this.getAMQConnection()).execute();
            ExchangeBoundOkBody responseBody = (ExchangeBoundOkBody)response.getMethod();
            return responseBody.getReplyCode() == 0;
        }
        catch (QpidException e) {
            throw JMSExceptionHelper.chainJMSException(new JMSException("Queue bound query failed: " + e.getMessage()), e);
        }
    }

    @Override
    protected boolean isBound(final String exchangeName, final String queueName, final String routingKey) throws QpidException {
        if (!this.getAMQConnection().getDelegate().supportsIsBound()) {
            return false;
        }
        AMQMethodEvent response = new FailoverNoopSupport<AMQMethodEvent, QpidException>(new FailoverProtectedOperation<AMQMethodEvent, QpidException>(){

            @Override
            public AMQMethodEvent execute() throws QpidException, FailoverException {
                return AMQSession_0_8.this.sendExchangeBound(exchangeName, routingKey, queueName);
            }
        }, this.getAMQConnection()).execute();
        ExchangeBoundOkBody responseBody = (ExchangeBoundOkBody)response.getMethod();
        return responseBody.getReplyCode() == 0;
    }

    protected boolean exchangeExists(final String exchangeName) throws QpidException {
        if (!this.getAMQConnection().getDelegate().supportsIsBound()) {
            return false;
        }
        AMQMethodEvent response = new FailoverNoopSupport<AMQMethodEvent, QpidException>(new FailoverProtectedOperation<AMQMethodEvent, QpidException>(){

            @Override
            public AMQMethodEvent execute() throws QpidException, FailoverException {
                return AMQSession_0_8.this.sendExchangeBound(exchangeName, null, null);
            }
        }, this.getAMQConnection()).execute();
        ExchangeBoundOkBody responseBody = (ExchangeBoundOkBody)response.getMethod();
        return responseBody.getReplyCode() == 0 || responseBody.getReplyCode() == 3;
    }

    private AMQMethodEvent sendExchangeBound(String exchangeName, String routingKey, String queueName) throws QpidException, FailoverException {
        AMQFrame boundFrame = this.getProtocolHandler().getMethodRegistry().createExchangeBoundBody(exchangeName, routingKey, queueName).generateFrame(this.getChannelId());
        return this.getProtocolHandler().syncWrite(boundFrame, ExchangeBoundOkBody.class);
    }

    @Override
    public void sendConsume(BasicMessageConsumer_0_8 consumer, String queueName, boolean nowait) throws QpidException, FailoverException {
        queueName = this.preprocessAddressTopic(consumer, queueName);
        AMQDestination destination = consumer.getDestination();
        Map<String, Object> arguments = consumer.getArguments();
        Link link = destination.getLink();
        if (link != null && link.getSubscription() != null && link.getSubscription().getArgs() != null) {
            arguments.putAll(link.getSubscription().getArgs());
        }
        BasicConsumeBody body = this.getMethodRegistry().createBasicConsumeBody(this.getTicket(), queueName, consumer.getConsumerTag(), consumer.isNoLocal(), consumer.getAcknowledgeMode() == 257, consumer.isExclusive(), nowait, arguments);
        AMQFrame jmsConsume = body.generateFrame(this.getChannelId());
        if (nowait) {
            this.getProtocolHandler().writeFrame(jmsConsume);
        } else {
            this.getProtocolHandler().syncWrite(jmsConsume, BasicConsumeOkBody.class);
        }
    }

    @Override
    void createSubscriptionQueue(AMQDestination dest, boolean noLocal, String messageSelector) throws QpidException {
        String queueName;
        final Link link = dest.getLink();
        if (dest.getQueueName() == null) {
            queueName = link.getName() == null ? "TempQueue" + UUID.randomUUID() : link.getName();
            dest.setQueueName(queueName);
        } else {
            queueName = dest.getQueueName();
        }
        final Link.SubscriptionQueue queueProps = link.getSubscriptionQueue();
        final Map<String, Object> arguments = queueProps.getDeclareArgs();
        if (!arguments.containsKey("no-local")) {
            arguments.put("no-local", noLocal);
        }
        if (link.isDurable() && queueName.startsWith("TempQueue")) {
            throw new QpidException("You cannot mark a subscription queue as durable without providing a name for the link.");
        }
        new FailoverNoopSupport<Void, QpidException>(new FailoverProtectedOperation<Void, QpidException>(){

            @Override
            public Void execute() throws QpidException, FailoverException {
                AMQSession_0_8.this.sendQueueDeclare(queueName, link.isDurable(), queueProps.isExclusive(), queueProps.isAutoDelete(), arguments, false);
                return null;
            }
        }, this.getAMQConnection()).execute();
        HashMap<String, Object> bindingArguments = new HashMap<String, Object>();
        bindingArguments.put(AMQPFilterTypes.JMS_SELECTOR.getValue(), messageSelector == null ? "" : messageSelector);
        AMQDestination.Binding binding = new AMQDestination.Binding(dest.getAddressName(), queueName, dest.getSubject(), bindingArguments);
        this.doBind(dest, binding, queueName, dest.getAddressName());
    }

    @Override
    public void sendExchangeDeclare(String name, String type, boolean nowait, boolean durable, boolean autoDelete, boolean internal) throws QpidException, FailoverException {
        ExchangeDeclareBody body = this.getMethodRegistry().createExchangeDeclareBody(this.getTicket(), name, type, name.startsWith("amq."), durable, autoDelete, internal, false, null);
        AMQFrame exchangeDeclare = body.generateFrame(this.getChannelId());
        this.getProtocolHandler().syncWrite(exchangeDeclare, ExchangeDeclareOkBody.class);
    }

    @Override
    public void sendExchangeDeclare(String name, String type, boolean nowait, boolean durable, boolean autoDelete, Map<String, Object> arguments, boolean passive) throws QpidException, FailoverException {
        MethodRegistry methodRegistry = this.getMethodRegistry();
        ExchangeDeclareBody body = methodRegistry.createExchangeDeclareBody(this.getTicket(), name, type, passive || name.startsWith("amq."), durable, autoDelete, false, false, arguments);
        AMQFrame exchangeDeclare = body.generateFrame(this.getChannelId());
        this.getProtocolHandler().syncWrite(exchangeDeclare, ExchangeDeclareOkBody.class);
    }

    @Override
    public void sendExchangeDelete(String name, boolean nowait) throws QpidException, FailoverException {
        ExchangeDeleteBody body = this.getMethodRegistry().createExchangeDeleteBody(this.getTicket(), name, false, false);
        AMQFrame exchangeDelete = body.generateFrame(this.getChannelId());
        this.getProtocolHandler().syncWrite(exchangeDelete, ExchangeDeleteOkBody.class);
    }

    private void sendQueueDeclare(AMQDestination amqd, boolean passive) throws QpidException, FailoverException {
        String queueName = amqd.getAMQQueueName();
        boolean durable = amqd.isDurable();
        boolean exclusive = amqd.isExclusive();
        boolean autoDelete = amqd.isAutoDelete();
        this.sendQueueDeclare(queueName, durable, exclusive, autoDelete, null, passive);
    }

    private void sendQueueDeclare(String queueName, boolean durable, boolean exclusive, boolean autoDelete, Map<String, Object> arguments, boolean passive) throws QpidException, FailoverException {
        QueueDeclareBody body = this.getMethodRegistry().createQueueDeclareBody(this.getTicket(), queueName, passive, durable, exclusive, autoDelete, false, arguments);
        AMQFrame queueDeclare = body.generateFrame(this.getChannelId());
        this.getProtocolHandler().syncWrite(queueDeclare, QueueDeclareOkBody.class);
    }

    @Override
    protected String declareQueue(final AMQDestination amqd, boolean noLocal, boolean nowait, final boolean passive) throws QpidException {
        final AMQProtocolHandler protocolHandler = this.getProtocolHandler();
        return new FailoverNoopSupport<String, QpidException>(new FailoverProtectedOperation<String, QpidException>(){

            @Override
            public String execute() throws QpidException, FailoverException {
                if (amqd.isNameRequired()) {
                    amqd.setQueueName(protocolHandler.generateQueueName());
                }
                AMQSession_0_8.this.sendQueueDeclare(amqd, passive);
                return amqd.getAMQQueueName();
            }
        }, this.getAMQConnection()).execute();
    }

    @Override
    public void sendQueueDelete(String queueName) throws QpidException, FailoverException {
        QueueDeleteBody body = this.getMethodRegistry().createQueueDeleteBody(this.getTicket(), queueName, false, false, false);
        AMQFrame queueDeleteFrame = body.generateFrame(this.getChannelId());
        this.getProtocolHandler().syncWrite(queueDeleteFrame, QueueDeleteOkBody.class);
    }

    @Override
    public void sendSuspendChannel(boolean suspend) throws QpidException, FailoverException {
        ChannelFlowBody body = this.getMethodRegistry().createChannelFlowBody(!suspend);
        AMQFrame channelFlowFrame = body.generateFrame(this.getChannelId());
        this.getAMQConnection().getProtocolHandler().syncWrite(channelFlowFrame, ChannelFlowOkBody.class);
    }

    @Override
    public BasicMessageConsumer_0_8 createMessageConsumer(AMQDestination destination, int prefetchHigh, int prefetchLow, boolean noLocal, boolean exclusive, String messageSelector, Map<String, Object> arguments, boolean noConsume, boolean autoClose) throws JMSException {
        return new BasicMessageConsumer_0_8(this.getChannelId(), this.getAMQConnection(), destination, messageSelector, noLocal, this.getMessageFactoryRegistry(), this, arguments, prefetchHigh, prefetchLow, exclusive, this.getAcknowledgeMode(), noConsume, autoClose);
    }

    @Override
    public BasicMessageProducer_0_8 createMessageProducer(Destination destination, Boolean mandatory, Boolean immediate, long producerId) throws JMSException {
        try {
            return new BasicMessageProducer_0_8(this.getAMQConnection(), (AMQDestination)destination, this.isTransacted(), this.getChannelId(), this, this.getProtocolHandler(), producerId, immediate, mandatory);
        }
        catch (QpidException e) {
            throw JMSExceptionHelper.chainJMSException(new JMSException("Error creating producer"), e);
        }
    }

    @Override
    public void messageReceived(UnprocessedMessage message) {
        if (message instanceof ReturnMessage) {
            this.returnBouncedMessage((ReturnMessage)message);
        } else {
            super.messageReceived(message);
        }
    }

    private void returnBouncedMessage(ReturnMessage msg) {
        try {
            AbstractJMSMessage bouncedMessage = this.getMessageFactoryRegistry().createMessage(0L, false, AMQShortString.toString(msg.getExchange()), AMQShortString.toString(msg.getRoutingKey()), msg.getContentHeader(), msg.getBodies(), this._queueDestinationCache, this._topicDestinationCache, 3);
            int replyCode = msg.getReplyCode();
            AMQShortString reason = msg.getReplyText();
            _logger.debug("Message returned with error code " + replyCode + " (" + reason + ")");
            if (replyCode == 313) {
                this.getAMQConnection().exceptionReceived(new AMQNoConsumersException("Error: " + reason, bouncedMessage, null));
            } else if (replyCode == 312) {
                this.getAMQConnection().exceptionReceived(new AMQNoRouteException("Error: " + reason, bouncedMessage, null));
            } else {
                this.getAMQConnection().exceptionReceived(new AMQUndeliveredException(replyCode, "Error: " + reason, bouncedMessage, null));
            }
        }
        catch (Exception e) {
            _logger.error("Caught exception trying to raise undelivered message exception (dump follows) - ignoring...", (Throwable)e);
        }
    }

    @Override
    public void sendRollback() throws QpidException, FailoverException {
        TxRollbackBody body = this.getMethodRegistry().createTxRollbackBody();
        AMQFrame frame = body.generateFrame(this.getChannelId());
        this.getProtocolHandler().syncWrite(frame, TxRollbackOkBody.class);
        this._unacknowledgedMessages.set(0);
    }

    public void setPrefetchLimits(int messagePrefetch, long sizePrefetch) throws QpidException, FailoverException {
        this._unacknowledgedMessages.set(0);
        if (messagePrefetch > 0 || sizePrefetch > 0L) {
            BasicQosBody basicQosBody = this.getProtocolHandler().getMethodRegistry().createBasicQosBody(sizePrefetch, messagePrefetch, false);
            this.getProtocolHandler().syncWrite(basicQosBody.generateFrame(this.getChannelId()), BasicQosOkBody.class);
        }
    }

    protected boolean ensureCreditForReceive() throws QpidException {
        return new FailoverNoopSupport<Boolean, QpidException>(new FailoverProtectedOperation<Boolean, QpidException>(){

            @Override
            public Boolean execute() throws QpidException, FailoverException {
                int currentPrefetch = AMQSession_0_8.this._unacknowledgedMessages.get();
                if (currentPrefetch >= AMQSession_0_8.this.getPrefetch() && AMQSession_0_8.this.getPrefetch() >= 0) {
                    BasicQosBody basicQosBody = AMQSession_0_8.this.getProtocolHandler().getMethodRegistry().createBasicQosBody(0L, currentPrefetch + 1, false);
                    AMQSession_0_8.this.getProtocolHandler().syncWrite(basicQosBody.generateFrame(AMQSession_0_8.this.getChannelId()), BasicQosOkBody.class);
                    if (currentPrefetch == 0 && !AMQSession_0_8.this.isSuspended()) {
                        AMQSession_0_8.this.sendSuspendChannel(false);
                    }
                    AMQSession_0_8.this._creditChanged.set(true);
                    return true;
                }
                return false;
            }
        }, this.getProtocolHandler().getConnection()).execute();
    }

    protected void reduceCreditToOriginalSize() throws QpidException {
        boolean manageCredit = this.isManagingCredit();
        if (manageCredit && this._creditChanged.compareAndSet(true, false)) {
            new FailoverNoopSupport<Void, QpidException>(new FailoverProtectedOperation<Void, QpidException>(){

                @Override
                public Void execute() throws QpidException, FailoverException {
                    int prefetch = AMQSession_0_8.this.getPrefetch();
                    if (prefetch == 0) {
                        AMQSession_0_8.this.sendSuspendChannel(true);
                    } else {
                        BasicQosBody basicQosBody = AMQSession_0_8.this.getProtocolHandler().getMethodRegistry().createBasicQosBody(0L, prefetch == -1 ? 0 : prefetch, false);
                        AMQSession_0_8.this.getProtocolHandler().syncWrite(basicQosBody.generateFrame(AMQSession_0_8.this.getChannelId()), BasicQosOkBody.class);
                    }
                    return null;
                }
            }, this.getProtocolHandler().getConnection()).execute();
        }
    }

    protected void stopFlowIfNeccessary() {
        boolean autoAckLike;
        int acknowledgeMode = this.getAcknowledgeMode();
        boolean bl = autoAckLike = acknowledgeMode == 1 || acknowledgeMode == 3;
        if (autoAckLike && this.getPrefetch() == 0 && this._creditChanged.compareAndSet(true, false)) {
            ChannelFlowBody body = this.getMethodRegistry().createChannelFlowBody(false);
            AMQFrame channelFlowFrame = body.generateFrame(this.getChannelId());
            this.getProtocolHandler().writeFrame(channelFlowFrame, true);
        }
    }

    protected void incUnacknowledgedMessages() {
        this._unacknowledgedMessages.incrementAndGet();
    }

    public DestinationCache<AMQQueue> getQueueDestinationCache() {
        return this._queueDestinationCache;
    }

    public DestinationCache<AMQTopic> getTopicDestinationCache() {
        return this._topicDestinationCache;
    }

    @Override
    protected Long requestQueueDepth(AMQDestination amqd, boolean sync) throws QpidException, FailoverException {
        if (this._useLegacyQueueDepthBehaviour || this.isBound(null, amqd.getAMQQueueName(), null)) {
            AMQFrame queueDeclare = this.getMethodRegistry().createQueueDeclareBody(this.getTicket(), amqd.getAMQQueueName(), true, amqd.isDurable(), amqd.isExclusive(), amqd.isAutoDelete(), false, null).generateFrame(this.getChannelId());
            QueueDeclareOkHandler okHandler = new QueueDeclareOkHandler();
            this.getProtocolHandler().writeCommandFrameAndWaitForReply(queueDeclare, okHandler);
            return okHandler.getMessageCount();
        }
        return 0L;
    }

    @Override
    protected boolean tagLE(long tag1, long tag2) {
        return tag1 <= tag2;
    }

    @Override
    protected boolean updateRollbackMark(long currentMark, long deliveryTag) {
        return false;
    }

    @Override
    public AMQMessageDelegateFactory getMessageDelegateFactory() {
        return AMQMessageDelegateFactory.FACTORY_0_8;
    }

    @Override
    public void sync() throws QpidException {
        if (this.getAMQConnection().isVirtualHostPropertiesSupported()) {
            this.isBound(null, "$virtualhostProperties", null);
        } else {
            this.declareExchange("amq.direct", "direct", false);
        }
    }

    @Override
    public void resolveAddress(AMQDestination dest, boolean isConsumer, boolean noLocal) throws QpidException {
        if (!this.isAddrSyntaxSupported()) {
            throw new UnsupportedAddressSyntaxException(dest);
        }
        super.resolveAddress(dest, isConsumer, noLocal);
    }

    private boolean isAddrSyntaxSupported() {
        return ((AMQConnectionDelegate_8_0)this.getAMQConnection().getDelegate()).isAddrSyntaxSupported();
    }

    @Override
    public int resolveAddressType(AMQDestination dest) throws QpidException {
        int type = dest.getAddressType();
        String name = dest.getAddressName();
        if (type != 3) {
            return type;
        }
        boolean isExchange = this.exchangeExists(name);
        boolean isQueue = this.isBound(null, name, null);
        if (!isExchange && !isQueue) {
            type = dest instanceof AMQTopic ? 2 : 1;
        } else if (!isExchange) {
            type = 1;
        } else if (!isQueue) {
            type = 2;
        } else {
            throw new QpidException("Ambiguous address, please specify queue or topic as node type");
        }
        dest.setAddressType(type);
        return type;
    }

    @Override
    protected void handleQueueNodeCreation(final AMQDestination dest, boolean noLocal) throws QpidException {
        String altExchange;
        final Node node = dest.getNode();
        final Map<String, Object> arguments = node.getDeclareArgs();
        if (!arguments.containsKey("no-local")) {
            arguments.put("no-local", noLocal);
        }
        if ((altExchange = node.getAlternateExchange()) != null && !"".equals(altExchange)) {
            arguments.put("alternateExchange", altExchange);
        }
        new FailoverNoopSupport<Void, QpidException>(new FailoverProtectedOperation<Void, QpidException>(){

            @Override
            public Void execute() throws QpidException, FailoverException {
                AMQSession_0_8.this.sendQueueDeclare(dest.getAddressName(), node.isDurable(), node.isExclusive(), node.isAutoDelete(), arguments, false);
                return null;
            }
        }, this.getAMQConnection()).execute();
        this.createBindings(dest, dest.getNode().getBindings());
        this.sync();
    }

    @Override
    void handleExchangeNodeCreation(AMQDestination dest) throws QpidException {
        Node node = dest.getNode();
        String altExchange = dest.getNode().getAlternateExchange();
        Map<String, Object> arguments = node.getDeclareArgs();
        if (altExchange != null && !"".equals(altExchange)) {
            arguments.put("alternateExchange", altExchange);
        }
        this.declareExchange(dest.getAddressName(), node.getExchangeType(), false, node.isDurable(), node.isAutoDelete(), arguments, false);
        this.createBindings(dest, dest.getNode().getBindings());
        this.sync();
    }

    @Override
    protected void doBind(AMQDestination dest, final AMQDestination.Binding binding, final String queue, final String exchange) throws QpidException {
        final String bindingKey = binding.getBindingKey() == null ? queue : binding.getBindingKey();
        new FailoverNoopSupport<Object, QpidException>(new FailoverProtectedOperation<Object, QpidException>(){

            @Override
            public Object execute() throws QpidException, FailoverException {
                MethodRegistry methodRegistry = AMQSession_0_8.this.getProtocolHandler().getMethodRegistry();
                QueueBindBody queueBindBody = methodRegistry.createQueueBindBody(AMQSession_0_8.this.getTicket(), queue, exchange, bindingKey, false, binding.getArgs());
                AMQSession_0_8.this.getProtocolHandler().syncWrite(queueBindBody.generateFrame(AMQSession_0_8.this.getChannelId()), QueueBindOkBody.class);
                return null;
            }
        }, this.getAMQConnection()).execute();
    }

    protected void doUnbind(final AMQDestination.Binding binding, final String queue, final String exchange) throws QpidException {
        new FailoverNoopSupport<Object, QpidException>(new FailoverProtectedOperation<Object, QpidException>(){

            @Override
            public Object execute() throws QpidException, FailoverException {
                if (AMQSession_0_8.this.isBound(null, queue, null)) {
                    if (ProtocolVersion.v0_8.equals(AMQSession_0_8.this.getProtocolVersion())) {
                        throw new AMQException(540, "Cannot unbind a queue in AMQP 0-8");
                    }
                    MethodRegistry methodRegistry = AMQSession_0_8.this.getProtocolHandler().getMethodRegistry();
                    String bindingKey = binding.getBindingKey() == null ? queue : binding.getBindingKey();
                    QueueUnbindBody body = methodRegistry.createQueueUnbindBody(AMQSession_0_8.this.getTicket(), AMQShortString.valueOf(queue), AMQShortString.valueOf(exchange), AMQShortString.valueOf(bindingKey), null);
                    AMQSession_0_8.this.getProtocolHandler().syncWrite(body.generateFrame(AMQSession_0_8.this.getChannelId()), QueueUnbindOkBody.class);
                    return null;
                }
                return null;
            }
        }, this.getAMQConnection()).execute();
    }

    @Override
    public boolean isQueueExist(AMQDestination dest, boolean assertNode) throws QpidException {
        Node node = dest.getNode();
        return this.isQueueExist(dest.getAddressName(), assertNode, node.isDurable(), node.isAutoDelete(), node.isExclusive(), node.getDeclareArgs());
    }

    public boolean isQueueExist(final String queueName, boolean assertNode, final boolean durable, final boolean autoDelete, final boolean exclusive, final Map<String, Object> args) throws QpidException {
        boolean match = this.isBound(null, queueName, null);
        if (assertNode) {
            if (!match) {
                throw new QpidException("Assert failed for queue : " + queueName + ". Queue does not exist.");
            }
            new FailoverNoopSupport<Void, QpidException>(new FailoverProtectedOperation<Void, QpidException>(){

                @Override
                public Void execute() throws QpidException, FailoverException {
                    AMQSession_0_8.this.sendQueueDeclare(queueName, durable, exclusive, autoDelete, args, true);
                    return null;
                }
            }, this.getAMQConnection()).execute();
        }
        return match;
    }

    @Override
    public boolean isExchangeExist(AMQDestination dest, boolean assertNode) throws QpidException {
        boolean match = this.exchangeExists(dest.getAddressName());
        Node node = dest.getNode();
        if (match && assertNode) {
            this.declareExchange(dest.getAddressName(), node.getExchangeType(), false, node.isDurable(), node.isAutoDelete(), node.getDeclareArgs(), true);
        }
        if (assertNode && !match) {
            throw new QpidException("Assert failed for address : " + dest + ". Exchange not found.");
        }
        return match;
    }

    @Override
    void handleNodeDelete(final AMQDestination dest) throws QpidException {
        if (2 == dest.getAddressType()) {
            if (this.isExchangeExist(dest, false)) {
                new FailoverNoopSupport<Object, QpidException>(new FailoverProtectedOperation<Object, QpidException>(){

                    @Override
                    public Object execute() throws QpidException, FailoverException {
                        AMQSession_0_8.this.sendExchangeDelete(dest.getAddressName(), false);
                        return null;
                    }
                }, this.getAMQConnection()).execute();
                this.setUnresolved(dest);
            }
        } else if (this.isQueueExist(dest, false)) {
            new FailoverNoopSupport<Object, QpidException>(new FailoverProtectedOperation<Object, QpidException>(){

                @Override
                public Object execute() throws QpidException, FailoverException {
                    AMQSession_0_8.this.sendQueueDelete(dest.getAddressName());
                    return null;
                }
            }, this.getAMQConnection()).execute();
            this.setUnresolved(dest);
        }
    }

    @Override
    void handleLinkDelete(AMQDestination dest) throws QpidException {
        String defaultExchangeForBinding = dest.getAddressType() == 2 ? dest.getAddressName() : "amq.topic";
        String defaultQueueName = null;
        defaultQueueName = 1 == dest.getAddressType() ? dest.getQueueName() : (dest.getLink().getName() != null ? dest.getLink().getName() : dest.getQueueName());
        for (AMQDestination.Binding binding : dest.getLink().getBindings()) {
            String exchange;
            String queue = binding.getQueue() == null ? defaultQueueName : binding.getQueue();
            String string = exchange = binding.getExchange() == null ? defaultExchangeForBinding : binding.getExchange();
            if (_logger.isDebugEnabled()) {
                _logger.debug("Unbinding queue : " + queue + " exchange: " + exchange + " using binding key " + binding.getBindingKey() + " with args " + Strings.printMap(binding.getArgs()));
            }
            this.doUnbind(binding, queue, exchange);
        }
    }

    void deleteSubscriptionQueue(final AMQDestination dest) throws QpidException {
        if (dest.getAddressType() == 2 && dest.getLink().getSubscriptionQueue().isExclusive() && this.isQueueExist(dest.getQueueName(), false, false, false, false, null)) {
            new FailoverNoopSupport<Void, QpidException>(new FailoverProtectedOperation<Void, QpidException>(){

                @Override
                public Void execute() throws QpidException, FailoverException {
                    AMQSession_0_8.this.sendQueueDelete(dest.getQueueName());
                    return null;
                }
            }, this.getAMQConnection()).execute();
        }
    }

    @Override
    protected void flushAcknowledgments() {
    }

    @Override
    protected void deleteTemporaryDestination(TemporaryDestination amqQueue) throws JMSException {
        if (this.getAMQConnection().getDelegate().isQueueLifetimePolicySupported() && amqQueue instanceof AMQTemporaryQueue) {
            super.deleteTemporaryDestination(amqQueue);
        } else {
            _logger.debug("Delete request for temporary destination {} not implemented" + amqQueue.getAMQQueueName());
        }
    }

    @Override
    public boolean isQueueBound(String exchangeName, String queueName, String bindingKey, Map<String, Object> args) throws JMSException {
        return this.isQueueBound(exchangeName, queueName, bindingKey);
    }

    private AMQProtocolHandler getProtocolHandler() {
        return this.getAMQConnection().getProtocolHandler();
    }

    public MethodRegistry getMethodRegistry() {
        MethodRegistry methodRegistry = this.getProtocolHandler().getMethodRegistry();
        return methodRegistry;
    }

    @Override
    public QpidException getLastException() {
        AMQStateManager manager = this.getProtocolHandler().getStateManager();
        Exception e = manager.getLastException();
        if (manager.getCurrentState().equals((Object)AMQState.CONNECTION_CLOSED) && e != null) {
            if (e instanceof QpidException) {
                return (QpidException)e;
            }
            return new AMQException(541, e.getMessage(), e.getCause());
        }
        return null;
    }

    boolean isManagingCredit() {
        int acknowledgeMode = this.getAcknowledgeMode();
        return acknowledgeMode == 2 || acknowledgeMode == 0 || (acknowledgeMode == 1 || acknowledgeMode == 3) && this.getPrefetch() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFlowBlocked() {
        FlowControlIndicator flowControlIndicator = this._flowControl;
        synchronized (flowControlIndicator) {
            return !this._flowControl.getFlowControl();
        }
    }

    @Override
    public void setFlowControl(boolean active) {
        this._flowControl.setFlowControl(active);
        if (_logger.isInfoEnabled()) {
            _logger.info("Broker enforced flow control " + (active ? "no longer in effect" : "has been enforced"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkFlowControl() throws InterruptedException, JMSException {
        long expiryTime = 0L;
        FlowControlIndicator flowControlIndicator = this._flowControl;
        synchronized (flowControlIndicator) {
            while (!this._flowControl.getFlowControl() && (expiryTime == 0L ? System.currentTimeMillis() + this._flowControlWaitFailure : expiryTime) >= System.currentTimeMillis()) {
                this._flowControl.wait(this._flowControlWaitPeriod);
                if (!_logger.isInfoEnabled()) continue;
                _logger.info("Message send delayed by " + (System.currentTimeMillis() + this._flowControlWaitFailure - expiryTime) / 1000L + "s due to broker enforced flow control");
            }
            if (!this._flowControl.getFlowControl()) {
                _logger.error("Message send failed due to timeout waiting on broker enforced flow control");
                throw new JMSException("Unable to send message for " + this._flowControlWaitFailure / 1000L + " seconds due to broker enforced flow control");
            }
        }
    }

    private static final class FlowControlIndicator {
        private volatile boolean _flowControl = true;

        private FlowControlIndicator() {
        }

        public synchronized void setFlowControl(boolean flowControl) {
            this._flowControl = flowControl;
            this.notify();
        }

        public boolean getFlowControl() {
            return this._flowControl;
        }
    }

    private static class QueueDestinationCache
    extends DestinationCache<AMQQueue> {
        private QueueDestinationCache() {
        }

        @Override
        protected AMQQueue newDestination(String exchangeName, String routingKey) {
            return new AMQQueue(exchangeName, routingKey, routingKey);
        }
    }

    private static class TopicDestinationCache
    extends DestinationCache<AMQTopic> {
        private TopicDestinationCache() {
        }

        @Override
        protected AMQTopic newDestination(String exchangeName, String routingKey) {
            return new AMQTopic(exchangeName, routingKey, null);
        }
    }

    public static abstract class DestinationCache<T extends AMQDestination> {
        private final Map<String, Map<String, T>> cache = new HashMap<String, Map<String, T>>();

        public T getDestination(String exchangeName, String routingKey) {
            AMQDestination destination;
            LinkedHashMap routingMap = this.cache.get(exchangeName);
            if (routingMap == null) {
                routingMap = new LinkedHashMap<String, T>(){

                    @Override
                    protected boolean removeEldestEntry(Map.Entry<String, T> eldest) {
                        return this.size() >= 200;
                    }
                };
                this.cache.put(exchangeName, routingMap);
            }
            if ((destination = (AMQDestination)routingMap.get(routingKey)) == null) {
                destination = this.newDestination(exchangeName, routingKey);
                routingMap.put(routingKey, destination);
            }
            return (T)destination;
        }

        protected abstract T newDestination(String var1, String var2);
    }

    class QueueDeclareOkHandler
    extends SpecificMethodFrameListener {
        private long _messageCount;
        private long _consumerCount;

        public QueueDeclareOkHandler() {
            super(AMQSession_0_8.this.getChannelId(), QueueDeclareOkBody.class, AMQSession_0_8.this.getProtocolHandler().getConnectionDetails());
        }

        @Override
        public boolean processMethod(int channelId, AMQMethodBody frame) {
            boolean matches = super.processMethod(channelId, frame);
            if (matches) {
                QueueDeclareOkBody declareOk = (QueueDeclareOkBody)frame;
                this._messageCount = declareOk.getMessageCount();
                this._consumerCount = declareOk.getConsumerCount();
            }
            return matches;
        }

        public long getMessageCount() {
            return this._messageCount;
        }

        public long getConsumerCount() {
            return this._consumerCount;
        }
    }
}

