/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.thread;

import java.lang.reflect.Constructor;
import org.apache.qpid.thread.LoggingUncaughtExceptionHandler;
import org.apache.qpid.thread.ThreadFactory;

public class RealtimeThreadFactory
implements ThreadFactory {
    private final LoggingUncaughtExceptionHandler _loggingUncaughtExceptionHandler = new LoggingUncaughtExceptionHandler();
    private Class threadClass;
    private Constructor threadConstructor;
    private Constructor priorityParameterConstructor;
    private int defaultRTThreadPriority = Integer.getInteger("qpid.rt_thread_priority", 20);

    public RealtimeThreadFactory() throws Exception {
        this.threadClass = Class.forName("javax.realtime.RealtimeThread");
        Class<?> schedulingParametersClass = Class.forName("javax.realtime.SchedulingParameters");
        Class<?> releaseParametersClass = Class.forName("javax.realtime.ReleaseParameters");
        Class<?> memoryParametersClass = Class.forName("javax.realtime.MemoryParameters");
        Class<?> memoryAreaClass = Class.forName("javax.realtime.MemoryArea");
        Class<?> processingGroupParametersClass = Class.forName("javax.realtime.ProcessingGroupParameters");
        Class[] paramTypes = new Class[]{schedulingParametersClass, releaseParametersClass, memoryParametersClass, memoryAreaClass, processingGroupParametersClass, Runnable.class};
        this.threadConstructor = this.threadClass.getConstructor(paramTypes);
        Class<?> priorityParameterClass = Class.forName("javax.realtime.PriorityParameters");
        this.priorityParameterConstructor = priorityParameterClass.getConstructor(Integer.TYPE);
    }

    @Override
    public Thread createThread(Runnable r) throws Exception {
        return this.createThread(r, this.defaultRTThreadPriority);
    }

    @Override
    public Thread createThread(Runnable r, int priority) throws Exception {
        Object priorityParams = this.priorityParameterConstructor.newInstance(priority);
        Thread thread = (Thread)this.threadConstructor.newInstance(priorityParams, null, null, null, null, r);
        thread.setUncaughtExceptionHandler(this._loggingUncaughtExceptionHandler);
        return thread;
    }
}

