/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.nio.ByteBuffer;
import org.apache.qpid.QpidException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyImpl;
import org.apache.qpid.framing.ChannelMethodProcessor;
import org.apache.qpid.framing.EncodableAMQDataBlock;
import org.apache.qpid.framing.MethodDispatcher;

public class ChannelFlowOkBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    public static final int CLASS_ID = 20;
    public static final int METHOD_ID = 21;
    private final boolean _active;

    public ChannelFlowOkBody(boolean active) {
        this._active = active;
    }

    @Override
    public int getClazz() {
        return 20;
    }

    @Override
    public int getMethod() {
        return 21;
    }

    public final boolean getActive() {
        return this._active;
    }

    @Override
    protected int getBodySize() {
        int size = 1;
        return size;
    }

    @Override
    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeBitfield(buffer, this._active ? (byte)1 : 0);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchChannelFlowOk(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[ChannelFlowOkBodyImpl: ");
        buf.append("active=");
        buf.append(this.getActive());
        buf.append("]");
        return buf.toString();
    }

    public static void process(ByteBuffer buffer, ChannelMethodProcessor dispatcher) {
        boolean active;
        boolean bl = active = (buffer.get() & 1) == 1;
        if (!dispatcher.ignoreAllButCloseOk()) {
            dispatcher.receiveChannelFlowOk(active);
        }
    }
}

