/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.protocol;

import org.apache.qpid.QpidException;
import org.apache.qpid.client.failover.FailoverException;
import org.apache.qpid.client.util.BlockingWaiter;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.protocol.AMQMethodEvent;
import org.apache.qpid.protocol.AMQMethodListener;

public abstract class BlockingMethodFrameListener
extends BlockingWaiter<AMQMethodEvent>
implements AMQMethodListener {
    private final String _connectionDetails;
    private int _channelId;

    public BlockingMethodFrameListener(int channelId, String connectionDetails) {
        this._channelId = channelId;
        this._connectionDetails = connectionDetails;
    }

    public abstract boolean processMethod(int var1, AMQMethodBody var2);

    @Override
    public boolean process(AMQMethodEvent evt) {
        Object method = evt.getMethod();
        return evt.getChannelId() == this._channelId && this.processMethod(evt.getChannelId(), (AMQMethodBody)method);
    }

    public boolean methodReceived(AMQMethodEvent evt) {
        return this.received(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AMQMethodEvent blockForFrame(long timeout) throws QpidException, FailoverException {
        try {
            AMQMethodEvent aMQMethodEvent = (AMQMethodEvent)this.block(timeout);
            return aMQMethodEvent;
        }
        finally {
            this.close();
        }
    }

    @Override
    public String getConnectionDetails() {
        return this._connectionDetails;
    }
}

