/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.qpid.transport.Acquired;
import org.apache.qpid.transport.DtxCommit;
import org.apache.qpid.transport.DtxEnd;
import org.apache.qpid.transport.DtxForget;
import org.apache.qpid.transport.DtxGetTimeout;
import org.apache.qpid.transport.DtxPrepare;
import org.apache.qpid.transport.DtxRecover;
import org.apache.qpid.transport.DtxRollback;
import org.apache.qpid.transport.DtxSelect;
import org.apache.qpid.transport.DtxSetTimeout;
import org.apache.qpid.transport.DtxStart;
import org.apache.qpid.transport.ExchangeBind;
import org.apache.qpid.transport.ExchangeBound;
import org.apache.qpid.transport.ExchangeBoundResult;
import org.apache.qpid.transport.ExchangeDeclare;
import org.apache.qpid.transport.ExchangeDelete;
import org.apache.qpid.transport.ExchangeQuery;
import org.apache.qpid.transport.ExchangeQueryResult;
import org.apache.qpid.transport.ExchangeUnbind;
import org.apache.qpid.transport.ExecutionErrorCode;
import org.apache.qpid.transport.ExecutionException;
import org.apache.qpid.transport.ExecutionResult;
import org.apache.qpid.transport.ExecutionSync;
import org.apache.qpid.transport.Future;
import org.apache.qpid.transport.GetTimeoutResult;
import org.apache.qpid.transport.Header;
import org.apache.qpid.transport.MessageAccept;
import org.apache.qpid.transport.MessageAcceptMode;
import org.apache.qpid.transport.MessageAcquire;
import org.apache.qpid.transport.MessageAcquireMode;
import org.apache.qpid.transport.MessageCancel;
import org.apache.qpid.transport.MessageCreditUnit;
import org.apache.qpid.transport.MessageFlow;
import org.apache.qpid.transport.MessageFlowMode;
import org.apache.qpid.transport.MessageFlush;
import org.apache.qpid.transport.MessageReject;
import org.apache.qpid.transport.MessageRejectCode;
import org.apache.qpid.transport.MessageRelease;
import org.apache.qpid.transport.MessageResume;
import org.apache.qpid.transport.MessageResumeResult;
import org.apache.qpid.transport.MessageSetFlowMode;
import org.apache.qpid.transport.MessageStop;
import org.apache.qpid.transport.MessageSubscribe;
import org.apache.qpid.transport.MessageTransfer;
import org.apache.qpid.transport.Method;
import org.apache.qpid.transport.Option;
import org.apache.qpid.transport.QueueDeclare;
import org.apache.qpid.transport.QueueDelete;
import org.apache.qpid.transport.QueuePurge;
import org.apache.qpid.transport.QueueQuery;
import org.apache.qpid.transport.QueueQueryResult;
import org.apache.qpid.transport.RangeSet;
import org.apache.qpid.transport.RecoverResult;
import org.apache.qpid.transport.SessionAttach;
import org.apache.qpid.transport.SessionAttached;
import org.apache.qpid.transport.SessionCommandPoint;
import org.apache.qpid.transport.SessionCompleted;
import org.apache.qpid.transport.SessionConfirmed;
import org.apache.qpid.transport.SessionDetach;
import org.apache.qpid.transport.SessionDetachCode;
import org.apache.qpid.transport.SessionDetached;
import org.apache.qpid.transport.SessionExpected;
import org.apache.qpid.transport.SessionFlush;
import org.apache.qpid.transport.SessionGap;
import org.apache.qpid.transport.SessionKnownCompleted;
import org.apache.qpid.transport.SessionRequestTimeout;
import org.apache.qpid.transport.SessionTimeout;
import org.apache.qpid.transport.Struct;
import org.apache.qpid.transport.TxCommit;
import org.apache.qpid.transport.TxRollback;
import org.apache.qpid.transport.TxSelect;
import org.apache.qpid.transport.XaResult;
import org.apache.qpid.transport.Xid;

public abstract class SessionInvoker {
    final void sessionAttach(byte[] name, Option ... _options) {
        this.invoke(new SessionAttach(name, _options));
    }

    final void sessionAttached(byte[] name, Option ... _options) {
        this.invoke(new SessionAttached(name, _options));
    }

    final void sessionDetach(byte[] name, Option ... _options) {
        this.invoke(new SessionDetach(name, _options));
    }

    final void sessionDetached(byte[] name, SessionDetachCode code, Option ... _options) {
        this.invoke(new SessionDetached(name, code, _options));
    }

    final void sessionRequestTimeout(long timeout, Option ... _options) {
        this.invoke(new SessionRequestTimeout(timeout, _options));
    }

    final void sessionTimeout(long timeout, Option ... _options) {
        this.invoke(new SessionTimeout(timeout, _options));
    }

    final void sessionCommandPoint(int commandId, long commandOffset, Option ... _options) {
        this.invoke(new SessionCommandPoint(commandId, commandOffset, _options));
    }

    final void sessionExpected(RangeSet commands, List<Object> fragments, Option ... _options) {
        this.invoke(new SessionExpected(commands, fragments, _options));
    }

    final void sessionConfirmed(RangeSet commands, List<Object> fragments, Option ... _options) {
        this.invoke(new SessionConfirmed(commands, fragments, _options));
    }

    final void sessionCompleted(RangeSet commands, Option ... _options) {
        this.invoke(new SessionCompleted(commands, _options));
    }

    final void sessionKnownCompleted(RangeSet commands, Option ... _options) {
        this.invoke(new SessionKnownCompleted(commands, _options));
    }

    final void sessionFlush(Option ... _options) {
        this.invoke(new SessionFlush(_options));
    }

    final void sessionGap(RangeSet commands, Option ... _options) {
        this.invoke(new SessionGap(commands, _options));
    }

    public final void executionSync(Option ... _options) {
        this.invoke(new ExecutionSync(_options));
    }

    public final void executionResult(int commandId, Struct value, Option ... _options) {
        this.invoke(new ExecutionResult(commandId, value, _options));
    }

    public final void executionException(ExecutionErrorCode errorCode, int commandId, short classCode, short commandCode, short fieldIndex, String description, Map<String, Object> errorInfo, Option ... _options) {
        this.invoke(new ExecutionException(errorCode, commandId, classCode, commandCode, fieldIndex, description, errorInfo, _options));
    }

    public final void messageTransfer(String destination, MessageAcceptMode acceptMode, MessageAcquireMode acquireMode, Header header, ByteBuffer body, Option ... _options) {
        this.invoke(new MessageTransfer(destination, acceptMode, acquireMode, header, body, _options));
    }

    public final void messageAccept(RangeSet transfers, Option ... _options) {
        this.invoke(new MessageAccept(transfers, _options));
    }

    public final void messageReject(RangeSet transfers, MessageRejectCode code, String text, Option ... _options) {
        this.invoke(new MessageReject(transfers, code, text, _options));
    }

    public final void messageRelease(RangeSet transfers, Option ... _options) {
        this.invoke(new MessageRelease(transfers, _options));
    }

    public final Future<Acquired> messageAcquire(RangeSet transfers, Option ... _options) {
        return this.invoke(new MessageAcquire(transfers, _options), Acquired.class);
    }

    public final Future<MessageResumeResult> messageResume(String destination, String resumeId, Option ... _options) {
        return this.invoke(new MessageResume(destination, resumeId, _options), MessageResumeResult.class);
    }

    public final void messageSubscribe(String queue, String destination, MessageAcceptMode acceptMode, MessageAcquireMode acquireMode, String resumeId, long resumeTtl, Map<String, Object> arguments, Option ... _options) {
        this.invoke(new MessageSubscribe(queue, destination, acceptMode, acquireMode, resumeId, resumeTtl, arguments, _options));
    }

    public final void messageCancel(String destination, Option ... _options) {
        this.invoke(new MessageCancel(destination, _options));
    }

    public final void messageSetFlowMode(String destination, MessageFlowMode flowMode, Option ... _options) {
        this.invoke(new MessageSetFlowMode(destination, flowMode, _options));
    }

    public final void messageFlow(String destination, MessageCreditUnit unit, long value, Option ... _options) {
        this.invoke(new MessageFlow(destination, unit, value, _options));
    }

    public final void messageFlush(String destination, Option ... _options) {
        this.invoke(new MessageFlush(destination, _options));
    }

    public final void messageStop(String destination, Option ... _options) {
        this.invoke(new MessageStop(destination, _options));
    }

    public final void txSelect(Option ... _options) {
        this.invoke(new TxSelect(_options));
    }

    public final void txCommit(Option ... _options) {
        this.invoke(new TxCommit(_options));
    }

    public final void txRollback(Option ... _options) {
        this.invoke(new TxRollback(_options));
    }

    public final void dtxSelect(Option ... _options) {
        this.invoke(new DtxSelect(_options));
    }

    public final Future<XaResult> dtxStart(Xid xid, Option ... _options) {
        return this.invoke(new DtxStart(xid, _options), XaResult.class);
    }

    public final Future<XaResult> dtxEnd(Xid xid, Option ... _options) {
        return this.invoke(new DtxEnd(xid, _options), XaResult.class);
    }

    public final Future<XaResult> dtxCommit(Xid xid, Option ... _options) {
        return this.invoke(new DtxCommit(xid, _options), XaResult.class);
    }

    public final void dtxForget(Xid xid, Option ... _options) {
        this.invoke(new DtxForget(xid, _options));
    }

    public final Future<GetTimeoutResult> dtxGetTimeout(Xid xid, Option ... _options) {
        return this.invoke(new DtxGetTimeout(xid, _options), GetTimeoutResult.class);
    }

    public final Future<XaResult> dtxPrepare(Xid xid, Option ... _options) {
        return this.invoke(new DtxPrepare(xid, _options), XaResult.class);
    }

    public final Future<RecoverResult> dtxRecover(Option ... _options) {
        return this.invoke(new DtxRecover(_options), RecoverResult.class);
    }

    public final Future<XaResult> dtxRollback(Xid xid, Option ... _options) {
        return this.invoke(new DtxRollback(xid, _options), XaResult.class);
    }

    public final void dtxSetTimeout(Xid xid, long timeout, Option ... _options) {
        this.invoke(new DtxSetTimeout(xid, timeout, _options));
    }

    public final void exchangeDeclare(String exchange, String type, String alternateExchange, Map<String, Object> arguments, Option ... _options) {
        this.invoke(new ExchangeDeclare(exchange, type, alternateExchange, arguments, _options));
    }

    public final void exchangeDelete(String exchange, Option ... _options) {
        this.invoke(new ExchangeDelete(exchange, _options));
    }

    public final Future<ExchangeQueryResult> exchangeQuery(String name, Option ... _options) {
        return this.invoke(new ExchangeQuery(name, _options), ExchangeQueryResult.class);
    }

    public final void exchangeBind(String queue, String exchange, String bindingKey, Map<String, Object> arguments, Option ... _options) {
        this.invoke(new ExchangeBind(queue, exchange, bindingKey, arguments, _options));
    }

    public final void exchangeUnbind(String queue, String exchange, String bindingKey, Option ... _options) {
        this.invoke(new ExchangeUnbind(queue, exchange, bindingKey, _options));
    }

    public final Future<ExchangeBoundResult> exchangeBound(String exchange, String queue, String bindingKey, Map<String, Object> arguments, Option ... _options) {
        return this.invoke(new ExchangeBound(exchange, queue, bindingKey, arguments, _options), ExchangeBoundResult.class);
    }

    public final void queueDeclare(String queue, String alternateExchange, Map<String, Object> arguments, Option ... _options) {
        this.invoke(new QueueDeclare(queue, alternateExchange, arguments, _options));
    }

    public final void queueDelete(String queue, Option ... _options) {
        this.invoke(new QueueDelete(queue, _options));
    }

    public final void queuePurge(String queue, Option ... _options) {
        this.invoke(new QueuePurge(queue, _options));
    }

    public final Future<QueueQueryResult> queueQuery(String queue, Option ... _options) {
        return this.invoke(new QueueQuery(queue, _options), QueueQueryResult.class);
    }

    protected abstract void invoke(Method var1);

    protected abstract <T> Future<T> invoke(Method var1, Class<T> var2);
}

