/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.properties;

import org.apache.qpid.util.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionStartProperties {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionStartProperties.class);
    public static final String QPID_CLOSE_WHEN_NO_ROUTE = "qpid.close_when_no_route";
    public static final String QPID_MESSAGE_COMPRESSION_SUPPORTED = "qpid.message_compression_supported";
    public static final String QPID_VIRTUALHOST_PROPERTIES_SUPPORTED = "qpid.virtualhost_properties_supported";
    public static final String CLIENT_ID_0_10 = "clientName";
    public static final String CLIENT_ID_0_8 = "instance";
    public static final String VERSION_0_8 = "version";
    public static final String VERSION_0_10 = "qpid.client_version";
    public static final String PROCESS = "qpid.client_process";
    public static final String PID = "qpid.client_pid";
    public static final String PLATFORM = "platform";
    public static final String PRODUCT = "product";
    public static final String SESSION_FLOW = "qpid.session_flow";
    public static final String QPID_CONFIRMED_PUBLISH_SUPPORTED = "qpid.confirmed_publish_supported";
    public static final String QPID_QUEUE_LIFETIME_SUPPORTED = "qpid.queue_lifetime_supported";
    public static final int _pid = SystemUtils.getProcessPidAsInt();
    public static final String _platformInfo;

    public static int getPID() {
        return _pid;
    }

    public static String getPlatformInfo() {
        return _platformInfo;
    }

    static {
        if (_pid == -1) {
            LOGGER.warn("Unable to get the process's PID");
        }
        StringBuilder fullSystemInfo = new StringBuilder(System.getProperty("java.runtime.name"));
        fullSystemInfo.append(", ");
        fullSystemInfo.append(System.getProperty("java.runtime.version"));
        fullSystemInfo.append(", ");
        fullSystemInfo.append(System.getProperty("java.vendor"));
        fullSystemInfo.append(", ");
        fullSystemInfo.append(SystemUtils.getOSArch());
        fullSystemInfo.append(", ");
        fullSystemInfo.append(SystemUtils.getOSName());
        fullSystemInfo.append(", ");
        fullSystemInfo.append(SystemUtils.getOSVersion());
        fullSystemInfo.append(", ");
        fullSystemInfo.append(System.getProperty("sun.os.patch.level"));
        _platformInfo = fullSystemInfo.toString();
    }
}

