/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.handler;

import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.QpidException;
import org.apache.qpid.client.handler.BasicCancelOkMethodHandler;
import org.apache.qpid.client.handler.BasicDeliverMethodHandler;
import org.apache.qpid.client.handler.BasicReturnMethodHandler;
import org.apache.qpid.client.handler.ChannelCloseMethodHandler;
import org.apache.qpid.client.handler.ChannelCloseOkMethodHandler;
import org.apache.qpid.client.handler.ChannelFlowMethodHandler;
import org.apache.qpid.client.handler.ChannelFlowOkMethodHandler;
import org.apache.qpid.client.handler.ClientMethodDispatcherImpl_0_9;
import org.apache.qpid.client.handler.ClientMethodDispatcherImpl_0_91;
import org.apache.qpid.client.handler.ClientMethodDispatcherImpl_8_0;
import org.apache.qpid.client.handler.ConnectionCloseMethodHandler;
import org.apache.qpid.client.handler.ConnectionOpenOkMethodHandler;
import org.apache.qpid.client.handler.ConnectionRedirectMethodHandler;
import org.apache.qpid.client.handler.ConnectionSecureMethodHandler;
import org.apache.qpid.client.handler.ConnectionStartMethodHandler;
import org.apache.qpid.client.handler.ConnectionTuneMethodHandler;
import org.apache.qpid.client.handler.ExchangeBoundOkMethodHandler;
import org.apache.qpid.client.handler.QueueDeleteOkMethodHandler;
import org.apache.qpid.client.protocol.AMQProtocolSession;
import org.apache.qpid.client.state.AMQMethodNotImplementedException;
import org.apache.qpid.client.state.AMQStateManager;
import org.apache.qpid.framing.AccessRequestBody;
import org.apache.qpid.framing.AccessRequestOkBody;
import org.apache.qpid.framing.BasicAckBody;
import org.apache.qpid.framing.BasicCancelBody;
import org.apache.qpid.framing.BasicCancelOkBody;
import org.apache.qpid.framing.BasicConsumeBody;
import org.apache.qpid.framing.BasicConsumeOkBody;
import org.apache.qpid.framing.BasicDeliverBody;
import org.apache.qpid.framing.BasicGetBody;
import org.apache.qpid.framing.BasicGetEmptyBody;
import org.apache.qpid.framing.BasicGetOkBody;
import org.apache.qpid.framing.BasicNackBody;
import org.apache.qpid.framing.BasicPublishBody;
import org.apache.qpid.framing.BasicQosBody;
import org.apache.qpid.framing.BasicQosOkBody;
import org.apache.qpid.framing.BasicRecoverBody;
import org.apache.qpid.framing.BasicRecoverSyncBody;
import org.apache.qpid.framing.BasicRecoverSyncOkBody;
import org.apache.qpid.framing.BasicRejectBody;
import org.apache.qpid.framing.BasicReturnBody;
import org.apache.qpid.framing.ChannelAlertBody;
import org.apache.qpid.framing.ChannelCloseBody;
import org.apache.qpid.framing.ChannelCloseOkBody;
import org.apache.qpid.framing.ChannelFlowBody;
import org.apache.qpid.framing.ChannelFlowOkBody;
import org.apache.qpid.framing.ChannelOpenBody;
import org.apache.qpid.framing.ChannelOpenOkBody;
import org.apache.qpid.framing.ConfirmSelectBody;
import org.apache.qpid.framing.ConfirmSelectOkBody;
import org.apache.qpid.framing.ConnectionCloseBody;
import org.apache.qpid.framing.ConnectionCloseOkBody;
import org.apache.qpid.framing.ConnectionOpenBody;
import org.apache.qpid.framing.ConnectionOpenOkBody;
import org.apache.qpid.framing.ConnectionRedirectBody;
import org.apache.qpid.framing.ConnectionSecureBody;
import org.apache.qpid.framing.ConnectionSecureOkBody;
import org.apache.qpid.framing.ConnectionStartBody;
import org.apache.qpid.framing.ConnectionStartOkBody;
import org.apache.qpid.framing.ConnectionTuneBody;
import org.apache.qpid.framing.ConnectionTuneOkBody;
import org.apache.qpid.framing.ExchangeBoundBody;
import org.apache.qpid.framing.ExchangeBoundOkBody;
import org.apache.qpid.framing.ExchangeDeclareBody;
import org.apache.qpid.framing.ExchangeDeclareOkBody;
import org.apache.qpid.framing.ExchangeDeleteBody;
import org.apache.qpid.framing.ExchangeDeleteOkBody;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.ProtocolVersion;
import org.apache.qpid.framing.QueueBindBody;
import org.apache.qpid.framing.QueueBindOkBody;
import org.apache.qpid.framing.QueueDeclareBody;
import org.apache.qpid.framing.QueueDeclareOkBody;
import org.apache.qpid.framing.QueueDeleteBody;
import org.apache.qpid.framing.QueueDeleteOkBody;
import org.apache.qpid.framing.QueuePurgeBody;
import org.apache.qpid.framing.QueuePurgeOkBody;
import org.apache.qpid.framing.QueueUnbindBody;
import org.apache.qpid.framing.QueueUnbindOkBody;
import org.apache.qpid.framing.TxCommitBody;
import org.apache.qpid.framing.TxCommitOkBody;
import org.apache.qpid.framing.TxRollbackBody;
import org.apache.qpid.framing.TxRollbackOkBody;
import org.apache.qpid.framing.TxSelectBody;
import org.apache.qpid.framing.TxSelectOkBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientMethodDispatcherImpl
implements MethodDispatcher {
    private static final BasicCancelOkMethodHandler _basicCancelOkMethodHandler = BasicCancelOkMethodHandler.getInstance();
    private static final BasicDeliverMethodHandler _basicDeliverMethodHandler = BasicDeliverMethodHandler.getInstance();
    private static final BasicReturnMethodHandler _basicReturnMethodHandler = BasicReturnMethodHandler.getInstance();
    private static final ChannelCloseMethodHandler _channelCloseMethodHandler = ChannelCloseMethodHandler.getInstance();
    private static final ChannelCloseOkMethodHandler _channelCloseOkMethodHandler = ChannelCloseOkMethodHandler.getInstance();
    private static final ChannelFlowOkMethodHandler _channelFlowOkMethodHandler = ChannelFlowOkMethodHandler.getInstance();
    private static final ChannelFlowMethodHandler _channelFlowMethodHandler = ChannelFlowMethodHandler.getInstance();
    private static final ConnectionCloseMethodHandler _connectionCloseMethodHandler = ConnectionCloseMethodHandler.getInstance();
    private static final ConnectionOpenOkMethodHandler _connectionOpenOkMethodHandler = ConnectionOpenOkMethodHandler.getInstance();
    private static final ConnectionRedirectMethodHandler _connectionRedirectMethodHandler = ConnectionRedirectMethodHandler.getInstance();
    private static final ConnectionSecureMethodHandler _connectionSecureMethodHandler = ConnectionSecureMethodHandler.getInstance();
    private static final ConnectionStartMethodHandler _connectionStartMethodHandler = ConnectionStartMethodHandler.getInstance();
    private static final ConnectionTuneMethodHandler _connectionTuneMethodHandler = ConnectionTuneMethodHandler.getInstance();
    private static final ExchangeBoundOkMethodHandler _exchangeBoundOkMethodHandler = ExchangeBoundOkMethodHandler.getInstance();
    private static final QueueDeleteOkMethodHandler _queueDeleteOkMethodHandler = QueueDeleteOkMethodHandler.getInstance();
    private static final Logger _logger = LoggerFactory.getLogger(ClientMethodDispatcherImpl.class);
    private static final Map<ProtocolVersion, DispatcherFactory> _dispatcherFactories = new HashMap<ProtocolVersion, DispatcherFactory>();
    private AMQProtocolSession _session;

    public static ClientMethodDispatcherImpl newMethodDispatcher(ProtocolVersion version, AMQProtocolSession session) {
        DispatcherFactory factory;
        if (_logger.isDebugEnabled()) {
            _logger.debug("New Method Dispatcher:" + session);
        }
        if ((factory = _dispatcherFactories.get(version)) == null) {
            throw new UnsupportedOperationException("The protocol version " + version + " is not supported");
        }
        return factory.createMethodDispatcher(session);
    }

    public ClientMethodDispatcherImpl(AMQProtocolSession session) {
        this._session = session;
    }

    public AMQStateManager getStateManager() {
        return this._session.getStateManager();
    }

    @Override
    public boolean dispatchAccessRequestOk(AccessRequestOkBody body, int channelId) throws QpidException {
        return false;
    }

    @Override
    public boolean dispatchQueueUnbindOk(QueueUnbindOkBody body, int channelId) throws QpidException {
        throw new AMQMethodNotImplementedException(body);
    }

    @Override
    public boolean dispatchBasicRecoverSyncOk(BasicRecoverSyncOkBody basicRecoverSyncOkBody, int channelId) throws QpidException {
        return false;
    }

    @Override
    public boolean dispatchChannelAlert(ChannelAlertBody channelAlertBody, int channelId) throws QpidException {
        return false;
    }

    @Override
    public boolean dispatchConfirmSelectOk(ConfirmSelectOkBody confirmSelectOkBody, int channelId) throws QpidException {
        return false;
    }

    @Override
    public boolean dispatchBasicCancelOk(BasicCancelOkBody body, int channelId) throws QpidException {
        _basicCancelOkMethodHandler.methodReceived(this._session, body, channelId);
        return true;
    }

    @Override
    public boolean dispatchBasicConsumeOk(BasicConsumeOkBody body, int channelId) throws QpidException {
        return false;
    }

    @Override
    public boolean dispatchBasicDeliver(BasicDeliverBody body, int channelId) throws QpidException {
        _basicDeliverMethodHandler.methodReceived(this._session, body, channelId);
        return true;
    }

    @Override
    public boolean dispatchBasicGetEmpty(BasicGetEmptyBody body, int channelId) throws QpidException {
        return false;
    }

    @Override
    public boolean dispatchBasicGetOk(BasicGetOkBody body, int channelId) throws QpidException {
        return false;
    }

    @Override
    public boolean dispatchBasicQosOk(BasicQosOkBody body, int channelId) throws QpidException {
        return false;
    }

    @Override
    public boolean dispatchBasicReturn(BasicReturnBody body, int channelId) throws QpidException {
        _basicReturnMethodHandler.methodReceived(this._session, body, channelId);
        return true;
    }

    @Override
    public boolean dispatchChannelClose(ChannelCloseBody body, int channelId) throws QpidException {
        _channelCloseMethodHandler.methodReceived(this._session, body, channelId);
        return true;
    }

    @Override
    public boolean dispatchChannelCloseOk(ChannelCloseOkBody body, int channelId) throws QpidException {
        _channelCloseOkMethodHandler.methodReceived(this._session, body, channelId);
        return true;
    }

    @Override
    public boolean dispatchChannelFlow(ChannelFlowBody body, int channelId) throws QpidException {
        _channelFlowMethodHandler.methodReceived(this._session, body, channelId);
        return true;
    }

    @Override
    public boolean dispatchChannelFlowOk(ChannelFlowOkBody body, int channelId) throws QpidException {
        _channelFlowOkMethodHandler.methodReceived(this._session, body, channelId);
        return true;
    }

    @Override
    public boolean dispatchChannelOpenOk(ChannelOpenOkBody body, int channelId) throws QpidException {
        return false;
    }

    @Override
    public boolean dispatchConnectionClose(ConnectionCloseBody body, int channelId) throws QpidException {
        _connectionCloseMethodHandler.methodReceived(this._session, body, channelId);
        return true;
    }

    @Override
    public boolean dispatchConnectionCloseOk(ConnectionCloseOkBody body, int channelId) throws QpidException {
        return false;
    }

    @Override
    public boolean dispatchConnectionOpenOk(ConnectionOpenOkBody body, int channelId) throws QpidException {
        _connectionOpenOkMethodHandler.methodReceived(this._session, body, channelId);
        return true;
    }

    @Override
    public boolean dispatchConnectionRedirect(ConnectionRedirectBody body, int channelId) throws QpidException {
        _connectionRedirectMethodHandler.methodReceived(this._session, body, channelId);
        return true;
    }

    @Override
    public boolean dispatchConnectionSecure(ConnectionSecureBody body, int channelId) throws QpidException {
        _connectionSecureMethodHandler.methodReceived(this._session, body, channelId);
        return true;
    }

    @Override
    public boolean dispatchConnectionStart(ConnectionStartBody body, int channelId) throws QpidException {
        _connectionStartMethodHandler.methodReceived(this._session, body, channelId);
        return true;
    }

    @Override
    public boolean dispatchConnectionTune(ConnectionTuneBody body, int channelId) throws QpidException {
        _connectionTuneMethodHandler.methodReceived(this._session, body, channelId);
        return true;
    }

    @Override
    public boolean dispatchQueueDeleteOk(QueueDeleteOkBody body, int channelId) throws QpidException {
        _queueDeleteOkMethodHandler.methodReceived(this._session, body, channelId);
        return true;
    }

    @Override
    public boolean dispatchQueuePurgeOk(QueuePurgeOkBody body, int channelId) throws QpidException {
        return false;
    }

    @Override
    public boolean dispatchAccessRequest(AccessRequestBody body, int channelId) throws QpidException {
        throw new AMQMethodNotImplementedException(body);
    }

    @Override
    public boolean dispatchBasicAck(BasicAckBody body, int channelId) throws QpidException {
        return false;
    }

    @Override
    public boolean dispatchBasicNack(BasicNackBody basicNackBody, int channelId) {
        return false;
    }

    @Override
    public boolean dispatchBasicCancel(BasicCancelBody body, int channelId) throws QpidException {
        throw new AMQMethodNotImplementedException(body);
    }

    @Override
    public boolean dispatchBasicConsume(BasicConsumeBody body, int channelId) throws QpidException {
        throw new AMQMethodNotImplementedException(body);
    }

    @Override
    public boolean dispatchBasicGet(BasicGetBody body, int channelId) throws QpidException {
        throw new AMQMethodNotImplementedException(body);
    }

    @Override
    public boolean dispatchBasicPublish(BasicPublishBody body, int channelId) throws QpidException {
        throw new AMQMethodNotImplementedException(body);
    }

    @Override
    public boolean dispatchBasicQos(BasicQosBody body, int channelId) throws QpidException {
        throw new AMQMethodNotImplementedException(body);
    }

    @Override
    public boolean dispatchBasicRecover(BasicRecoverBody body, int channelId) throws QpidException {
        throw new AMQMethodNotImplementedException(body);
    }

    @Override
    public boolean dispatchBasicReject(BasicRejectBody body, int channelId) throws QpidException {
        throw new AMQMethodNotImplementedException(body);
    }

    @Override
    public boolean dispatchChannelOpen(ChannelOpenBody body, int channelId) throws QpidException {
        throw new AMQMethodNotImplementedException(body);
    }

    @Override
    public boolean dispatchConnectionOpen(ConnectionOpenBody body, int channelId) throws QpidException {
        throw new AMQMethodNotImplementedException(body);
    }

    @Override
    public boolean dispatchConnectionSecureOk(ConnectionSecureOkBody body, int channelId) throws QpidException {
        throw new AMQMethodNotImplementedException(body);
    }

    @Override
    public boolean dispatchConnectionStartOk(ConnectionStartOkBody body, int channelId) throws QpidException {
        throw new AMQMethodNotImplementedException(body);
    }

    @Override
    public boolean dispatchConnectionTuneOk(ConnectionTuneOkBody body, int channelId) throws QpidException {
        throw new AMQMethodNotImplementedException(body);
    }

    @Override
    public boolean dispatchExchangeBound(ExchangeBoundBody body, int channelId) throws QpidException {
        throw new AMQMethodNotImplementedException(body);
    }

    @Override
    public boolean dispatchExchangeDeclare(ExchangeDeclareBody body, int channelId) throws QpidException {
        throw new AMQMethodNotImplementedException(body);
    }

    @Override
    public boolean dispatchExchangeDelete(ExchangeDeleteBody body, int channelId) throws QpidException {
        throw new AMQMethodNotImplementedException(body);
    }

    @Override
    public boolean dispatchQueueBind(QueueBindBody body, int channelId) throws QpidException {
        throw new AMQMethodNotImplementedException(body);
    }

    @Override
    public boolean dispatchQueueDeclare(QueueDeclareBody body, int channelId) throws QpidException {
        throw new AMQMethodNotImplementedException(body);
    }

    @Override
    public boolean dispatchQueueDelete(QueueDeleteBody body, int channelId) throws QpidException {
        throw new AMQMethodNotImplementedException(body);
    }

    @Override
    public boolean dispatchQueuePurge(QueuePurgeBody body, int channelId) throws QpidException {
        throw new AMQMethodNotImplementedException(body);
    }

    @Override
    public boolean dispatchTxCommit(TxCommitBody body, int channelId) throws QpidException {
        throw new AMQMethodNotImplementedException(body);
    }

    @Override
    public boolean dispatchTxRollback(TxRollbackBody body, int channelId) throws QpidException {
        throw new AMQMethodNotImplementedException(body);
    }

    @Override
    public boolean dispatchTxSelect(TxSelectBody body, int channelId) throws QpidException {
        throw new AMQMethodNotImplementedException(body);
    }

    @Override
    public boolean dispatchQueueUnbind(QueueUnbindBody queueUnbindBody, int channelId) throws QpidException {
        return false;
    }

    @Override
    public boolean dispatchBasicRecoverSync(BasicRecoverSyncBody basicRecoverSyncBody, int channelId) throws QpidException {
        return false;
    }

    @Override
    public boolean dispatchConfirmSelect(ConfirmSelectBody body, int channelId) throws QpidException {
        throw new AMQMethodNotImplementedException(body);
    }

    @Override
    public boolean dispatchExchangeBoundOk(ExchangeBoundOkBody body, int channelId) throws QpidException {
        _exchangeBoundOkMethodHandler.methodReceived(this._session, body, channelId);
        return true;
    }

    @Override
    public boolean dispatchExchangeDeclareOk(ExchangeDeclareOkBody body, int channelId) throws QpidException {
        return false;
    }

    @Override
    public boolean dispatchExchangeDeleteOk(ExchangeDeleteOkBody body, int channelId) throws QpidException {
        return false;
    }

    @Override
    public boolean dispatchQueueBindOk(QueueBindOkBody body, int channelId) throws QpidException {
        return false;
    }

    @Override
    public boolean dispatchQueueDeclareOk(QueueDeclareOkBody body, int channelId) throws QpidException {
        return false;
    }

    @Override
    public boolean dispatchTxCommitOk(TxCommitOkBody body, int channelId) throws QpidException {
        return false;
    }

    @Override
    public boolean dispatchTxRollbackOk(TxRollbackOkBody body, int channelId) throws QpidException {
        return false;
    }

    @Override
    public boolean dispatchTxSelectOk(TxSelectOkBody body, int channelId) throws QpidException {
        return false;
    }

    static {
        _dispatcherFactories.put(ProtocolVersion.v0_8, new DispatcherFactory(){

            @Override
            public ClientMethodDispatcherImpl createMethodDispatcher(AMQProtocolSession session) {
                return new ClientMethodDispatcherImpl_8_0(session);
            }
        });
        _dispatcherFactories.put(ProtocolVersion.v0_9, new DispatcherFactory(){

            @Override
            public ClientMethodDispatcherImpl createMethodDispatcher(AMQProtocolSession session) {
                return new ClientMethodDispatcherImpl_0_9(session);
            }
        });
        _dispatcherFactories.put(ProtocolVersion.v0_91, new DispatcherFactory(){

            @Override
            public ClientMethodDispatcherImpl createMethodDispatcher(AMQProtocolSession session) {
                return new ClientMethodDispatcherImpl_0_91(session);
            }
        });
    }

    private static interface DispatcherFactory {
        public ClientMethodDispatcherImpl createMethodDispatcher(AMQProtocolSession var1);
    }
}

