/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport.network.io;

import java.net.Socket;
import java.net.SocketAddress;
import java.security.Principal;
import java.security.cert.Certificate;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import org.apache.qpid.transport.ByteBufferSender;
import org.apache.qpid.transport.ExceptionHandlingByteBufferReceiver;
import org.apache.qpid.transport.network.NetworkConnection;
import org.apache.qpid.transport.network.Ticker;
import org.apache.qpid.transport.network.io.IoReceiver;
import org.apache.qpid.transport.network.io.IoSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoNetworkConnection
implements NetworkConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoNetworkConnection.class);
    private final Socket _socket;
    private final long _timeout;
    private final IoSender _ioSender;
    private final IoReceiver _ioReceiver;
    private Principal _principal;
    private boolean _principalChecked;
    private final Object _lock = new Object();
    private Certificate _certificate;
    private long _maxWriteIdleMillis;
    private long _maxReadIdleMillis;

    public IoNetworkConnection(Socket socket, ExceptionHandlingByteBufferReceiver delegate, int sendBufferSize, int receiveBufferSize, long timeout, Ticker ticker) {
        this._socket = socket;
        this._timeout = timeout;
        this._ioReceiver = new IoReceiver(this._socket, delegate, receiveBufferSize, this._timeout);
        this._ioReceiver.setTicker(ticker);
        this._ioSender = new IoSender(this._socket, 2 * sendBufferSize, this._timeout);
        this._ioSender.setReceiver(this._ioReceiver);
    }

    @Override
    public void start() {
        this._ioSender.initiate();
        this._ioReceiver.initiate();
    }

    @Override
    public ByteBufferSender getSender() {
        return this._ioSender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this._ioSender.close();
        }
        finally {
            this._ioReceiver.close(false);
        }
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this._socket.getRemoteSocketAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this._socket.getLocalSocketAddress();
    }

    @Override
    public void setMaxWriteIdleMillis(long millis) {
        this._maxWriteIdleMillis = millis;
    }

    @Override
    public void setMaxReadIdleMillis(long millis) {
        this._maxReadIdleMillis = millis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Principal getPeerPrincipal() {
        Object object = this._lock;
        synchronized (object) {
            if (!this._principalChecked) {
                if (this._socket instanceof SSLSocket) {
                    try {
                        this._principal = ((SSLSocket)this._socket).getSession().getPeerPrincipal();
                        Certificate[] certs = ((SSLSocket)this._socket).getSession().getPeerCertificates();
                        if (certs != null && certs.length != 0) {
                            this._certificate = certs[0];
                        }
                    }
                    catch (SSLPeerUnverifiedException e) {
                        this._principal = null;
                    }
                }
                this._principalChecked = true;
            }
            return this._principal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Certificate getPeerCertificate() {
        Object object = this._lock;
        synchronized (object) {
            if (!this._principalChecked) {
                this.getPeerPrincipal();
            }
        }
        return this._certificate;
    }

    @Override
    public long getMaxReadIdleMillis() {
        return this._maxReadIdleMillis;
    }

    @Override
    public long getMaxWriteIdleMillis() {
        return this._maxWriteIdleMillis;
    }
}

