/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.nio.ByteBuffer;
import org.apache.qpid.QpidException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyImpl;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.ChannelMethodProcessor;
import org.apache.qpid.framing.EncodableAMQDataBlock;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.util.ByteBufferUtils;

public class ChannelCloseBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    public static final int CLASS_ID = 20;
    public static final int METHOD_ID = 40;
    private final int _replyCode;
    private final AMQShortString _replyText;
    private final int _classId;
    private final int _methodId;

    public ChannelCloseBody(int replyCode, AMQShortString replyText, int classId, int methodId) {
        this._replyCode = replyCode;
        this._replyText = replyText;
        this._classId = classId;
        this._methodId = methodId;
    }

    @Override
    public int getClazz() {
        return 20;
    }

    @Override
    public int getMethod() {
        return 40;
    }

    public final int getReplyCode() {
        return this._replyCode;
    }

    public final AMQShortString getReplyText() {
        return this._replyText;
    }

    public final int getClassId() {
        return this._classId;
    }

    public final int getMethodId() {
        return this._methodId;
    }

    @Override
    protected int getBodySize() {
        int size = 6;
        return size += this.getSizeOf(this._replyText);
    }

    @Override
    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeUnsignedShort(buffer, this._replyCode);
        this.writeAMQShortString(buffer, this._replyText);
        this.writeUnsignedShort(buffer, this._classId);
        this.writeUnsignedShort(buffer, this._methodId);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchChannelClose(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[ChannelCloseBodyImpl: ");
        buf.append("replyCode=");
        buf.append(this.getReplyCode());
        buf.append(", ");
        buf.append("replyText=");
        buf.append(this.getReplyText());
        buf.append(", ");
        buf.append("classId=");
        buf.append(this.getClassId());
        buf.append(", ");
        buf.append("methodId=");
        buf.append(this.getMethodId());
        buf.append("]");
        return buf.toString();
    }

    public static void process(ByteBuffer buffer, ChannelMethodProcessor dispatcher) {
        int replyCode = ByteBufferUtils.getUnsignedShort(buffer);
        AMQShortString replyText = AMQShortString.readAMQShortString(buffer);
        int classId = ByteBufferUtils.getUnsignedShort(buffer);
        int methodId = ByteBufferUtils.getUnsignedShort(buffer);
        if (!dispatcher.ignoreAllButCloseOk()) {
            dispatcher.receiveChannelClose(replyCode, replyText, classId, methodId);
        }
    }
}

