/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.client.AMQConnectionURL;
import org.apache.qpid.transport.ConnectionSettings;
import org.apache.qpid.url.URLHelper;
import org.apache.qpid.url.URLSyntaxException;

public class BrokerDetails
implements Serializable {
    public static final String OPTIONS_RETRY = "retries";
    public static final String OPTIONS_CONNECT_TIMEOUT = "connecttimeout";
    public static final String OPTIONS_CONNECT_DELAY = "connectdelay";
    public static final String OPTIONS_HEARTBEAT = "heartbeat";
    private static final String OPTIONS_IDLE_TIMEOUT = "idle_timeout";
    public static final String OPTIONS_SASL_MECHS = "sasl_mechs";
    public static final String OPTIONS_SASL_ENCRYPTION = "sasl_encryption";
    public static final String OPTIONS_SSL = "ssl";
    public static final String OPTIONS_TCP_NO_DELAY = "tcp_nodelay";
    public static final String OPTIONS_SASL_PROTOCOL_NAME = "sasl_protocol";
    public static final String OPTIONS_SASL_SERVER_NAME = "sasl_server";
    public static final String OPTIONS_TRUST_STORE = "trust_store";
    public static final String OPTIONS_TRUST_STORE_PASSWORD = "trust_store_password";
    public static final String OPTIONS_KEY_STORE = "key_store";
    public static final String OPTIONS_KEY_STORE_PASSWORD = "key_store_password";
    public static final String OPTIONS_SSL_VERIFY_HOSTNAME = "ssl_verify_hostname";
    public static final String OPTIONS_SSL_CERT_ALIAS = "ssl_cert_alias";
    public static final String OPTIONS_CLIENT_CERT_PRIV_KEY_PATH = "client_cert_priv_key_path";
    public static final String OPTIONS_CLIENT_CERT_PATH = "client_cert_path";
    public static final String OPTIONS_CLIENT_CERT_INTERMEDIARY_CERT_PATH = "client_cert_intermediary_cert_path";
    public static final String OPTIONS_TRUSTED_CERTIFICATES_PATH = "trusted_certs_path";
    public static final String OPTIONS_ENCRYPTION_TRUST_STORE = "encryption_trust_store";
    public static final String OPTIONS_ENCRYPTION_TRUST_STORE_PASSWORD = "encryption_trust_store_password";
    public static final String OPTIONS_ENCRYPTION_REMOTE_TRUST_STORE = "encryption_remote_trust_store";
    public static final String OPTIONS_ENCRYPTION_KEY_STORE = "encryption_key_store";
    public static final String OPTIONS_ENCRYPTION_KEY_STORE_PASSWORD = "encryption_key_store_password";
    public static final int DEFAULT_PORT = 5672;
    public static final String TCP = "tcp";
    public static final String SOCKET = "socket";
    public static final String DEFAULT_TRANSPORT = "tcp";
    public static final String URL_FORMAT_EXAMPLE = "<transport>://<hostname>[:<port Default=\"5672\">][?<option>='<value>'[,<option>='<value>']]";
    public static final int DEFAULT_CONNECT_TIMEOUT = 30000;
    public static final boolean USE_SSL_DEFAULT = false;
    public static final String PROTOCOL_TCP = "tcp";
    public static final String PROTOCOL_TLS = "tls";
    public static final String VIRTUAL_HOST = "virtualhost";
    public static final String CLIENT_ID = "client_id";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    private static final long serialVersionUID = 8762219750300869355L;
    private String _host;
    private int _port;
    private String _transport;
    private Map<String, String> _options = new HashMap<String, String>();
    private AMQConnectionURL _connectionUrl;

    public BrokerDetails(BrokerDetails details) {
        this._host = details.getHost();
        this._port = details.getPort();
        this._transport = details.getTransport();
        this._options = new HashMap<String, String>(details._options);
        this._connectionUrl = details._connectionUrl;
    }

    public BrokerDetails() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BrokerDetails(String url) throws URLSyntaxException {
        try {
            URI connection = new URI(url);
            String transport = connection.getScheme();
            if (transport != null) {
                if (!transport.equalsIgnoreCase("tcp") && !transport.equalsIgnoreCase(SOCKET)) {
                    if (transport.equalsIgnoreCase("localhost")) {
                        connection = new URI("tcp://" + url);
                        transport = connection.getScheme();
                    } else {
                        if (url.charAt(transport.length()) != ':' || url.charAt(transport.length() + 1) == '/') throw URLHelper.parseError(0, transport.length(), "Unknown transport", url);
                        connection = new URI("tcp://" + url);
                        transport = connection.getScheme();
                    }
                } else if (url.indexOf("//") == -1) {
                    throw new URLSyntaxException(url, "Missing '//' after the transport In broker URL", transport.length() + 1, 1);
                }
            } else {
                connection = new URI("tcp://" + url);
                transport = connection.getScheme();
            }
            if (transport == null) {
                throw URLHelper.parseError(-1, "Unknown transport in broker URL:'" + url + "' Format: " + URL_FORMAT_EXAMPLE, "");
            }
            this.setTransport(transport);
            String host = connection.getHost();
            if (host == null) {
                host = "";
                String auth = connection.getAuthority();
                if (auth != null) {
                    host = auth.contains(":") ? auth.substring(0, auth.indexOf(":")) : auth;
                }
            }
            this.setHost(host);
            int port = connection.getPort();
            if (port == -1) {
                String auth = connection.getAuthority();
                if (auth != null && auth.contains(":")) {
                    int start;
                    int end = start = auth.indexOf(":") + 1;
                    boolean looking = true;
                    boolean found = false;
                    if (start == auth.length()) {
                        throw URLHelper.parseError(connection.toString().indexOf(auth) + end - 1, connection.toString().indexOf(auth) + end, "Port number must be specified", connection.toString());
                    }
                    while (looking) {
                        try {
                            Integer.parseInt(auth.substring(start, ++end));
                            if (end < auth.length()) continue;
                            looking = false;
                            found = true;
                        }
                        catch (NumberFormatException nfe) {
                            looking = false;
                        }
                    }
                    if (!found) throw URLHelper.parseError(connection.toString().indexOf(connection.getAuthority()) + end - 1, "Illegal character in port number", connection.toString());
                    this.setPort(Integer.parseInt(auth.substring(start, end)));
                } else {
                    this.setPort(5672);
                }
            } else {
                this.setPort(port);
            }
            String queryString = connection.getQuery();
            URLHelper.parseOptions(this._options, queryString);
            return;
        }
        catch (URISyntaxException uris) {
            if (!(uris instanceof URLSyntaxException)) throw URLHelper.parseError(uris.getIndex(), uris.getReason(), uris.getInput());
            throw (URLSyntaxException)uris;
        }
    }

    public BrokerDetails(String host, int port) {
        this._host = host;
        this._port = port;
    }

    public String getHost() {
        return this._host;
    }

    public void setHost(String _host) {
        this._host = _host;
    }

    public int getPort() {
        return this._port;
    }

    public void setPort(int _port) {
        this._port = _port;
    }

    public String getTransport() {
        return this._transport;
    }

    public void setTransport(String _transport) {
        this._transport = _transport;
    }

    public String getProperty(String key) {
        String value = this._options.get(key);
        if (value == null && this._connectionUrl != null) {
            value = this._connectionUrl.getOption(key);
        }
        return value;
    }

    public void setProperty(String key, String value) {
        this._options.put(key, value);
    }

    private int lookupConnectTimeout() {
        if (this._options.containsKey(OPTIONS_CONNECT_TIMEOUT)) {
            try {
                return Integer.parseInt(this._options.get(OPTIONS_CONNECT_TIMEOUT));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 30000;
    }

    public boolean getBooleanProperty(String propName) {
        return this.getBooleanProperty(propName, false);
    }

    public boolean getBooleanProperty(String propName, boolean defaultValue) {
        if (this._options.containsKey(propName)) {
            if (this._options.get(propName).equalsIgnoreCase("false")) {
                return false;
            }
            if (this._options.get(propName).equalsIgnoreCase("true")) {
                return true;
            }
            return defaultValue;
        }
        return defaultValue;
    }

    private int getIntegerProperty(String key) {
        String stringValue = this.getProperty(key);
        try {
            return Integer.parseInt(stringValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Cannot parse key " + key + " with value '" + stringValue + "' as integer.", e);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this._transport);
        sb.append("://");
        sb.append(this._host);
        sb.append(':');
        sb.append(this._port);
        sb.append(this.printOptionsURL());
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrokerDetails bd = (BrokerDetails)o;
        return this._host.toLowerCase().equals(bd.getHost() == null ? null : bd.getHost().toLowerCase()) && this._port == bd.getPort() && this._transport.toLowerCase().equals(bd.getTransport() == null ? null : bd.getTransport().toLowerCase());
    }

    public int hashCode() {
        int result = this._host != null ? this._host.toLowerCase().hashCode() : 0;
        result = 31 * result + this._port;
        result = 31 * result + (this._transport != null ? this._transport.toLowerCase().hashCode() : 0);
        return result;
    }

    private String printOptionsURL() {
        StringBuffer optionsURL = new StringBuffer();
        optionsURL.append('?');
        if (!this._options.isEmpty()) {
            for (String key : this._options.keySet()) {
                optionsURL.append(key);
                optionsURL.append("='");
                if (OPTIONS_TRUST_STORE_PASSWORD.equals(key) || OPTIONS_KEY_STORE_PASSWORD.equals(key)) {
                    optionsURL.append("********");
                } else {
                    optionsURL.append(this._options.get(key));
                }
                optionsURL.append("'");
                optionsURL.append('&');
            }
        }
        optionsURL.deleteCharAt(optionsURL.length() - 1);
        return optionsURL.toString();
    }

    public static String checkTransport(String broker) {
        if (!broker.contains("://")) {
            return "tcp://" + broker;
        }
        return broker;
    }

    public ConnectionSettings buildConnectionSettings() {
        ConnectionSettings conSettings = new ConnectionSettings();
        conSettings.setHost(this.getHost());
        conSettings.setPort(this.getPort());
        conSettings.setTransport(this.getTransport());
        if (this.getProperty(OPTIONS_SASL_MECHS) != null) {
            conSettings.setSaslMechs(this.getProperty(OPTIONS_SASL_MECHS));
        }
        if (this.getProperty(OPTIONS_SASL_PROTOCOL_NAME) != null) {
            conSettings.setSaslProtocol(this.getProperty(OPTIONS_SASL_PROTOCOL_NAME));
        }
        if (this.getProperty(OPTIONS_SASL_SERVER_NAME) != null) {
            conSettings.setSaslServerName(this.getProperty(OPTIONS_SASL_SERVER_NAME));
        }
        conSettings.setUseSASLEncryption(this.getBooleanProperty(OPTIONS_SASL_ENCRYPTION));
        conSettings.setUseSSL(this.getBooleanProperty(OPTIONS_SSL));
        if (this.getProperty(OPTIONS_TRUST_STORE) != null) {
            conSettings.setTrustStorePath(this.getProperty(OPTIONS_TRUST_STORE));
        }
        if (this.getProperty(OPTIONS_TRUST_STORE_PASSWORD) != null) {
            conSettings.setTrustStorePassword(this.getProperty(OPTIONS_TRUST_STORE_PASSWORD));
        }
        if (this.getProperty(OPTIONS_KEY_STORE) != null) {
            conSettings.setKeyStorePath(this.getProperty(OPTIONS_KEY_STORE));
        }
        if (this.getProperty(OPTIONS_KEY_STORE_PASSWORD) != null) {
            conSettings.setKeyStorePassword(this.getProperty(OPTIONS_KEY_STORE_PASSWORD));
        }
        if (this.getProperty(OPTIONS_SSL_CERT_ALIAS) != null) {
            conSettings.setCertAlias(this.getProperty(OPTIONS_SSL_CERT_ALIAS));
        }
        if (this.getProperty(OPTIONS_CLIENT_CERT_PRIV_KEY_PATH) != null) {
            conSettings.setClientCertificatePrivateKeyPath(this.getProperty(OPTIONS_CLIENT_CERT_PRIV_KEY_PATH));
        }
        if (this.getProperty(OPTIONS_CLIENT_CERT_PATH) != null) {
            conSettings.setClientCertificatePath(this.getProperty(OPTIONS_CLIENT_CERT_PATH));
        }
        if (this.getProperty(OPTIONS_CLIENT_CERT_INTERMEDIARY_CERT_PATH) != null) {
            conSettings.setClientCertificateIntermediateCertsPath(this.getProperty(OPTIONS_CLIENT_CERT_INTERMEDIARY_CERT_PATH));
        }
        if (this.getProperty(OPTIONS_TRUSTED_CERTIFICATES_PATH) != null) {
            conSettings.setTrustedCertificatesFile(this.getProperty(OPTIONS_TRUSTED_CERTIFICATES_PATH));
        }
        boolean defaultSSLVerifyHostName = Boolean.parseBoolean(System.getProperty("qpid.connection_ssl_verify_hostname", String.valueOf(true)));
        conSettings.setVerifyHostname(this.getBooleanProperty(OPTIONS_SSL_VERIFY_HOSTNAME, defaultSSLVerifyHostName));
        if (this.getProperty(OPTIONS_ENCRYPTION_KEY_STORE) != null) {
            conSettings.setEncryptionKeyStorePath(this.getProperty(OPTIONS_ENCRYPTION_KEY_STORE));
        }
        if (this.getProperty(OPTIONS_ENCRYPTION_KEY_STORE_PASSWORD) != null) {
            conSettings.setEncryptionKeyStorePassword(this.getProperty(OPTIONS_ENCRYPTION_KEY_STORE_PASSWORD));
        }
        if (this.getProperty(OPTIONS_ENCRYPTION_TRUST_STORE) != null) {
            conSettings.setEncryptionTrustStorePath(this.getProperty(OPTIONS_ENCRYPTION_TRUST_STORE));
        }
        if (this.getProperty(OPTIONS_ENCRYPTION_TRUST_STORE_PASSWORD) != null) {
            conSettings.setEncryptionKeyStorePassword(this.getProperty(OPTIONS_ENCRYPTION_TRUST_STORE_PASSWORD));
        }
        if (this.getProperty(OPTIONS_ENCRYPTION_REMOTE_TRUST_STORE) != null) {
            conSettings.setEncryptionRemoteTrustStoreName(this.getProperty(OPTIONS_ENCRYPTION_REMOTE_TRUST_STORE));
        }
        if (this.getProperty(OPTIONS_TCP_NO_DELAY) != null) {
            conSettings.setTcpNodelay(this.getBooleanProperty(OPTIONS_TCP_NO_DELAY, true));
        }
        conSettings.setConnectTimeout(this.lookupConnectTimeout());
        if (this.getProperty(OPTIONS_HEARTBEAT) != null) {
            conSettings.setHeartbeatInterval(this.getIntegerProperty(OPTIONS_HEARTBEAT));
        } else if (this.getProperty(OPTIONS_IDLE_TIMEOUT) != null) {
            conSettings.setHeartbeatInterval(this.getIntegerProperty(OPTIONS_IDLE_TIMEOUT) / 1000);
        }
        return conSettings;
    }

    public void setConnectionUrl(AMQConnectionURL connectionUrl) {
        this._connectionUrl = connectionUrl;
    }
}

