/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.crypto.spec.SecretKeySpec;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.Topic;
import org.apache.qpid.QpidException;
import org.apache.qpid.client.AMQConnection;
import org.apache.qpid.client.AMQConnectionDelegate_8_0;
import org.apache.qpid.client.AMQDestination;
import org.apache.qpid.client.AMQProtocolHandler;
import org.apache.qpid.client.AMQSession;
import org.apache.qpid.client.AMQSession_0_8;
import org.apache.qpid.client.BasicMessageProducer;
import org.apache.qpid.client.CustomJMSXProperty;
import org.apache.qpid.client.failover.FailoverException;
import org.apache.qpid.client.message.AMQMessageDelegate_0_8;
import org.apache.qpid.client.message.AbstractJMSMessage;
import org.apache.qpid.client.message.MessageEncryptionHelper;
import org.apache.qpid.client.protocol.BlockingMethodFrameListener;
import org.apache.qpid.client.util.JMSExceptionHelper;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.AMQFrame;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.BasicAckBody;
import org.apache.qpid.framing.BasicContentHeaderProperties;
import org.apache.qpid.framing.BasicNackBody;
import org.apache.qpid.framing.BasicPublishBody;
import org.apache.qpid.framing.CompositeAMQDataBlock;
import org.apache.qpid.framing.ContentBody;
import org.apache.qpid.framing.ContentHeaderBody;
import org.apache.qpid.framing.ExchangeDeclareBody;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.util.GZIPUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicMessageProducer_0_8
extends BasicMessageProducer {
    private static final Logger _logger = LoggerFactory.getLogger(BasicMessageProducer_0_8.class);
    private static final boolean SET_EXPIRATION_AS_TTL = Boolean.getBoolean("qpid.set_expiration_as_ttl");

    BasicMessageProducer_0_8(AMQConnection connection, AMQDestination destination, boolean transacted, int channelId, AMQSession session, AMQProtocolHandler protocolHandler, long producerId, Boolean immediate, Boolean mandatory) throws QpidException {
        super(_logger, connection, destination, transacted, channelId, session, producerId, immediate, mandatory);
    }

    @Override
    void declareDestination(AMQDestination destination) throws QpidException {
        if (destination.getDestSyntax() == AMQDestination.DestSyntax.ADDR) {
            this.getSession().resolveAddress(destination, false, false);
            this.getSession().handleLinkCreation(destination);
            this.getSession().sync();
        } else if (this.getSession().isDeclareExchanges() && !this.getSession().isResolved(destination)) {
            MethodRegistry methodRegistry = this.getSession().getMethodRegistry();
            ExchangeDeclareBody body = methodRegistry.createExchangeDeclareBody(this.getSession().getTicket(), destination.getExchangeName(), destination.getExchangeClass(), destination.getExchangeName().startsWith("amq."), destination.isExchangeDurable(), destination.isExchangeAutoDelete(), destination.isExchangeInternal(), true, null);
            AMQFrame declare = body.generateFrame(this.getChannelId());
            this.getConnection().getProtocolHandler().writeFrame(declare);
            this.getSession().setResolved(destination);
        }
    }

    @Override
    void sendMessage(AMQDestination destination, Message origMessage, AbstractJMSMessage message, UUID messageId, int deliveryMode, int priority, long timeToLive, boolean mandatory, boolean immediate, long deliveryDelay) throws JMSException {
        boolean useConfirms;
        byte[] compressed;
        boolean encrypt;
        long currentTime;
        AMQMessageDelegate_0_8 delegate = (AMQMessageDelegate_0_8)message.getDelegate();
        BasicContentHeaderProperties contentHeaderProperties = delegate.getContentHeaderProperties();
        String routingKey = destination.getRoutingKey();
        FieldTable headers = delegate.getContentHeaderProperties().getHeaders();
        if (destination.getDestSyntax() == AMQDestination.DestSyntax.ADDR && (destination.getSubject() != null || headers != null && headers.get("qpid.subject") != null)) {
            if (headers.get("qpid.subject") == null) {
                headers.setString("qpid.subject", destination.getSubject());
            }
            if (destination.getAddressType() == 2) {
                routingKey = headers.getString("qpid.subject");
            }
        }
        BasicPublishBody body = this.getSession().getMethodRegistry().createBasicPublishBody(this.getSession().getTicket(), destination.getExchangeName(), routingKey, mandatory, immediate);
        AMQFrame publishFrame = body.generateFrame(this.getChannelId());
        message.prepareForSending();
        ByteBuffer payload = message.getData();
        contentHeaderProperties.setUserId(this.getUserID());
        int type = destination instanceof Topic ? 2 : (destination instanceof Queue ? 1 : 3);
        delegate.getContentHeaderProperties().getHeaders().setInteger(CustomJMSXProperty.JMS_QPID_DESTTYPE.getShortStringName(), type);
        if (!this.isDisableTimestamps()) {
            currentTime = System.currentTimeMillis();
            contentHeaderProperties.setTimestamp(currentTime);
            if (timeToLive > 0L) {
                if (!SET_EXPIRATION_AS_TTL) {
                    contentHeaderProperties.setExpiration(currentTime + timeToLive);
                } else {
                    contentHeaderProperties.setExpiration(timeToLive);
                }
            } else {
                contentHeaderProperties.setExpiration(0L);
            }
        } else {
            currentTime = 0L;
        }
        if (deliveryDelay != 0L && headers.get("x-qpid-not-valid-before") == null) {
            if (currentTime == 0L) {
                currentTime = System.currentTimeMillis();
            }
            headers.setLong("x-qpid-not-valid-before", deliveryDelay + currentTime);
        }
        contentHeaderProperties.setDeliveryMode((byte)deliveryMode);
        contentHeaderProperties.setPriority((byte)priority);
        int size = payload != null ? payload.remaining() : 0;
        boolean bl = encrypt = message.getBooleanProperty("x-qpid-encrypt") || destination.sendEncrypted();
        if (encrypt) {
            MessageEncryptionHelper encryptionHelper = this.getSession().getMessageEncryptionHelper();
            try {
                SecretKeySpec secretKey = encryptionHelper.createSecretKey();
                contentHeaderProperties.getHeaders().remove("x-qpid-encrypt");
                String recipientString = message.getStringProperty("x-qpid-encrypt-recipients");
                if (recipientString == null) {
                    recipientString = destination.getEncryptedRecipients();
                }
                contentHeaderProperties.getHeaders().remove("x-qpid-encrypt-recipients");
                String unencryptedProperties = message.getStringProperty("x-qpid-unencrypted-properties");
                contentHeaderProperties.getHeaders().remove("x-qpid-unencrypted-properties");
                int headerLength = contentHeaderProperties.getPropertyListSize() + 2;
                byte[] unencryptedBytes = new byte[headerLength + size];
                ByteBuffer output = ByteBuffer.wrap(unencryptedBytes);
                output.putShort((short)(contentHeaderProperties.getPropertyFlags() & 0xFFFF));
                contentHeaderProperties.writePropertyListPayload(output);
                if (size != 0) {
                    payload.get(unencryptedBytes, headerLength, payload.remaining());
                }
                byte[] ivbytes = encryptionHelper.getInitialisationVector();
                byte[] encryptedBytes = encryptionHelper.encrypt(secretKey, unencryptedBytes, ivbytes);
                payload = ByteBuffer.wrap(encryptedBytes);
                if (recipientString == null) {
                    throw new JMSException("When sending an encrypted message, recipients must be supplied");
                }
                String[] recipients = recipientString.split(";");
                ArrayList<List<Object>> encryptedKeys = new ArrayList<List<Object>>();
                for (MessageEncryptionHelper.KeyTransportRecipientInfo info : encryptionHelper.getKeyTransportRecipientInfo(Arrays.asList(recipients), secretKey)) {
                    encryptedKeys.add(info.asList());
                }
                BasicContentHeaderProperties oldProps = contentHeaderProperties;
                contentHeaderProperties = new BasicContentHeaderProperties(oldProps);
                FieldTable oldHeaders = oldProps.getHeaders();
                FieldTable newHeaders = contentHeaderProperties.getHeaders();
                newHeaders.clear();
                if (unencryptedProperties != null) {
                    List<String> unencryptedPropertyNames = Arrays.asList(unencryptedProperties.split(" *; *"));
                    for (String propertyName : unencryptedPropertyNames) {
                        if (!oldHeaders.propertyExists(propertyName)) continue;
                        newHeaders.setObject(propertyName, oldHeaders.get(propertyName));
                    }
                }
                newHeaders.setObject("x-qpid-encrypted-keys", encryptedKeys);
                newHeaders.setString("x-qpid-encryption-algorithm", encryptionHelper.getMessageEncryptionCipherName());
                newHeaders.setBytes("x-qpid-key-init-vector", ivbytes);
                contentHeaderProperties.setContentType("application/qpid-0-9-1-encrypted");
                size = encryptedBytes.length;
            }
            catch (IOException | GeneralSecurityException e) {
                throw JMSExceptionHelper.chainJMSException(new JMSException("Unexpected Exception while encrypting message"), e);
            }
        } else if (size > this.getConnection().getMessageCompressionThresholdSize() && this.getConnection().getDelegate().isMessageCompressionSupported() && this.getConnection().isMessageCompressionDesired() && contentHeaderProperties.getEncoding() == null && (compressed = GZIPUtils.compressBufferToArray(payload)) != null) {
            contentHeaderProperties.setEncoding("gzip");
            payload = ByteBuffer.wrap(compressed);
            size = compressed.length;
        }
        int contentBodyFrameCount = this.calculateContentBodyFrameCount(payload);
        AMQDataBlock[] frames = new AMQFrame[2 + contentBodyFrameCount];
        if (payload != null) {
            this.createContentBodies(payload, (AMQFrame[])frames, 2, this.getChannelId());
        }
        AMQFrame contentHeaderFrame = ContentHeaderBody.createAMQFrame(this.getChannelId(), contentHeaderProperties, size);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Sending " + (frames.length - 2) + " content body frames to " + destination);
        }
        if (contentHeaderFrame.getSize() > this.getSession().getAMQConnection().getMaximumFrameSize()) {
            throw new JMSException("Unable to send message as the headers are too large (" + contentHeaderFrame.getSize() + " bytes, but the maximum negotiated frame size is " + this.getSession().getAMQConnection().getMaximumFrameSize() + ").");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Sending content header frame to " + destination);
        }
        frames[0] = publishFrame;
        frames[1] = contentHeaderFrame;
        CompositeAMQDataBlock compositeFrame = new CompositeAMQDataBlock(frames);
        try {
            this.getSession().checkFlowControl();
        }
        catch (InterruptedException e) {
            throw JMSExceptionHelper.chainJMSException(new JMSException("Interrupted while waiting for flow control to be removed"), e);
        }
        AMQConnectionDelegate_8_0 connectionDelegate80 = (AMQConnectionDelegate_8_0)this.getConnection().getDelegate();
        boolean bl2 = useConfirms = this.getPublishMode() == BasicMessageProducer.PublishMode.SYNC_PUBLISH_ALL && (connectionDelegate80.isConfirmedPublishSupported() || !this.getSession().isTransacted() && connectionDelegate80.isConfirmedPublishNonTransactionalSupported());
        if (!useConfirms) {
            this.getConnection().getProtocolHandler().writeFrame(compositeFrame);
        } else {
            PublishConfirmMessageListener frameListener = new PublishConfirmMessageListener(this.getChannelId());
            try {
                this.getConnection().getProtocolHandler().writeCommandFrameAndWaitForReply(compositeFrame, frameListener);
                if (frameListener.isRejected()) {
                    throw new JMSException("The message was not accepted by the server (e.g. because the address was no longer valid)");
                }
            }
            catch (QpidException e) {
                throw JMSExceptionHelper.chainJMSException(new JMSException(e.getMessage()), e);
            }
            catch (FailoverException e) {
                throw JMSExceptionHelper.chainJMSException(new JMSException("Fail-over interrupted send. Status of the send is uncertain."), e);
            }
        }
    }

    private void createContentBodies(ByteBuffer payload, AMQFrame[] frames, int offset, int channelId) {
        if (frames.length == offset + 1) {
            frames[offset] = ContentBody.createAMQFrame(channelId, new ContentBody(payload.slice()));
        } else {
            long framePayloadMax = this.getMaximumPayloadSize();
            long remaining = payload.remaining();
            for (int i = offset; i < frames.length; ++i) {
                payload.position((int)framePayloadMax * (i - offset));
                int length = remaining >= framePayloadMax ? (int)framePayloadMax : (int)remaining;
                payload.limit(payload.position() + length);
                frames[i] = ContentBody.createAMQFrame(channelId, new ContentBody(payload.slice()));
                remaining -= (long)length;
            }
        }
    }

    private int calculateContentBodyFrameCount(ByteBuffer payload) {
        int frameCount;
        if (payload == null || payload.remaining() == 0) {
            frameCount = 0;
        } else {
            long framePayloadMax;
            int dataLength = payload.remaining();
            int lastFrame = (long)dataLength % (framePayloadMax = this.getMaximumPayloadSize()) > 0L ? 1 : 0;
            frameCount = (int)((long)dataLength / framePayloadMax) + lastFrame;
        }
        return frameCount;
    }

    private long getMaximumPayloadSize() {
        return this.getSession().getAMQConnection().getMaximumFrameSize() - 8L;
    }

    @Override
    public AMQSession_0_8 getSession() {
        return (AMQSession_0_8)super.getSession();
    }

    private static class PublishConfirmMessageListener
    extends BlockingMethodFrameListener {
        private boolean _rejected;

        public PublishConfirmMessageListener(int channelId) {
            super(channelId);
        }

        @Override
        public boolean processMethod(int channelId, AMQMethodBody frame) {
            if (frame instanceof BasicAckBody) {
                return true;
            }
            if (frame instanceof BasicNackBody) {
                this._rejected = true;
                return true;
            }
            return false;
        }

        public boolean isRejected() {
            return this._rejected;
        }
    }
}

