/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.zookeeper;

import io.prometheus.client.exporter.MetricsServlet;
import io.prometheus.client.hotspot.DefaultExports;
import java.net.InetSocketAddress;
import javax.servlet.Servlet;
import org.apache.zookeeper.server.quorum.QuorumPeerMain;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperStarter {
    private static final Logger log = LoggerFactory.getLogger(ZooKeeperStarter.class);

    public static void main(String[] args) throws Exception {
        ZooKeeperStarter.start(args, "8000");
    }

    protected static void start(String[] args, String defaultStatsPort) throws Exception {
        DefaultExports.initialize();
        int port = Integer.parseInt(System.getProperties().getProperty("stats_server_port", defaultStatsPort));
        log.info("Starting ZK stats HTTP server at port {}", (Object)port);
        InetSocketAddress httpEndpoint = InetSocketAddress.createUnresolved("0.0.0.0", port);
        Server server = new Server(httpEndpoint);
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        server.setHandler((Handler)context);
        context.addServlet(new ServletHolder((Servlet)new MetricsServlet()), "/metrics");
        try {
            server.start();
        }
        catch (Exception e) {
            log.error("Failed to start HTTP server at port {}. Use \"-Dstats_server_port=1234\" to change port number", (Object)port, (Object)e);
            throw e;
        }
        QuorumPeerMain.main(args);
    }
}

