/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.impl.batching;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.pulsar.metadata.api.Stat;
import org.apache.pulsar.metadata.api.extended.CreateOption;
import org.apache.pulsar.metadata.impl.batching.MetadataOp;

public class OpPut
implements MetadataOp {
    private final String path;
    private final byte[] data;
    private final Optional<Long> optExpectedVersion;
    private final EnumSet<CreateOption> options;
    public final long created = System.currentTimeMillis();
    private final CompletableFuture<Stat> future = new CompletableFuture();

    public boolean isEphemeral() {
        return this.options.contains((Object)CreateOption.Ephemeral);
    }

    @Override
    public MetadataOp.Type getType() {
        return MetadataOp.Type.PUT;
    }

    @Override
    public int size() {
        return this.path.length() + (this.data != null ? this.data.length : 0);
    }

    @Override
    public long created() {
        return this.created;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public byte[] getData() {
        return this.data;
    }

    @Generated
    public Optional<Long> getOptExpectedVersion() {
        return this.optExpectedVersion;
    }

    @Generated
    public EnumSet<CreateOption> getOptions() {
        return this.options;
    }

    @Generated
    public long getCreated() {
        return this.created;
    }

    @Generated
    public CompletableFuture<Stat> getFuture() {
        return this.future;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpPut)) {
            return false;
        }
        OpPut other = (OpPut)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCreated() != other.getCreated()) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        if (!Arrays.equals(this.getData(), other.getData())) {
            return false;
        }
        Optional<Long> this$optExpectedVersion = this.getOptExpectedVersion();
        Optional<Long> other$optExpectedVersion = other.getOptExpectedVersion();
        if (this$optExpectedVersion == null ? other$optExpectedVersion != null : !((Object)this$optExpectedVersion).equals(other$optExpectedVersion)) {
            return false;
        }
        EnumSet<CreateOption> this$options = this.getOptions();
        EnumSet<CreateOption> other$options = other.getOptions();
        if (this$options == null ? other$options != null : !((Object)this$options).equals(other$options)) {
            return false;
        }
        CompletableFuture<Stat> this$future = this.getFuture();
        CompletableFuture<Stat> other$future = other.getFuture();
        return !(this$future == null ? other$future != null : !this$future.equals(other$future));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OpPut;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $created = this.getCreated();
        result = result * 59 + (int)($created >>> 32 ^ $created);
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        result = result * 59 + Arrays.hashCode(this.getData());
        Optional<Long> $optExpectedVersion = this.getOptExpectedVersion();
        result = result * 59 + ($optExpectedVersion == null ? 43 : ((Object)$optExpectedVersion).hashCode());
        EnumSet<CreateOption> $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        CompletableFuture<Stat> $future = this.getFuture();
        result = result * 59 + ($future == null ? 43 : $future.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OpPut(path=" + this.getPath() + ", data=" + Arrays.toString(this.getData()) + ", optExpectedVersion=" + String.valueOf(this.getOptExpectedVersion()) + ", options=" + String.valueOf(this.getOptions()) + ", created=" + this.getCreated() + ", future=" + String.valueOf(this.getFuture()) + ")";
    }

    @Generated
    public OpPut(String path, byte[] data, Optional<Long> optExpectedVersion, EnumSet<CreateOption> options) {
        this.path = path;
        this.data = data;
        this.optExpectedVersion = optExpectedVersion;
        this.options = options;
    }
}

