/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.netty.server;

import com.google.common.base.Preconditions;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.io.netty.NettySource;
import org.apache.pulsar.io.netty.http.NettyHttpChannelInitializer;
import org.apache.pulsar.io.netty.http.NettyHttpServerHandler;
import org.apache.pulsar.io.netty.tcp.NettyTCPChannelInitializer;
import org.apache.pulsar.io.netty.tcp.NettyTCPServerHandler;
import org.apache.pulsar.io.netty.udp.NettyUDPChannelInitializer;
import org.apache.pulsar.io.netty.udp.NettyUDPServerHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyServer {
    private static final Logger logger = LoggerFactory.getLogger(NettyServer.class);
    private Type type;
    private String host;
    private int port;
    private NettySource nettySource;
    private int numberOfThreads;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;

    private NettyServer(Builder builder) {
        this.type = builder.type;
        this.host = builder.host;
        this.port = builder.port;
        this.nettySource = builder.nettySource;
        this.numberOfThreads = builder.numberOfThreads;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        try {
            switch (this.type.ordinal()) {
                case 1: {
                    this.runUdp();
                    return;
                }
                case 2: {
                    this.runHttp();
                    return;
                }
                default: {
                    this.runTcp();
                    return;
                }
            }
        }
        catch (Exception ex) {
            logger.error("Error occurred when Netty Server is running", (Throwable)ex);
            return;
        }
        finally {
            this.shutdownGracefully();
        }
    }

    public void shutdownGracefully() {
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully();
        }
        if (this.bossGroup != null) {
            this.bossGroup.shutdownGracefully();
        }
    }

    private void runUdp() throws InterruptedException {
        this.workerGroup = new NioEventLoopGroup(this.numberOfThreads);
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group(this.workerGroup);
        bootstrap.channel(NioDatagramChannel.class);
        ((Bootstrap)bootstrap.handler((ChannelHandler)new NettyUDPChannelInitializer((ChannelInboundHandlerAdapter)new NettyUDPServerHandler(this.nettySource)))).option(ChannelOption.SO_BACKLOG, (Object)1024);
        ChannelFuture channelFuture = bootstrap.bind(this.host, this.port).sync();
        channelFuture.channel().closeFuture().sync();
    }

    private void runTcp() throws InterruptedException {
        ServerBootstrap serverBootstrap = this.getServerBootstrap((ChannelHandler)new NettyTCPChannelInitializer((ChannelInboundHandlerAdapter)new NettyTCPServerHandler(this.nettySource)));
        ChannelFuture channelFuture = serverBootstrap.bind(this.host, this.port).sync();
        channelFuture.channel().closeFuture().sync();
    }

    private void runHttp() throws InterruptedException {
        ServerBootstrap serverBootstrap = this.getServerBootstrap((ChannelHandler)new NettyHttpChannelInitializer((ChannelInboundHandlerAdapter)new NettyHttpServerHandler(this.nettySource), null));
        ChannelFuture channelFuture = serverBootstrap.bind(this.host, this.port).sync();
        channelFuture.channel().closeFuture().sync();
    }

    private ServerBootstrap getServerBootstrap(ChannelHandler childHandler) {
        this.bossGroup = new NioEventLoopGroup(this.numberOfThreads);
        this.workerGroup = new NioEventLoopGroup(this.numberOfThreads);
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        serverBootstrap.group(this.bossGroup, this.workerGroup);
        serverBootstrap.channel(NioServerSocketChannel.class);
        ((ServerBootstrap)serverBootstrap.childHandler(childHandler).option(ChannelOption.SO_BACKLOG, (Object)1024)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        return serverBootstrap;
    }

    public static class Builder {
        private Type type;
        private String host;
        private int port;
        private NettySource nettySource;
        private int numberOfThreads;

        public Builder setType(Type type) {
            this.type = type;
            return this;
        }

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public Builder setNettySource(NettySource nettySource) {
            this.nettySource = nettySource;
            return this;
        }

        public Builder setNumberOfThreads(int numberOfThreads) {
            this.numberOfThreads = numberOfThreads;
            return this;
        }

        public NettyServer build() {
            Preconditions.checkNotNull((Object)((Object)this.type), (Object)"type cannot be blank/null");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.host), (Object)"host cannot be blank/null");
            Preconditions.checkArgument((this.port >= 1024 ? 1 : 0) != 0, (Object)"port must be set equal or bigger than 1024");
            Preconditions.checkNotNull((Object)((Object)this.nettySource), (Object)"nettySource must be set");
            Preconditions.checkArgument((this.numberOfThreads > 0 ? 1 : 0) != 0, (Object)"numberOfThreads must be set as positive");
            return new NettyServer(this);
        }
    }

    public static enum Type {
        TCP,
        UDP,
        HTTP;

    }
}

