/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.utils;

import java.io.IOException;
import java.io.UncheckedIOException;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.pool.TypePool;
import org.apache.pulsar.common.nar.NarClassLoader;
import org.apache.pulsar.functions.utils.ValidatableFunctionPackage;
import org.apache.pulsar.functions.utils.functions.FunctionUtils;

public class LoadedFunctionPackage
implements ValidatableFunctionPackage {
    private final ClassLoader classLoader;
    private final Object configMetadata;
    private final TypePool typePool;

    public <T> LoadedFunctionPackage(ClassLoader classLoader, Class<T> configMetadataClass, T configMetadata) {
        this.classLoader = classLoader;
        this.configMetadata = configMetadata;
        this.typePool = TypePool.Default.of((ClassFileLocator)ClassFileLocator.ForClassLoader.of((ClassLoader)classLoader));
    }

    public LoadedFunctionPackage(ClassLoader classLoader, Class<?> configMetadataClass) {
        this.classLoader = classLoader;
        if (classLoader instanceof NarClassLoader) {
            try {
                this.configMetadata = FunctionUtils.getPulsarIOServiceConfig((NarClassLoader)classLoader, configMetadataClass);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        } else {
            this.configMetadata = null;
        }
        this.typePool = TypePool.Default.of((ClassFileLocator)ClassFileLocator.ForClassLoader.of((ClassLoader)classLoader));
    }

    @Override
    public TypeDescription resolveType(String className) {
        return this.typePool.describe(className).resolve();
    }

    @Override
    public TypePool getTypePool() {
        return this.typePool;
    }

    @Override
    public <T> T getFunctionMetaData(Class<T> clazz) {
        return this.configMetadata != null ? (T)clazz.cast(this.configMetadata) : null;
    }

    @Override
    public boolean isEnableClassloading() {
        return true;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

