/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.core.parsetools.impl;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.core.JsonToken;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.buffer.Buffer;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.json.DecodeException;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.json.JsonArray;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.json.JsonObject;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.json.impl.JsonUtil;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.json.jackson.JacksonFactory;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.parsetools.JsonEvent;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.parsetools.JsonEventType;

public class JsonEventImpl
implements JsonEvent {
    private final JsonToken token;
    private final JsonEventType type;
    private final String field;
    private final Object value;

    public JsonEventImpl(JsonToken token, JsonEventType type, String field, Object value) {
        this.token = token;
        this.type = type;
        this.field = field;
        this.value = value;
    }

    public JsonToken token() {
        return this.token;
    }

    @Override
    public JsonEventType type() {
        return this.type;
    }

    @Override
    public String fieldName() {
        return this.field;
    }

    @Override
    public Object value() {
        return this.value;
    }

    @Override
    public boolean isNumber() {
        return this.value instanceof Number;
    }

    @Override
    public boolean isBoolean() {
        return this.value instanceof Boolean;
    }

    @Override
    public boolean isString() {
        return this.value instanceof String;
    }

    @Override
    public boolean isNull() {
        return this.type == JsonEventType.VALUE && this.value == null;
    }

    @Override
    public boolean isObject() {
        return this.value instanceof JsonObject;
    }

    @Override
    public boolean isArray() {
        return this.value instanceof JsonArray;
    }

    @Override
    public <T> T mapTo(Class<T> type) {
        try {
            return JacksonFactory.CODEC.fromValue(this.value, type);
        }
        catch (Exception e) {
            throw new DecodeException(e.getMessage(), e);
        }
    }

    @Override
    public <T> T mapTo(TypeReference<T> type) {
        try {
            return JacksonFactory.CODEC.fromValue(this.value, type);
        }
        catch (Exception e) {
            throw new DecodeException(e.getMessage(), e);
        }
    }

    @Override
    public Integer integerValue() {
        if (this.value != null) {
            Number number = (Number)this.value;
            if (this.value instanceof Integer) {
                return (Integer)this.value;
            }
            return number.intValue();
        }
        return null;
    }

    @Override
    public Long longValue() {
        if (this.value != null) {
            Number number = (Number)this.value;
            if (this.value instanceof Integer) {
                return (Long)this.value;
            }
            return number.longValue();
        }
        return null;
    }

    @Override
    public Float floatValue() {
        if (this.value != null) {
            Number number = (Number)this.value;
            if (this.value instanceof Float) {
                return (Float)this.value;
            }
            return Float.valueOf(number.floatValue());
        }
        return null;
    }

    @Override
    public Double doubleValue() {
        if (this.value != null) {
            Number number = (Number)this.value;
            if (this.value instanceof Double) {
                return (Double)this.value;
            }
            return number.doubleValue();
        }
        return null;
    }

    @Override
    public Boolean booleanValue() {
        return (Boolean)this.value;
    }

    @Override
    public String stringValue() {
        return (String)this.value;
    }

    @Override
    public Buffer binaryValue() {
        return this.value != null ? Buffer.buffer(JsonUtil.BASE64_DECODER.decode((String)this.value)) : null;
    }

    @Override
    public Instant instantValue() {
        return this.value != null ? Instant.from(DateTimeFormatter.ISO_INSTANT.parse((CharSequence)this.value)) : null;
    }

    @Override
    public JsonObject objectValue() {
        return (JsonObject)this.value;
    }

    @Override
    public JsonArray arrayValue() {
        return (JsonArray)this.value;
    }
}

