/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl;

import java.util.function.Function;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.compression.CompressionOptions;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http2.AbstractHttp2ConnectionHandlerBuilder;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http2.CompressorHttp2ConnectionEncoder;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http2.DefaultHttp2Connection;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http2.DefaultHttp2RemoteFlowController;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Connection;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2ConnectionDecoder;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2ConnectionEncoder;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Exception;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Flags;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FlowController;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameListener;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameLogger;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Headers;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http2.StreamByteDistributor;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http2.UniformStreamByteDistributor;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http2.WeightedFairQueueByteDistributor;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.logging.LogLevel;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.Http2Settings;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.Http2ConnectionBase;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.HttpUtils;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.VertxHttp2ConnectionHandler;

class VertxHttp2ConnectionHandlerBuilder<C extends Http2ConnectionBase>
extends AbstractHttp2ConnectionHandlerBuilder<VertxHttp2ConnectionHandler<C>, VertxHttp2ConnectionHandlerBuilder<C>> {
    private boolean useUniformStreamByteDistributor;
    private boolean useDecompression;
    private CompressionOptions[] compressionOptions;
    private Function<VertxHttp2ConnectionHandler<C>, C> connectionFactory;
    private boolean logEnabled;
    private boolean server;

    VertxHttp2ConnectionHandlerBuilder() {
    }

    protected VertxHttp2ConnectionHandlerBuilder<C> server(boolean isServer) {
        this.server = isServer;
        return this;
    }

    VertxHttp2ConnectionHandlerBuilder<C> initialSettings(Http2Settings settings) {
        HttpUtils.fromVertxInitialSettings(this.server, settings, this.initialSettings());
        return this;
    }

    VertxHttp2ConnectionHandlerBuilder<C> useCompression(CompressionOptions[] compressionOptions) {
        this.compressionOptions = compressionOptions;
        return this;
    }

    VertxHttp2ConnectionHandlerBuilder<C> useUniformStreamByteDistributor(boolean useUniformStreamByteDistributor) {
        this.useUniformStreamByteDistributor = useUniformStreamByteDistributor;
        return this;
    }

    protected VertxHttp2ConnectionHandlerBuilder<C> decoderEnforceMaxRstFramesPerWindow(int maxRstFramesPerWindow, int secondsPerWindow) {
        return (VertxHttp2ConnectionHandlerBuilder)super.decoderEnforceMaxRstFramesPerWindow(maxRstFramesPerWindow, secondsPerWindow);
    }

    protected VertxHttp2ConnectionHandlerBuilder<C> gracefulShutdownTimeoutMillis(long gracefulShutdownTimeoutMillis) {
        return (VertxHttp2ConnectionHandlerBuilder)super.gracefulShutdownTimeoutMillis(gracefulShutdownTimeoutMillis);
    }

    VertxHttp2ConnectionHandlerBuilder<C> useDecompression(boolean useDecompression) {
        this.useDecompression = useDecompression;
        return this;
    }

    VertxHttp2ConnectionHandlerBuilder<C> connectionFactory(Function<VertxHttp2ConnectionHandler<C>, C> connectionFactory) {
        this.connectionFactory = connectionFactory;
        return this;
    }

    VertxHttp2ConnectionHandlerBuilder<C> logEnabled(boolean logEnabled) {
        this.logEnabled = logEnabled;
        return this;
    }

    protected VertxHttp2ConnectionHandler<C> build() {
        if (this.logEnabled) {
            this.frameLogger(new Http2FrameLogger(LogLevel.DEBUG));
        }
        this.configureStreamByteDistributor();
        this.frameListener(new Http2FrameListener(){

            public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
                throw new UnsupportedOperationException();
            }

            public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endOfStream) throws Http2Exception {
                throw new UnsupportedOperationException();
            }

            public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) throws Http2Exception {
                throw new UnsupportedOperationException();
            }

            public void onPriorityRead(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) throws Http2Exception {
                throw new UnsupportedOperationException();
            }

            public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) throws Http2Exception {
                throw new UnsupportedOperationException();
            }

            public void onSettingsAckRead(ChannelHandlerContext ctx) throws Http2Exception {
                throw new UnsupportedOperationException();
            }

            public void onSettingsRead(ChannelHandlerContext ctx, org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Settings settings) throws Http2Exception {
                throw new UnsupportedOperationException();
            }

            public void onPingRead(ChannelHandlerContext channelHandlerContext, long l) throws Http2Exception {
                throw new UnsupportedOperationException();
            }

            public void onPingAckRead(ChannelHandlerContext channelHandlerContext, long l) throws Http2Exception {
                throw new UnsupportedOperationException();
            }

            public void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) throws Http2Exception {
                throw new UnsupportedOperationException();
            }

            public void onGoAwayRead(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData) throws Http2Exception {
                throw new UnsupportedOperationException();
            }

            public void onWindowUpdateRead(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) throws Http2Exception {
                throw new UnsupportedOperationException();
            }

            public void onUnknownFrame(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf payload) throws Http2Exception {
                throw new UnsupportedOperationException();
            }
        });
        return (VertxHttp2ConnectionHandler)super.build();
    }

    private void configureStreamByteDistributor() {
        DefaultHttp2Connection conn = new DefaultHttp2Connection(this.server, this.maxReservedStreams());
        Object distributor = this.useUniformStreamByteDistributor ? new UniformStreamByteDistributor((Http2Connection)conn) : new WeightedFairQueueByteDistributor((Http2Connection)conn);
        conn.remote().flowController((Http2FlowController)new DefaultHttp2RemoteFlowController((Http2Connection)conn, (StreamByteDistributor)distributor));
        this.connection((Http2Connection)conn);
    }

    protected VertxHttp2ConnectionHandler<C> build(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Settings initialSettings) throws Exception {
        if (this.server) {
            if (this.compressionOptions != null) {
                encoder = new CompressorHttp2ConnectionEncoder(encoder, this.compressionOptions);
            }
            VertxHttp2ConnectionHandler<C> handler = new VertxHttp2ConnectionHandler<C>(this.connectionFactory, this.useDecompression, decoder, encoder, initialSettings);
            decoder.frameListener(handler);
            return handler;
        }
        VertxHttp2ConnectionHandler<C> handler = new VertxHttp2ConnectionHandler<C>(this.connectionFactory, this.useDecompression, decoder, encoder, initialSettings);
        decoder.frameListener(handler);
        return handler;
    }
}

