/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.util;

import java.util.UUID;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.util.ReflectionUtils;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.conf.AbstractConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LedgerIdFormatter {
    private static final Logger LOG = LoggerFactory.getLogger(LedgerIdFormatter.class);
    public static final LedgerIdFormatter LONG_LEDGERID_FORMATTER = new LongLedgerIdFormatter();

    public abstract String formatLedgerId(long var1);

    public abstract long readLedgerId(String var1);

    public static LedgerIdFormatter newLedgerIdFormatter(AbstractConfiguration<?> conf) {
        LedgerIdFormatter formatter;
        try {
            Class<LedgerIdFormatter> ledgerIdFormatterClass = conf.getLedgerIdFormatterClass();
            formatter = ReflectionUtils.newInstance(ledgerIdFormatterClass);
        }
        catch (Exception e) {
            LOG.warn("No formatter class found", (Throwable)e);
            LOG.warn("Using Default Long Formatter.");
            formatter = new LongLedgerIdFormatter();
        }
        return formatter;
    }

    public static LedgerIdFormatter newLedgerIdFormatter(String opt, AbstractConfiguration conf) {
        LedgerIdFormatter formatter;
        if ("hex".equals(opt)) {
            formatter = new HexLedgerIdFormatter();
        } else if ("uuid".equals(opt)) {
            formatter = new UUIDLedgerIdFormatter();
        } else if ("long".equals(opt)) {
            formatter = new LongLedgerIdFormatter();
        } else {
            LOG.warn("specified unexpected ledgeridformat {}, so default LedgerIdFormatter is used", (Object)opt);
            formatter = LedgerIdFormatter.newLedgerIdFormatter(conf);
        }
        return formatter;
    }

    public static class UUIDLedgerIdFormatter
    extends LedgerIdFormatter {
        @Override
        public String formatLedgerId(long ledgerId) {
            return new UUID(0L, ledgerId).toString();
        }

        @Override
        public long readLedgerId(String ledgerIdString) {
            return UUID.fromString(ledgerIdString.trim()).getLeastSignificantBits();
        }
    }

    public static class HexLedgerIdFormatter
    extends LedgerIdFormatter {
        @Override
        public String formatLedgerId(long ledgerId) {
            return Long.toHexString(ledgerId);
        }

        @Override
        public long readLedgerId(String ledgerIdString) {
            return Long.valueOf(ledgerIdString.trim(), 16);
        }
    }

    public static class LongLedgerIdFormatter
    extends LedgerIdFormatter {
        @Override
        public String formatLedgerId(long ledgerId) {
            return Long.toString(ledgerId);
        }

        @Override
        public long readLedgerId(String ledgerIdString) {
            return Long.parseLong(ledgerIdString.trim());
        }
    }
}

