/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;

public class NativeAvroBytesSchema<T>
implements Schema<byte[]> {
    private final org.apache.pulsar.functions.runtime.shaded.org.apache.avro.Schema nativeSchema;
    private final SchemaInfo schemaInfo;

    public NativeAvroBytesSchema(org.apache.pulsar.functions.runtime.shaded.org.apache.avro.Schema schema) {
        Objects.requireNonNull(schema, "Avro schema cannot be null");
        this.nativeSchema = schema;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("__alwaysAllowNull", "true");
        properties.put("__jsr310ConversionEnabled", "false");
        this.schemaInfo = SchemaInfo.builder().name("").schema(schema.toString().getBytes(StandardCharsets.UTF_8)).properties(properties).type(SchemaType.AVRO).build();
    }

    public NativeAvroBytesSchema(Object schema) {
        this(NativeAvroBytesSchema.validateSchema(schema));
    }

    private static org.apache.pulsar.functions.runtime.shaded.org.apache.avro.Schema validateSchema(Object schema) {
        if (!(schema instanceof org.apache.pulsar.functions.runtime.shaded.org.apache.avro.Schema)) {
            throw new IllegalArgumentException("The input schema is not of type 'org.apache.avro.Schema'.");
        }
        return (org.apache.pulsar.functions.runtime.shaded.org.apache.avro.Schema)schema;
    }

    @Override
    public byte[] encode(byte[] message) {
        return message;
    }

    @Override
    public byte[] decode(byte[] bytes, byte[] schemaVersion) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SchemaInfo getSchemaInfo() {
        return this.schemaInfo;
    }

    @Override
    public Optional<Object> getNativeSchema() {
        return Optional.of(this.nativeSchema);
    }

    @Override
    public Schema<byte[]> clone() {
        return new NativeAvroBytesSchema<T>(this.nativeSchema);
    }
}

