/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.web;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongUpDownCounter;
import org.apache.pulsar.broker.web.WebExecutorThreadPool;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.annotations.VisibleForTesting;

public class WebExecutorThreadPoolStats
implements AutoCloseable {
    public static final String LIMIT_COUNTER = "pulsar.web.executor.thread.limit";
    private final ObservableLongUpDownCounter limitCounter;
    public static final String USAGE_COUNTER = "pulsar.web.executor.thread.usage";
    private final ObservableLongUpDownCounter usageCounter;
    public static final AttributeKey<String> LIMIT_TYPE_KEY = AttributeKey.stringKey((String)"pulsar.web.executor.thread.limit.type");
    public static final AttributeKey<String> USAGE_TYPE_KEY = AttributeKey.stringKey((String)"pulsar.web.executor.thread.usage.type");

    public WebExecutorThreadPoolStats(Meter meter, WebExecutorThreadPool executor) {
        this.limitCounter = meter.upDownCounterBuilder(LIMIT_COUNTER).setUnit("{thread}").setDescription("The thread limits for the pulsar-web executor pool.").buildWithCallback(measurement -> {
            measurement.record((long)executor.getMaxThreads(), LimitType.MAX.attributes);
            measurement.record((long)executor.getMinThreads(), LimitType.MIN.attributes);
        });
        this.usageCounter = meter.upDownCounterBuilder(USAGE_COUNTER).setUnit("{thread}").setDescription("The current usage of threads in the pulsar-web executor pool.").buildWithCallback(measurement -> {
            int idleThreads = executor.getIdleThreads();
            int currentThreads = executor.getThreads();
            measurement.record((long)idleThreads, UsageType.IDLE.attributes);
            measurement.record((long)currentThreads, UsageType.CURRENT.attributes);
            measurement.record((long)(currentThreads - idleThreads), UsageType.ACTIVE.attributes);
        });
    }

    @Override
    public synchronized void close() {
        this.limitCounter.close();
        this.usageCounter.close();
    }

    @VisibleForTesting
    static enum UsageType {
        ACTIVE,
        CURRENT,
        IDLE;

        public final Attributes attributes = Attributes.of(USAGE_TYPE_KEY, (Object)this.name().toLowerCase());
    }

    @VisibleForTesting
    static enum LimitType {
        MAX,
        MIN;

        public final Attributes attributes = Attributes.of(LIMIT_TYPE_KEY, (Object)this.name().toLowerCase());
    }
}

